// Copyright (C) 2006 The Mozile Team. See http://mozile.mozdev.org/ for details.

function MozileBlockSetCommand(configString){this._configString=String(configString);}
MozileBlockSetCommand.prototype=new MozileCommand();MozileBlockSetCommand.prototype.constructor=MozileBlockSetCommand;MozileBlockSetCommand.prototype.getTag=function(){if(!this.getOption("tag"))throw Error("Invalid configuration string.");return this.getOption("tag");}
MozileBlockSetCommand.prototype.getMenuitem=function(){if(!this._menuitem){this._createMenuitem();this._menuitem.setAttribute("type","checkbox");}
return this._menuitem;}
MozileBlockSetCommand.prototype.isActive=function(){var selection=window.getSelection();var range=selection.getRangeAt(0);var node=range.commonAncestorContainer;var parentBlock=node.parentBlock;if(parentBlock.nodeName.toLowerCase()==this.getTag()){return true;}
else{return false;}}
MozileBlockSetCommand.prototype.execute=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();if(!selection.isCollapsed){var element=document.createElement(this.getTag());element.appendChild(range.extractContents());range.insertNode(element);return;}
var node=range.commonAncestorContainer;node=node.parentBlock;if(node.parentNode){var focusOffset=selection.focusOffset;range.selectNodeContents(node);var contents=range.extractContents();var newNode=document.createElement(this.getTag());newNode.appendChild(contents);node.parentNode.replaceChild(newNode,node);range=document.createRange();try{range.setStart(newNode.firstChild,focusOffset);}catch(e){range.setStart(newNode.firstChild,0);}
selection.removeAllRanges();selection.addRange(range);}}
function MozileUnformatCommand(configString){this._configString=String(configString);}
MozileUnformatCommand.prototype=new MozileCommand();MozileUnformatCommand.prototype.constructor=MozileUnformatCommand;MozileUnformatCommand.prototype.execute=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();var contents,text;if(!selection.isCollapsed){contents=range.toString();text=document.createTextNode(contents);range.deleteContents();range.insertNode(text);range.selectNode(text);selection.removeAllRanges();selection.addRange(range);}
else{var focusOffset=selection.focusOffset;var node=range.commonAncestorContainer;if(node.nodeType!=1)node=node.parentNode;range.selectNodeContents(node);contents=range.extractContents();var firstChild=contents.firstChild;range.selectNode(node);range.insertNode(contents);try{range.setStart(firstChild,focusOffset);}
catch(e){range.setStart(firstChild,0);}
range.collapse(true);selection.removeAllRanges()
selection.addRange(range);}}
function MozileWrapCommand(configString){this._configString=String(configString);}
MozileWrapCommand.prototype=new MozileCommand();MozileWrapCommand.prototype.constructor=MozileWrapCommand;MozileWrapCommand.prototype.getMode=function(){if(!this.getOption("mode"))throw Error("Invalid configuration string.");return this.getOption("mode");}
MozileWrapCommand.prototype.getTag=function(){if(!this.getOption("tag"))throw Error("Invalid configuration string.");return this.getOption("tag");}
MozileWrapCommand.prototype.getMenuitem=function(){if(!this._menuitem){this._createMenuitem();this._menuitem.setAttribute("type","checkbox");}
return this._menuitem;}
MozileWrapCommand.prototype.isActive=function(){var selection=window.getSelection();var range=selection.getRangeAt(0);var node=range.commonAncestorContainer;var flag=false;while(node){if(node.nodeName.toLowerCase()==this.getTag()){flag=true;break;}
node=node.parentNode;}
return flag;}
MozileWrapCommand.prototype.execute=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();var container,element,text,oldRange,blocks,firstElement,lastElement,i,flag;switch(this.getMode()){case"inline":if(selection.isCollapsed){element=document.createElement(this.getTag());text=document.createTextNode("");element.appendChild(text);range.insertNode(element);range.selectNode(text);range.collapse(true);selection.removeAllRanges();selection.addRange(range);}
else{element=document.createElement(this.getTag());range=this._wrapRange(range,element)
selection.removeAllRanges();selection.addRange(range);}
return true;break;case"toggle":if(this.isActive()){container=range.commonAncestorContainer;flag=false;while(container){if(container.nodeName.toLowerCase()==this.getTag()){flag=true;break;}
container=container.parentNode;}
element=document.createElement(this.getTag());range=this._unwrapRange(container,range,element);selection.removeAllRanges();selection.addRange(range);}
else{if(selection.isCollapsed){element=document.createElement(this.getTag());text=document.createTextNode("");element.appendChild(text);range.insertNode(element);range.selectNode(text);range.collapse(true);selection.removeAllRanges();selection.addRange(range);}
else{element=document.createElement(this.getTag());range=this._wrapRange(range,element);selection.removeAllRanges();selection.addRange(range);}}
return true;break;default:element=document.createElement(this.getTag());element.appendChild(range.extractContents());range.insertNode(element);if(selection.isCollapsed){text=document.createTextNode("");element.appendChild(text);range.selectNodeContents(text);selection.removeAllRanges();selection.addRange(range);selection.collapseToEnd();}
else{range.selectNodeContents(element);selection.removeAllRanges();selection.addRange(range);}
return true;break;}
return true;}
MozileWrapCommand.prototype._wrapBlock=function(block,element){var range=document.createRange();if(block.nodeType==1){range.selectNodeContents(block);}
else{range.selectNode(block);}
element.appendChild(range.extractContents());range.insertNode(element);return element;}
MozileWrapCommand.prototype._wrapInline=function(range,element){element.appendChild(range.extractContents());range.insertNode(element);return element;}
MozileWrapCommand.prototype._wrapRange=function(range,elementTemplate){var blocks;try{blocks=range.getBlocks();}catch(e){blocks=range.wrappedJSObject.getBlocks();}
var element,firstElement,lastElement;if(blocks.length<2){element=elementTemplate.cloneNode(true);element=this._wrapInline(range,element);range.selectNodeContents(element);}
else{var oldRange=range.cloneRange();range=oldRange.cloneRange();if(blocks[0].nodeType==1){range.setEnd(blocks[0].lastChild,blocks[0].lastChild.textContent.length);}
else{range.setEnd(blocks[0],blocks[0].textContent.length);}
element=elementTemplate.cloneNode(true);firstElement=this._wrapInline(range,element);for(var i=1;i<blocks.length-1;i++){element=elementTemplate.cloneNode(true);this._wrapBlock(blocks[i],element);}
range=oldRange.cloneRange();range.setStart(blocks[blocks.length-1],0);element=elementTemplate.cloneNode(true);lastElement=this._wrapInline(range,element);range=document.createRange();range.setStart(firstElement.firstChild,0);range.setEnd(lastElement.lastChild,lastElement.lastChild.textContent.length);}
return range;}
MozileWrapCommand.prototype._unwrapRange=function(container,range,elementTemplate){var collapsed=range.collapsed;var oldRange=range.cloneRange();var element,firstElement,lastElement;range.selectNodeContents(container);range.setStart(oldRange.endContainer,oldRange.endOffset);element=elementTemplate.cloneNode(true);this._wrapInline(range,element);range.selectNodeContents(container);range.setEnd(oldRange.startContainer,oldRange.startOffset);element=elementTemplate.cloneNode(true);this._wrapInline(range,element);range.selectNodeContents(container);var contents=range.extractContents();firstElement=contents.firstChild;lastElement=contents.lastChild;container.parentNode.replaceChild(contents,container);if(collapsed){var text=document.createTextNode("");text=lastElement.parentNode.insertBefore(text,lastElement);range.selectNodeContents(text);range.collapse(true);}
else{range=document.createRange();range.setStartAfter(firstElement);range.setEndBefore(lastElement);}
return range;}
function MozileStyleCommand(configString){this._configString=String(configString);}
MozileStyleCommand.prototype=new MozileWrapCommand();MozileStyleCommand.prototype.constructor=MozileStyleCommand;MozileStyleCommand.prototype.getStyle=function(){if(!this.getOption("style"))throw Error("Invalid configuration string.");return this.getOption("style");}
MozileStyleCommand.prototype.getTag=function(){if(!this.getOption("tag"))this.setOption("tag","span");return this.getOption("tag");}
MozileStyleCommand.prototype.getAttribute=function(){if(!this.getOption("attribute"))this.setOption("attribute","style");return this.getOption("attribute");}
MozileStyleCommand.prototype.isActive=function(){var selection=window.getSelection();var range=selection.getRangeAt(0);var node=range.commonAncestorContainer;var flag=false;while(node){if(node.nodeType==1&&node.getAttribute(this.getAttribute())&&node.getAttribute(this.getAttribute()).match("(^|\W)"+this.getStyle())){flag=true;break;}
node=node.parentNode;}
return flag;}
MozileStyleCommand.prototype.execute=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();var container,element,text,style,oldRange,blocks,firstElement,lastElement,i,flag;switch(this.getMode()){case"inline":if(selection.isCollapsed){element=document.createElement(this.getTag());element.setAttribute("style",this.getStyle());text=document.createTextNode("");element.appendChild(text);range.insertNode(element);range.selectNode(text);range.collapse(true);selection.removeAllRanges();selection.addRange(range);}
else{element=document.createElement(this.getTag());element.setAttribute("style",this.getStyle());range=this._wrapRange(range,element)
selection.removeAllRanges();selection.addRange(range);}
return;break;case"toggle":if(this.isActive()){container=range.commonAncestorContainer;while(container){if(container.nodeType==1&&container.getAttribute("style")&&container.getAttribute("style").match(this.getStyle())){break;}
container=container.parentNode;}
element=document.createElement(this.getTag());element.setAttribute("style",this.getStyle());range=this._unwrapRange(container,range,element);selection.removeAllRanges();selection.addRange(range);}
else{if(selection.isCollapsed){element=document.createElement(this.getTag());element.setAttribute("style",this.getStyle());text=document.createTextNode("");element.appendChild(text);range.insertNode(element);range.selectNode(text);range.collapse(true);selection.removeAllRanges();selection.addRange(range);}
else{element=document.createElement(this.getTag());element.setAttribute("style",this.getStyle());range=this._wrapRange(range,element);selection.removeAllRanges();selection.addRange(range);}}
return;break;case"toggleBlock":if(this.isActive()){container=range.commonAncestorContainer;while(container){if(container.nodeType==1&&container.getAttribute(this.getAttribute())&&container.getAttribute(this.getAttribute()).match(this.getStyle())){break;}
container=container.parentNode;}
element=container;style=element.getAttribute(this.getAttribute());style=style.replace(this.getStyle(),"");element.setAttribute(this.getAttribute(),style);}
else{container=range.commonAncestorContainer;element=container.parentBlock;style=element.getAttribute(this.getAttribute());if(style&&style!="")style=style+" "+this.getStyle();else style=this.getStyle();element.setAttribute(this.getAttribute(),style);}
return;break;default:container=range.commonAncestorNode;element=container.parentBlock;style=element.getAttribute(this.getAttribute());if(style&&style!="")style=style+" "+this.getStyle();else style=this.getStyle();element.setAttribute(this.getAttribute(),style);return;break;}
return;}
Range.prototype.getTextNodes=function(){var container=this.commonAncestorContainer;container.normalize();var previousNode,startNode,finishNode;if(this.startContainer.nodeType!=3)return false;if(this.endContainer.nodeType!=3)return false;finishNode=this.endContainer.splitText(this.endOffset);startNode=this.startContainer.splitText(this.startOffset);previousNode=startNode.previousSibling;var treeWalker=document.createTreeWalker(container,NodeFilter.SHOW_TEXT,null,false);while(treeWalker.currentNode!=treeWalker.lastNode&&treeWalker.currentNode!=startNode){treeWalker.nextNode();}
var textNodes=new Array();if(!this._matchNonWS)this._matchNonWS=/\S/;var currentNode=treeWalker.currentNode;while(currentNode&&currentNode!=finishNode){if(currentNode.parentNode&&currentNode.parentNode.nodeName.toLowerCase()!="a"&&this._matchNonWS.test(currentNode.textContent)){textNodes.push(currentNode);}
currentNode=treeWalker.nextNode();}
return textNodes;}
Range.prototype.getBlocks=function(){var blockNodes=new Array();if(this.startContainer==this.endContainer||this.startContainer.parentNode==this.endContainer.parentNode)return blockNodes;var container=this.commonAncestorContainer;var treeWalker=document.createTreeWalker(container,NodeFilter.SHOW_ELEMENT+NodeFilter.SHOW_TEXT,null,false);var currentNode=treeWalker.currentNode;var flag=false;var textFlag=false;var parentBlock;while(currentNode){if(currentNode==this.startContainer){flag=true;if(currentNode.nodeType==3&&this.startContainer.parentNode==container){blockNodes.push(currentNode);}
else{blockNodes.push(currentNode.parentBlock);}}
if(flag){if(currentNode.nodeType==1&&currentNode.nodeName.toLowerCase()!="ul"&&currentNode.nodeName.toLowerCase()!="ol"&&currentNode.isBlock()&&!currentNode.isAncestorOf(this.endContainer)){blockNodes.push(currentNode);}
if(!this._matchNonWS)this._matchNonWS=/\S/;if(currentNode.nodeType==3&&currentNode!=this.startContainer&&this._matchNonWS.test(currentNode.textContent)){textFlag=true;parentBlock=currentNode.parentBlock;for(var i=0;i<blockNodes.length;i++){if(parentBlock==blockNodes[i]){textFlag=false;break;}}
if(textFlag){blockNodes.push(currentNode);}}}
if(currentNode==this.endContainer)break;currentNode=treeWalker.nextNode();}
return blockNodes;}
function MozileInsertCommand(configString){this._configString=String(configString);}
MozileInsertCommand.prototype=new MozileCommand();MozileInsertCommand.prototype.constructor=MozileInsertCommand;MozileInsertCommand.prototype.execute=function(event){var node=this.createNode();if(node){var range=window.getSelection().getRangeAt(0);range.deleteContents();range.insertNode(node);return true;}
else{return false;}}
mozile.getModule("XHTMLBasic").init=function(){if(mozile.getModule("XHTMLBasic").getOption("semantic")==false){mozile.getCommandList().createCommand("MozileWrapCommand: id=Mozile-XHTMLBasic-Strong, tag=b, mode=toggle, label=Bold, tooltip='Make text bold', accelerator='Command-B', image='"+mozile.getRoot()+"images/bold.png'");mozile.getCommandList().createCommand("MozileWrapCommand: id=Mozile-XHTMLBasic-Emphasis, tag=i, mode=toggle, label=Italic, tooltip='Italicize text', accelerator='Command-I', image='"+mozile.getRoot()+"images/italic.png'");}
else{mozile.getCommandList().createCommand("MozileWrapCommand: id=Mozile-XHTMLBasic-Strong, tag=strong, mode=toggle, label=Strong, tooltip='Make text strong', accelerator='Command-B', image='"+mozile.getRoot()+"images/bold.png'");mozile.getCommandList().createCommand("MozileWrapCommand: id=Mozile-XHTMLBasic-Emphasis, tag=em, mode=toggle, label=Emphasis, tooltip='Emphasize text', accelerator='Command-I', image='"+mozile.getRoot()+"images/italic.png'");}
mozile.getCommandList().createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Underline, style='text-decoration: underline', mode=toggle, label=Underline, tooltip='Underline text', accelerator='Command-U', image='"+mozile.getRoot()+"images/underline.png'");mozile.getCommandList().createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Strikethrough, style='text-decoration: line-through', mode=toggle, label=Strikethrough, tooltip='Strikethough text',image='"+mozile.getRoot()+"images/strikethrough.png'");mozile.getCommandList().createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Superscript, style='vertical-align: super; font-size: 80%', mode=toggle, label=Superscript, tooltip='Raise text',image='"+mozile.getRoot()+"images/superscript.png'");mozile.getCommandList().createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Subscript, style='vertical-align: sub; font-size: 80%', mode=toggle, label=Subscript, tooltip='Lower text',image='"+mozile.getRoot()+"images/subscript.png'");mozile.getCommandList().createCommand("MozileUnformatCommand: id=Mozile-XHTMLBasic-Unformat, label=Unformat, tooltip='Remove formatting from selection', image='"+mozile.getRoot()+"images/unlink.png'");var fontList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-FontList, label=Font, image='"+mozile.getRoot()+"images/fonts.png'");fontList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Serif, style='font-family: serif', mode=toggle, label=Serif, tooltip='Use serif font'");fontList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Sans-Serif, style='font-family: sans-serif', mode=toggle, label=Sans-Serif, tooltip='Use sans-serif font'");fontList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Monospace, style='font-family: monospace', mode=toggle, label=Monospace, tooltip='Use monospace font'");var sizeList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-SizeList, label=Size, image='"+mozile.getRoot()+"images/size.png'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Smaller, style='font-size: smaller', mode=inline, label=Smaller, tooltip='Make text smaller than surrounding text', accelerator='Command--'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-XX-Small, style='font-size: xx-small', mode=toggle, label=XX-Small, tooltip='Make text extremely small'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-X-Small, style='font-size: x-small', mode=toggle, label=X-Small, tooltip='Make text very small'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Small, style='font-size: small', mode=toggle, label=Small, tooltip='Make text small'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Medium, style='font-size: medium', mode=toggle, label=Medium, tooltip='Make text medium sized'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Large, style='font-size: large', mode=toggle, label=Large, tooltip='Make text large'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-X-Large, style='font-size: x-large', mode=toggle, label=X-Large, tooltip='Make text very large'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-XX-Large, style='font-size: xx-large', mode=toggle, label=XX-Large, tooltip='Make text extremely large'");sizeList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Larger, style='font-size: larger', mode=inline, label=Larger, tooltip='Make text larger than surrounding text', accelerator='Command-+'");var formatList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-FormatList, label='Format', image='"+mozile.getRoot()+"images/format.png'");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading1, tag=h1, label='Heading1', tooltip='Level 1 Heading', accesskey=1");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading2, tag=h2, label='Heading2', tooltip='Level 2 Heading', accesskey=2");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading3, tag=h3, label='Heading3', tooltip='Level 3 Heading', accesskey=3");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading4, tag=h4, label='Heading4', tooltip='Level 4 Heading', accesskey=4");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading5, tag=h5, label='Heading5', tooltip='Level 5 Heading', accesskey=5");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Heading6, tag=h6, label='Heading6', tooltip='Level 6 Heading', accesskey=6");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-Paragraph, tag=p, label='Paragraph', tooltip='Paragraph', accesskey=P");formatList.createCommand("MozileBlockSetCommand: id=Mozile-XHTMLBasic-ListItem, tag=li, label='List Item', tooltip='List Item', accesskey=L");var justifyList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-JustifyList, label=Justify, image='"+mozile.getRoot()+"images/justify-left.png'");justifyList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Justify-Left, style='text-align: left', mode=toggleBlock, label=Left, tooltip='Justify text left'");justifyList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Justify-Right, style='text-align: right', mode=toggleBlock, label=Right, tooltip='Justify text right'");justifyList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Justify-Conter, style='text-align: center', mode=toggleBlock, label=Center, tooltip='Center text'");justifyList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Justify-Full, style='text-align: justify', mode=toggleBlock, label=Full, tooltip='Justify left and right'");var textColorList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-TextColorList, label='Text Color', image='"+mozile.getRoot()+"images/text-color.png'");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Red, style='color: red', mode=toggle, label=Red, tooltip='Make text red' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Blue, style='color: blue', mode=toggle, label=Blue, tooltip='Make text blue' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Green, style='color: green', mode=toggle, label=Green, tooltip='Make text green' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Yellow, style='color: yellow', mode=toggle, label=Yellow, tooltip='Make text yellow' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Orange, style='color: orange', mode=toggle, label=Orange, tooltip='Make text orange' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Purple, style='color: purple', mode=toggle, label=Purple, tooltip='Make text purple' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-White, style='color: white', mode=toggle, label=White, tooltip='Make text white' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Gray, style='color: gray', mode=toggle, label=Gray, tooltip='Make text gray' ");textColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-Black, style='color: black', mode=toggle, label=Black, tooltip='Make text black' ");var backgroundColorList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-BackgroundColorList, label='Background Color', image='"+mozile.getRoot()+"images/background-color.png'");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGRed, style='background-color: red', mode=toggle, label=Red, tooltip='Make background red' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGBlue, style='background-color: blue', mode=toggle, label=Blue, tooltip='Make background blue' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGGreen, style='background-color: green', mode=toggle, label=Green, tooltip='Make background green' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGYellow, style='background-color: yellow', mode=toggle, label=Yellow, tooltip='Make background yellow' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGOrange, style='background-color: orange', mode=toggle, label=Orange, tooltip='Make background orange' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGPurple, style='cobackground-colorlor: purple', mode=toggle, label=Purple, tooltip='Make background purple' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGWhite, style='background-color: white', mode=toggle, label=White, tooltip='Make background white' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGGray, style='background-color: gray', mode=toggle, label=Gray, tooltip='Make background gray' ");backgroundColorList.createCommand("MozileStyleCommand: id=Mozile-XHTMLBasic-BGBlack, style='background-color: black', mode=toggle, label=Black, tooltip='Make background black' ");var objectList=mozile.getCommandList().createCommand("MozileCommandList: id=Mozile-XHTMLBasic-ObjectList, label='Insert Objects', image='"+mozile.getRoot()+"images/image.png'");var hr=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-HorizontalRule, label='Horizontal Rule', tooltip='Insert a horizontal rule' ");hr.createNode=function(){return document.createElement("hr");}
var link=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-Link, label='Link', tooltip='Insert a hyperlink' ");link.createNode=function(){var node;if(mozile.getOption("replaceAnchors"))node=document.createElement("mozileAnchorReplacement");else node=document.createElement("a");var href=prompt("What is the URL for the hyperlink?");if(href){node.setAttribute("href",href);node.appendChild(window.getSelection().getRangeAt(0).extractContents());return node;}
else{return false;}}
var image=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-Image, label='Image', tooltip='Insert an image' ");image.createNode=function(){var node=document.createElement("img");var src=prompt("What is the URL for the image?");if(src){node.setAttribute("src",src);return node;}
else{return false;}}
var ul=objectList.createCommand("MozileCommand: id=Mozile-XHTMLBasic-UnorderedList, label='Unordered List', tooltip='Insert an unordered list' ");ul.command=function(event){var ul=document.createElement("ul");var li=document.createElement("li");var textNode=document.createTextNode("");li.appendChild(textNode);ul.appendChild(li);var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();range.insertNode(ul);range.selectNode(textNode);range.collapse(true);selection.removeAllRanges();selection.addRange(range);return true;}
var ol=objectList.createCommand("MozileCommand: id=Mozile-XHTMLBasic-OrderedList, label='Ordered List', tooltip='Insert an ordered list' ");ol.command=function(event){var ol=document.createElement("ol");var li=document.createElement("li");var textNode=document.createTextNode("");li.appendChild(textNode);ol.appendChild(li);var selection=window.getSelection();var range=selection.getRangeAt(0).cloneRange();range.insertNode(ol);range.selectNode(textNode);range.collapse(true);selection.removeAllRanges();selection.addRange(range);return true;}
var title=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-Title, label='Change Title', tooltip='Change the document title' ");title.command=function(event){var title=document.getElementsByTagName("title")[0];var value=prompt("What should the title be?",document.title);if(title&&value){while(title.childNodes.length){title.removeChild(title.firstChild);}
title.appendChild(document.createTextNode(value));document.title=value;return true;}
else{return false;}}
var style=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-Style, label='Change Style', tooltip='Change the element style', accelerator='Command-Alt-S' ");style.command=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0);var container=range.commonAncestorContainer;if(container.nodeType==3)container=container.parentNode;var value=prompt("What should the style for the "+container.nodeName+" element be?",container.getAttribute("style"));if(value==null){return false;}
else{container.setAttribute("style",value);return true;}}
var attribute=objectList.createCommand("MozileInsertCommand: id=Mozile-XHTMLBasic-Attribute, label='Change Attribute', tooltip='Change an attribute of the element', accelerator='Command-Shift-A' ");attribute.command=function(event){var selection=window.getSelection();var range=selection.getRangeAt(0);var container=range.commonAncestorContainer;if(container.nodeType==3)container=container.parentNode;var attribute=prompt("What attribute of the "+container.nodeName+" element should be changed be?","");if(attribute==null)return false;var value=prompt("What should the value of the "+attribute+" attribute be?",container.getAttribute(attribute));if(value==null)return false;container.setAttribute(attribute,value);return true;}}
if(mozile.getCommandList()){mozile.getModule("XHTMLBasic").init();}