/*** -*- Mode: Javascript; tab-width: 2;
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/
                                                                                                    
Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.
                                                                                                    
The Original Code is jslib code.
The Initial Developer of the Original Code is jslib team.
                                                                                                    
Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
                                                                                                    
Contributor(s): Rajeev J Sebastian <rajeev_jsv@yahoo.com)> (original author)
                                                                                                    
*************************************/


//sends a file as the body. does not accept other parameters
if (typeof(JS_LIB_LOADED)=='boolean') {

const JS_FILEPOSTREQUEST_FILE     = "filePostRequest.js";
const JS_FILEPOSTREQUEST_LOADED   = true;

function FilePostRequest(baseuri){
  this.baseu = baseuri;
}

FilePostRequest.prototype = {
  baseu: null,
  method: "POST",
  cnttype: null,
  cntenc: null,
  filen: null,
  instrm: null,

  setFile: function(filename, stream, contenttype) {
    this.filen = filename;
    this.instrm = stream;
    this.cnttype = contenttype;
  },

  setFile: function(filename, jslibFile, contenttype) {
    this.filen = filename;

    var nsIFileInStrm = Components.interfaces.nsIFileInputStream;
    var nsIBufInStrm = Components.interfaces.nsIBufferedInputStream;

    var finstrm =
        Components.classes["@mozilla.org/network/file-input-stream;1"].
            createInstance( nsIFileInStrm );
    finstrm.init(jslibFile.nsIFile, 1, 1, finstrm.CLOSE_ON_EOF);

    this.instrm =
        Components.classes["@mozilla.org/network/buffered-input-stream;1"].
            createInstance( nsIBufInStrm );
    this.instrm.init(finstrm, 4096);
    this.cnttype = contenttype;
  },

  getRequestUri: function() {
    var uri = "";
    uri += this.baseu;
    return uri;
  },

  getRequestMethod: function() {
    return this.method;
  },

  setRequestHeaders: function(p) {
    return null;
  },

  getBody: function(p) {
    var boundary = "--i-N-5-4-N-3-k-4-n-3-------------314159265358979323846";
    var delimiter = "\r\n--"+boundary+"\r\n" ;
    var close_delim = "\r\n--"+boundary+"--" ;
    var cont_dispos_tag = "Content-disposition";
    var cont_dispos_val1 = "form-data; name=\"";
    var cont_dispos_val2 = "\"; filename=\"";
    var cont_dispos_val3 = "\"";
    var cont_type_tag = "Content-type";
    var cont_type_val = this.cnttype;

    //set up the multipart stream
    var delimstrm =
        Components.classes["@mozilla.org/io/string-input-stream;1"].
            createInstance( Components.interfaces.nsIStringInputStream );
    delimstrm.setData(delimiter,-1);


    //the part in a multipart stream
    var mimestrm =
        Components.classes["@mozilla.org/network/mime-input-stream;1"].
            createInstance( Components.interfaces.nsIMIMEInputStream );
    mimestrm.addContentLength = false;
    mimestrm.addHeader(cont_dispos_tag,cont_dispos_val1+this.filen+cont_dispos_val2+this.filen+cont_dispos_val3);
    mimestrm.addHeader(cont_type_tag,cont_type_val);
    mimestrm.setData(this.instrm);


    var cdelimstrm =
        Components.classes["@mozilla.org/io/string-input-stream;1"].
            createInstance( Components.interfaces.nsIStringInputStream );
    cdelimstrm.setData(close_delim,-1);



    var multiplexstrm =
        Components.classes["@mozilla.org/io/multiplex-input-stream;1"].
            createInstance( Components.interfaces.nsIMultiplexInputStream );
    multiplexstrm.appendStream(delimstrm);
    multiplexstrm.appendStream(mimestrm);
    multiplexstrm.appendStream(cdelimstrm);

    p.setRequestHeader("Content-length",multiplexstrm.available());
    p.setRequestHeader("Content-type","multipart/form-data; boundary="+boundary);

    return multiplexstrm;
  }
}

jslibDebug('*** load: '+JS_FILEPOSTREQUEST_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n"

        + " \tThen: include(jslib_filepostrequest);\n\n");

};

