/*$Id: fkResponseDetails.cpp,v 1.2 2008/05/18 10:29:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "plstr.h"
#include "fkResponseDetails.h"
#include "nsMemory.h"
#include "nsStringAPI.h"
#include "Error.h"
#include "Common.h"

NS_IMPL_ISUPPORTS1(fkResponseDetails, fkIResponseDetails)

fkResponseDetails::fkResponseDetails(const char *aHeaders, int aHeadersLen,
				     const char *aBody, int aBodyLen,
				     int aBodyOffset):
	headers(nsnull), headers_len(0), body(nsnull), body_len(0), hexbody(nsnull)
{
	TRACE("constructor %08x", this);
	if (aHeaders){
		headers_len = aHeadersLen;
		headers = toPrintableString(aHeaders, headers_len);
		hexheaders = toHexString(aHeaders, headers_len);
	}

	if (aBody){
		body_len = aBodyLen;
		body = toPrintableString(aBody, body_len);
		hexbody = toHexString(aBody, body_len);
	}
	body_offset = aBodyOffset;
}

fkResponseDetails::~fkResponseDetails()
{
	TRACE("destructor %08x", this);
	if (headers){
		nsMemory::Free(headers);
		headers = nsnull;
	}
	if (hexheaders){
		nsMemory::Free(hexheaders);
		hexheaders = nsnull;
	}
	if (body){
		nsMemory::Free(body);
		body = nsnull;
	}
	if (hexbody){
		nsMemory::Free(hexbody);
		hexbody = nsnull;
	}
}

/* readonly attribute string headers; */
NS_IMETHODIMP fkResponseDetails::GetHeaders(char **aHeaders)
{
	if (!aHeaders)
		return NS_ERROR_NULL_POINTER;
	*aHeaders = nsnull;

	if(headers){
		*aHeaders = PL_strdup(headers);	
		if (!*aHeaders)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

/* readonly attribute string hexheaders; */
NS_IMETHODIMP fkResponseDetails::GetHexheaders(char **aHexheaders)
{
	if (!aHexheaders)
		return NS_ERROR_NULL_POINTER;
	*aHexheaders = nsnull;

	if(hexheaders){
		*aHexheaders = PL_strdup(hexheaders);	
		if (!*aHexheaders)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


/* readonly attribute string body; */
NS_IMETHODIMP fkResponseDetails::GetBody(char **aBody)
{
	if (!aBody)
		return NS_ERROR_NULL_POINTER;
	*aBody = nsnull;

	if(body){
		*aBody = PL_strdup(body);	
		if (!*aBody)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

/* readonly attribute string hexbody; */
NS_IMETHODIMP fkResponseDetails::GetHexbody(char **aHexbody)
{
	if (!aHexbody)
		return NS_ERROR_NULL_POINTER;
	*aHexbody = nsnull;

 	if(body){
		*aHexbody = PL_strdup(hexbody);	
		TRACE("HEXBODY %s", *aHexbody);
		if (!*aHexbody)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

/* readonly attribute unsigned long body_offset; */
NS_IMETHODIMP fkResponseDetails::GetBody_offset(PRUint32 *aBody_offset)
{
	if (!aBody_offset)
		return NS_ERROR_NULL_POINTER;
	*aBody_offset = body_offset;
	return NS_OK;
}

char *fkResponseDetails::toPrintableString(const char *str, int len)
{
	int i;
	char *res = (char *)nsMemory::Alloc(len + 1);

	if (!res)
		return nsnull;
	for(i = 0; i < len; i++)
		if ((unsigned char)str[i] >= 127 || 
		    (!isprint(str[i]) && str[i] != '\n'))
			res[i] = '.';
		else{
			TRACE("printable %c", str[i]);
			res[i] = str[i];
		}
	res[len] = 0;
	return res;
}

char *fkResponseDetails::toHexString(const char *str, int len)
{
	int i;
	char *res = (char *)nsMemory::Alloc(3 * len + 1);	
	
	if (!res)
		return nsnull;
	for(i = 0; i < len; i++){
		snprintf(&res[i * 3], 4, "%02x ", (unsigned char)str[i]);
		TRACE("str = %02x res = %s", (unsigned char)str[i], &res[i * 3]);
	}
	TRACE("RESULT\n%s", res);
	return res;
}
