/*$Id: alertdetails.js,v 1.3 2007/09/18 20:02:47 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var rule = null;
var url = null;
var details = null;
var lspacer = "=== ", rspacer = " ===\n";
var offset_string = "";

function toHex(d)
{
	var res = d.toString(16);
	for(var i = res.length; i < 8; i++)
		res = "0" + res;
	return res;
}

function hexFormat(ascii, hex)
{
	var res = "", l = "", r = "", i = 0; 
	var byte_nr = toHex(0);
	
	for(var k = 1; i < ascii.length; i++, k++){		
		l += hex[3 * i] + hex[3 * i + 1] + hex[3 * i + 2];
 
		if (k % 4 == 0)
			l += " ";
		if (k % 8 == 0)
			l += " ";
		if (ascii[i] == '\n')
			r += '.';
		else
			r += ascii[i];
		
		if (k % 16 == 0){
			res += byte_nr + "  " + l + "     " + r + "\n";
			l = "";
			r = "";
			k = 0;
			byte_nr = toHex(i + 1)
		}
	}	
	
	/* append last line */
	if (l.length){
		do{
			l += "   ";
			if (k % 4 == 0)
				l += " ";
			if (k % 8 == 0)
				l += " ";
			
		}while(k++ % 16 != 0);		
		res += byte_nr + "  " + l + "     " + r + "\n";
	}
	return res;
}

function getResponse(details)
{
	var res = "";
	if (details && details.headers){
		res += lspacer + "Response headers" + rspacer;
		res += details.headers + "\n";
	}
	
	if (details && details.body){		
		res += lspacer + "Response body" + offset_string + rspacer;
		res += details.body + "\n";
	}
	return res;
}

function getHexResponse(details)
{
	var res = "";
	if (details && details.hexheaders){
		res += lspacer + "Response headers" + rspacer;
		res += hexFormat(details.headers, details.hexheaders) + "\n";
	}
	
	if (details && details.hexbody){
		res += lspacer + "Response body" + offset_string + rspacer;
		res += hexFormat(details.body, details.hexbody) + "\n";
	}
	return res;
}

function getDetails(rule, url, details, hexmode)
{
	var res = "";
	
	if (rule && rule.ruleraw){
		res += lspacer + "Triggered rule" + rspacer;
		res += rule.ruleraw + "\n\n";
	}
	
	if (url){
		res += lspacer + "Request URL" + rspacer;
		res += url + "\n\n";
	}

	if (details && details.body_offset)
		offset_string = " (" + details.body_offset + " bytes offset) ";
	if (!hexmode)
		res += getResponse(details);
	else
		res += getHexResponse(details);
	
	return res;
}

function displayDetails(hexmode)
{
	
	var text = document.getElementById('details-text');	
	text.value = getDetails(rule, url, details, hexmode);
}

function alertDetailsInit()
{
	rule = window.arguments[0];
	url = window.arguments[1];
	details = window.arguments[2];

	if (!details)
		hideElement('hexmode-checkbox');
	
	displayDetails(false);
}

function changeHexMode()
{
	var hexmode = document.getElementById('hexmode-checkbox').
		getAttribute('checked');
	displayDetails(hexmode);
}
