/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;

namespace LocaleInpector
{

/*
msgid        """Opening %d contact will open %d new window as well.\n""Do you really want to display this contact?"
msgid_plural """Opening %d contacts will open %d new windows as well.\n""Do you really want to display all of these contacts?"
msgstr[0]    """Abrir %d contato tambm abrir %d nova janela.\n""Voc realmente deseja exibir este contato?"
msgstr[1]    """Abrir %d contatos tambm abrir %d novas janelas.\n""Voc realmente deseja exibir todos estes contatos?"
*/

/*

white-space
#  translator-comments
#. automatic-comments
#: reference...
#, flag...
msgid untranslated-string
msgstr translated-string

*/
internal sealed class PoEntry
{

private List<string>     m_comment = null;
private string           m_ref = null;
private string           m_msgid = null;
private string           m_msgid_plural = null;
private string           m_msgstr = null;
private string           m_msgstrPlural = null;
private string           m_metadata = null;

public static string FormatRef(string path)
{
    string[] arr = path.Split('|');
    return arr[arr.Length - 1];
}

public PoEntry()
{
}

public bool Empty
{
    get {
        return //m_ref == null &&
               //m_metadata == null &&
               m_msgid == null &&
               m_msgid_plural == null &&
               m_msgstr == null &&
               m_msgstrPlural == null;
    }
}

public bool Fuzzy
{
    get {
        if (m_metadata == null) {
            return false;
        }
        return m_metadata.IndexOf("fuzzy") > -1;
    }
}

public void UnEscape2()
{
    Escape esc = new Escape();
    m_msgid = esc.UnEscape("---", m_msgid);
    m_msgid_plural = esc.UnEscape("---", m_msgid_plural);
    m_msgstr = esc.UnEscape("---", m_msgstr);
    m_msgstrPlural = esc.UnEscape("---", m_msgstrPlural);
}

public List<string> Comment
{
    get {
        return m_comment;
    }
}

public void AppendComment(string txt)
{
    if (txt == null) {
        return;
    }

    if (m_comment == null) {
        m_comment = new List<string>();
    }

    txt = txt.Replace(System.Environment.NewLine, "\n");
    string[] lines = txt.Split('\n');

    m_comment.AddRange(lines);
}

public string References
{
    get {
        return m_ref;
    }
}

public void AppendReference(string txt)
{
    if (txt.Length > 0) {
        m_ref = (m_ref == null) ? txt : m_ref + " " + txt;
    }
}

public string Original
{
    get {
        return m_msgid;
    }
}

// #, fuzzy
public void AppendInfo(string txt)
{
    m_metadata = (m_metadata == null)
                    ? txt
                    : m_metadata + " " + txt;
}

public void AppendOriginal(string txt)
{
    m_msgid = (m_msgid == null)
                ? txt
                : m_msgid + txt;
}





public string OriginalPlural
{
    get {
        return m_msgid_plural;
    }
}

public void AppendOriginalPlural(string txt)
{
    m_msgid_plural = (m_msgid_plural == null) ? txt : m_msgid_plural + txt;
}




public string Translated
{
    get {
        return m_msgstr;
    }
}

public void AppendTranslated(string txt)
{
    m_msgstr = (m_msgstr == null) ? txt : m_msgstr + txt;
}


public string TranslatedPlural
{
    get {
        return m_msgstrPlural;
    }
}

public void AppendTranslatedPlural(string txt)
{
    m_msgstrPlural = (m_msgstrPlural == null) ? txt : m_msgstrPlural + txt;
}

}//class
}//ns
