/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import mozilla_training_analyzer.Globals;
import mozilla_training_analyzer.MozillaSpamToken;

public class TrainingData {
    public static final int firstHdrByte = 254;
    public static final int secondHdrByte = 237;
    public static final int thirdHdrByte = 250;
    public static final int fourthHdrByte = 206;
    public static final int OUTPUT_BUFFER_SIZE = 65536;
    public static final String outputFileName = "training.dat";
    private int goodMessageCount = -1;
    private int badMessageCount = -1;
    private int numGoodTokens = -1;
    private int numBadTokens = -1;
    private TreeSet tokenSet = null;

    public TrainingData() {
    }

    public TrainingData(int n, int n2, TreeSet treeSet) {
        this.goodMessageCount = n;
        this.badMessageCount = n2;
        this.tokenSet = treeSet;
    }

    public void validateTokenCount() {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.tokenSet.iterator();
        MozillaSpamToken mozillaSpamToken = null;
        while (iterator.hasNext()) {
            mozillaSpamToken = (MozillaSpamToken)iterator.next();
            if (mozillaSpamToken.getGoodTokenCount() > 0) {
                ++n;
            }
            if (mozillaSpamToken.getBadTokenCount() <= 0) continue;
            ++n2;
        }
        this.numGoodTokens = n;
        this.numBadTokens = n2;
    }

    public void removeTokens(int n, int n2) {
        boolean bl = true;
        boolean bl2 = true;
        if (n <= 0) {
            bl = false;
        }
        if (n2 <= 0) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            return;
        }
        Iterator iterator = this.tokenSet.iterator();
        MozillaSpamToken mozillaSpamToken = null;
        while (iterator.hasNext()) {
            mozillaSpamToken = (MozillaSpamToken)iterator.next();
            if (bl && mozillaSpamToken.getGoodTokenCount() >= n || bl2 && mozillaSpamToken.getBadTokenCount() >= n2) continue;
            iterator.remove();
        }
        this.validateTokenCount();
    }

    public int getBadMessageCount() {
        return this.badMessageCount;
    }

    public int getGoodMessageCount() {
        return this.goodMessageCount;
    }

    public int getNumBadTokens() {
        return this.numBadTokens;
    }

    public int getNumGoodTokens() {
        return this.numGoodTokens;
    }

    public TreeSet getTokenSet() {
        return this.tokenSet;
    }

    public void setBadMessageCount(int n) {
        this.badMessageCount = n;
    }

    public void setGoodMessageCount(int n) {
        this.goodMessageCount = n;
    }

    public void setTokenSet(TreeSet treeSet) {
        this.tokenSet = treeSet;
    }

    public void outputTrainingDataFileContents(BufferedOutputStream bufferedOutputStream) throws IOException {
        this.validateTokenCount();
        bufferedOutputStream.write(254);
        bufferedOutputStream.write(237);
        bufferedOutputStream.write(250);
        bufferedOutputStream.write(206);
        bufferedOutputStream.write(Globals.makeBytes(this.goodMessageCount), 0, 4);
        bufferedOutputStream.write(Globals.makeBytes(this.badMessageCount), 0, 4);
        bufferedOutputStream.write(Globals.makeBytes(this.numGoodTokens), 0, 4);
        Iterator iterator = this.tokenSet.iterator();
        MozillaSpamToken mozillaSpamToken2 = null;
        String string = null;
        while (iterator.hasNext()) {
            mozillaSpamToken2 = (MozillaSpamToken)iterator.next();
            if (mozillaSpamToken2.getGoodTokenCount() <= 0) continue;
            bufferedOutputStream.write(Globals.makeBytes(mozillaSpamToken2.getGoodTokenCount()), 0, 4);
            string = mozillaSpamToken2.getTokenString();
            bufferedOutputStream.write(Globals.makeBytes(string.length()), 0, 4);
            bufferedOutputStream.write(string.getBytes(), 0, string.length());
        }
        bufferedOutputStream.write(Globals.makeBytes(this.numBadTokens));
        for (MozillaSpamToken mozillaSpamToken2 : this.tokenSet) {
            if (mozillaSpamToken2.getBadTokenCount() <= 0) continue;
            bufferedOutputStream.write(Globals.makeBytes(mozillaSpamToken2.getBadTokenCount()), 0, 4);
            string = mozillaSpamToken2.getTokenString();
            bufferedOutputStream.write(Globals.makeBytes(string.length()), 0, 4);
            bufferedOutputStream.write(string.getBytes(), 0, string.length());
        }
    }

    public void toTextDocument(BufferedOutputStream bufferedOutputStream) throws IOException {
        bufferedOutputStream.write("Good messages: ".getBytes());
        bufferedOutputStream.write(Integer.toString(this.goodMessageCount).getBytes());
        bufferedOutputStream.write("\nBad messages: ".getBytes());
        bufferedOutputStream.write(Integer.toString(this.badMessageCount).getBytes());
        bufferedOutputStream.write("\n\nList of tokens\n--------------\n".getBytes());
        Object object2 = null;
        for (Object object2 : this.tokenSet) {
            bufferedOutputStream.write(object2.toString().getBytes());
            bufferedOutputStream.write(10);
        }
    }

    public void toHTMLDocument(BufferedOutputStream bufferedOutputStream) throws IOException {
        bufferedOutputStream.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n".getBytes());
        bufferedOutputStream.write("<html lang=\"en\">\n".getBytes());
        bufferedOutputStream.write("\t<head>\n".getBytes());
        bufferedOutputStream.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n".getBytes());
        bufferedOutputStream.write("\t\t<title>\n".getBytes());
        bufferedOutputStream.write("\t\t\tMozilla Bayesian Filter Tokens\n".getBytes());
        bufferedOutputStream.write("\t\t</title>\n".getBytes());
        bufferedOutputStream.write("\t</head>\n\n".getBytes());
        bufferedOutputStream.write("\t<body>\n".getBytes());
        bufferedOutputStream.write("\t\t<h1>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<div align=\"center\">\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tMozilla Bayesian Filter Tokens\n".getBytes());
        bufferedOutputStream.write("\t\t\t</div>\n".getBytes());
        bufferedOutputStream.write("\t\t</h1>\n".getBytes());
        bufferedOutputStream.write("\t\t<dl>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tToken\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dd>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tThe string which has been detected\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tand tracked by the Bayesian filter.\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dd>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tGood\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dd>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tThe number of occurences of this\n".getBytes());
        bufferedOutputStream.write("\t\t\t\ttoken in non-junk (good) emails.\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dd>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tBad\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dt>\n".getBytes());
        bufferedOutputStream.write("\t\t\t<dd>\n".getBytes());
        bufferedOutputStream.write("\t\t\t\tThe number of occurences of this\n".getBytes());
        bufferedOutputStream.write("\t\t\t\ttoken in junk (bad) emails.\n".getBytes());
        bufferedOutputStream.write("\t\t\t</dd>\n".getBytes());
        bufferedOutputStream.write("\t\t</dl>\n".getBytes());
        bufferedOutputStream.write("\t\t<table align=\"center\" rules=\"all\">\n".getBytes());
        bufferedOutputStream.write("\t\t\t<tr><th><strong>Token</strong></th>".getBytes());
        bufferedOutputStream.write("<th><strong>Good</strong></th>".getBytes());
        bufferedOutputStream.write("<th><strong>Bad</strong></th></tr>\n".getBytes());
        MozillaSpamToken mozillaSpamToken2 = null;
        for (MozillaSpamToken mozillaSpamToken2 : this.tokenSet) {
            bufferedOutputStream.write("\t\t\t<tr><td>".getBytes());
            bufferedOutputStream.write(mozillaSpamToken2.getTokenString().getBytes());
            bufferedOutputStream.write("</td><td>".getBytes());
            bufferedOutputStream.write(Integer.toString(mozillaSpamToken2.getGoodTokenCount()).getBytes());
            bufferedOutputStream.write("</td><td>".getBytes());
            bufferedOutputStream.write(Integer.toString(mozillaSpamToken2.getBadTokenCount()).getBytes());
            bufferedOutputStream.write("</td></tr>\n".getBytes());
        }
        bufferedOutputStream.write("\t\t</table>\n".getBytes());
        bufferedOutputStream.write("\t</body>\n".getBytes());
        bufferedOutputStream.write("</html>\n".getBytes());
    }

    public void toXMLDocument(BufferedOutputStream bufferedOutputStream) throws IOException {
        bufferedOutputStream.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n".getBytes());
        bufferedOutputStream.write("<!DOCTYPE tokenfile SYSTEM \"trainer_xml.dtd\">".getBytes());
        bufferedOutputStream.write("<tokenfile>\n".getBytes());
        bufferedOutputStream.write("\t<good_msgs>".getBytes());
        bufferedOutputStream.write(Integer.toString(this.goodMessageCount).getBytes());
        bufferedOutputStream.write("</good_msgs>\n".getBytes());
        bufferedOutputStream.write("\t<bad_msgs>".getBytes());
        bufferedOutputStream.write(Integer.toString(this.badMessageCount).getBytes());
        bufferedOutputStream.write("</bad_msgs>\n".getBytes());
        MozillaSpamToken mozillaSpamToken2 = null;
        for (MozillaSpamToken mozillaSpamToken2 : this.tokenSet) {
            bufferedOutputStream.write("\t<token>\n".getBytes());
            bufferedOutputStream.write("\t\t<name>".getBytes());
            bufferedOutputStream.write(mozillaSpamToken2.getTokenString().getBytes());
            bufferedOutputStream.write("</name>\n".getBytes());
            bufferedOutputStream.write("\t\t<good>".getBytes());
            bufferedOutputStream.write(Integer.toString(mozillaSpamToken2.getGoodTokenCount()).getBytes());
            bufferedOutputStream.write("</good>\n".getBytes());
            bufferedOutputStream.write("\t\t<bad>".getBytes());
            bufferedOutputStream.write(Integer.toString(mozillaSpamToken2.getBadTokenCount()).getBytes());
            bufferedOutputStream.write("</bad>\n".getBytes());
            bufferedOutputStream.write("\t</token>\n".getBytes());
        }
        bufferedOutputStream.write("</tokenfile>\n".getBytes());
    }

    public void writeXMLDTD(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n").append("<!-- The root element of this Mozilla training data XML file. -->\n").append("<!ELEMENT tokenfile (good_msgs, bad_msgs, token*)>\n\n").append("<!-- Represents the number of good (non-junk) messages processed by this token file. -->\n").append("<!ELEMENT good_msgs (#PCDATA)>\n\n").append("<!-- Represents the number of bad (junk) messages processed by this token file. -->\n").append("<!ELEMENT bad_msgs (#PCDATA)>\n\n").append("<!-- Represents a single token in the training file. -->\n").append("<!ELEMENT token (name, good, bad)>\n\n").append("<!-- Represents the string associated with this token. -->\n").append("<!ELEMENT name (#PCDATA)>\n\n").append("<!-- Represents the number of times this token has appeared in good (non-junk) emails. -->\n").append("<!ELEMENT good (#PCDATA)>\n\n").append("<!-- Represents the number of times this token has appeared in bad (junk) emails. -->\n").append("<!ELEMENT bad (#PCDATA)>\n");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(stringBuffer.toString().getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

