# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gnome
import gu, widgets
import soundcard, mpd, mpd.musicdisplayer
import abstract, const
import statistics, statisticsviewer
from i18n import _
import utils

class Teacher(abstract.MelodicIntervallTeacher):
    def __init__(self, exname, app):
        abstract.MelodicIntervallTeacher.__init__(self, exname, app)
        self._ignore_picky = 1
        self.m_statistics = statistics.IntervallStatistics(self)
    def get_question(self):
        s = self.m_tonika.str()
        last = self.m_tonika
        for i in self.m_question:
            n = mpd.Intervall()
            n.set_from_int(i)
            last = last + n
            s = s + " " + last.str()
        return self.m_tonika, r"\staff{ \clef %s %s}" % (mpd.select_clef(s), s)
    def guessed_correct(self):
        if self.get_int('number_of_intervalls=1') == 1:
            self.m_statistics.add_correct(self.m_question[0])
        self.q_status = const.QSTATUS_SOLVED
    def guessed_wrong(self):
        if self.get_int('number_of_intervalls=1') == 1:
            self.m_statistics.add_wrong(self.m_question[0], None)
        self.q_status = const.QSTATUS_SOLVED # FIXME workaround, just to make it work
    def play_first_tone(self):
        if self.q_status == const.QSTATUS_NO:
            return
        assert self.m_question
        soundcard.play_note(self.get_int('config/preferred_instrument'),
                  4, 0, self.m_tonika.semitone_pitch(),
                  self.get_int('config/preferred_instrument_velocity'))
    def play_last_tone(self):
        if self.q_status == const.QSTATUS_NO:
            return
        assert self.m_question
        t = self.m_tonika
        for i in self.m_question:
            t = t + i
        soundcard.play_note(self.get_int('config/preferred_instrument'),
                  4, 0, t.semitone_pitch(),
                  self.get_int('config/preferred_instrument_velocity'))


class Gui(abstract.Gui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window)
        self.m_key_bindings = {'new_ak': self.new_question,
                               'new_ok_ak': self.new_question,
                               'new_wrong_ak': self.new_last_was_wrong,
                               'play_first_ak': self.m_t.play_first_tone,
                               'play_last_ak': self.m_t.play_last_tone,
                               'play_answer_ak': self.m_t.play_question}
        ################
        # practise_box #
        ################
        self.g_score_displayer = mpd.musicdisplayer.MusicDisplayer(utils.play_tone)
        self.practise_box.pack_start(self.g_score_displayer)
        self.g_score_displayer.clear()
        b1 = gu.bHBox(self.practise_box, gtk.FALSE)
        b1.set_usize(-1, self.get_int("gui/button_height"))
        self.g_new_intervall_ok = gu.bButton(b1,
                _("New intervall,\nlast was ok"), self.new_question)
        self.g_new_intervall_wrong = gu.bButton(b1,
                _("New intervall,\nlast was wrong"), self.new_last_was_wrong)
        self.g_new_intervall = gu.bButton(b1,
               _("New intervall"), self.new_question)
        self.g_new_intervall_wrong.set_sensitive(gtk.FALSE)
        self.g_repeat_tonika = gu.bButton(self.action_area, 
                     _("Repeat first tone"),
                     lambda _o, self=self: self.m_t.play_first_tone())
        self.g_repeat_tonika.set_sensitive(gtk.FALSE)
        self.g_play_answer = gu.bButton(self.action_area,
                     _("Play answer"),
                     lambda _o, self=self: self.m_t.play_question())
        self.g_play_answer.set_sensitive(gtk.FALSE)
        self.g_repeat_last_tone = gu.bButton(self.action_area,
           _("Play last tone"), lambda _o, self=self: self.m_t.play_last_tone())
        self.g_repeat_last_tone.set_sensitive(gtk.FALSE)
        self.practise_box.show_all()
        self.g_new_intervall_ok.hide()
        self.g_new_intervall_wrong.hide()
        ##############
        # config_box #
        ##############
        self.g_mici = widgets.MultipleIntervallConfigWidget(self.m_exname)
        self.config_box.pack_start(self.g_mici, gtk.FALSE)
        self.config_box.show_all()
        ###############
        # statistics
        ###############
        self.setup_statisticsviewer(
           statisticsviewer.SingIntervallStatisticsViewer, _("Sing intervall"))

    def _new_question(self):
        r = self.m_t.new_question(self.get_string('user/lowest_pitch'),
                                  self.get_string('user/highest_pitch'))
        if r == Teacher.OK:
            self.m_t.play_first_tone()
            q = self.m_t.get_question()
            fontsize = self.get_int('config/feta_font_size=20')
            self.g_score_displayer.display(q[1], fontsize)
            self.g_new_intervall_wrong.set_sensitive(gtk.TRUE)
            self.g_repeat_tonika.set_sensitive(gtk.TRUE)
            self.g_play_answer.set_sensitive(gtk.TRUE)
            self.g_repeat_last_tone.set_sensitive(gtk.TRUE)
        elif r == Teacher.ERR_CONFIGURE:
            self.g_repeat_tonika.set_sensitive(gtk.FALSE)
            self.g_play_answer.set_sensitive(gtk.FALSE)
            self.g_repeat_last_tone.set_sensitive(gtk.FALSE)
            gnome.ui.GnomeErrorDialog(_("The exercise has to be better configured.\nClick 'Reset to default values' on the config\npage if you don't know how to do this."))
            self.g_score_displayer.clear()
        return r
    def on_start_practise(self):
        self.m_t.m_statistics.reset_session()
    def on_end_practise(self):
        self.g_new_intervall.show()
        self.g_new_intervall_ok.hide()
        self.g_new_intervall_wrong.hide()
        self.g_repeat_tonika.set_sensitive(gtk.FALSE)
        self.g_play_answer.set_sensitive(gtk.FALSE)
        self.g_repeat_last_tone.set_sensitive(gtk.FALSE)
        self.m_t.end_practise()
        self.g_score_displayer.clear()
    def new_last_was_wrong(self, widget=None):
        if self.m_t.q_status == const.QSTATUS_NEW:
            self.m_t.guessed_wrong()
        self._new_question()
    def new_question(self, widget=None):#called by 'new last was ok' and from
                 # teacher when we get a new question automatically.
        if self.m_t.q_status == const.QSTATUS_NEW:
            self.m_t.guessed_correct()
        r = self._new_question()
        if r == Teacher.OK:
            self.g_new_intervall.hide()
            self.g_new_intervall_ok.show()
            self.g_new_intervall_wrong.show()

