dnl I'd like this to be edited in -*- Autoconf -*- mode...
dnl
dnl Requires AC_CHECK_SIZEOF(long)
dnl
AC_DEFUN([GST_CHECK_ALIGNMENT], [
AS_LITERAL_IF([$1], [],
               [AC_FATAL([$0: requires literal arguments])])dnl

AC_CHECK_SIZEOF($1)
AC_CACHE_CHECK([for $1 alignment], AS_TR_SH([gst_cv_$1_alignment]), [
if test $ac_cv_sizeof_long -ge $AS_TR_SH([ac_cv_sizeof_$1]); then
  # The alignment cannot be bigger than the size
  AS_TR_SH([gst_cv_$1_alignment])=$AS_TR_SH([ac_cv_sizeof_$1])
else
AC_TRY_RUN([
  #include <stdio.h>
  int
  main()
  {
    long vec[(sizeof($1) + sizeof(long) * 2 - 1) / sizeof(long)];
    $1 *misaligned;
    long ptr;
    char buffer[200];

    /* Find a position in vec so that doubleptr is misaligned. */
    ptr = (long) vec;			/* xxxxxxxxxxxxxyyy */
    ptr |= sizeof($1) - 1;		/* xxxxxxxxxxxxx111 */
    ptr ^= sizeof(long) - 1;		/* xxxxxxxxxxxxx100 */
    misaligned = ($1 *) ptr;

    /* The sprintf only fools the compiler, what's important is
     * that we dereference the misaligned pointer. */
    sprintf(buffer, "%d", *misaligned);
    exit(0);
  }],
  AS_TR_SH([gst_cv_$1_alignment])=$ac_cv_sizeof_long,
  AS_TR_SH([gst_cv_$1_alignment])=$AS_TR_SH([ac_cv_sizeof_$1]),
  AS_TR_SH([gst_cv_$1_alignment])=$AS_TR_SH([ac_cv_sizeof_$1]))
fi
])

AC_DEFINE_UNQUOTED(AS_TR_CPP($1_alignment), $AS_TR_SH([gst_cv_$1_alignment]),
                   [The alignment required for a value of type `$1'])

])dnl
