#POSIX says:
#
#  A subexpression repeated by an asterisk ('*') or an interval
#  expression shall not match a null expression unless this is
#  the only match for the repetition or it is necessary to satisfy
#  the exact or minimum number of occurrences for the interval
#  expression.
#
#If I understand correctly, doing:
#  echo aaaab | sed 's/\(a\{0,1\}\)\{5\}b/<&:\1>/'
#outputs
#  <aaaab:>
#since \1 is allowed to be null because null is necessary to
#match the fifth occurrence of \(a\{0,1\}\) and GNU sed 4.0.7
#does it correctly.
#
#But doing
#  echo aaaab | sed 's/\(a\{0,1\}\)\{1,5\}b/<&:\1>/'
#should output
#  <aaaab:a>
#since it is not required to match a fifth \(a\{0,1\}\) as four
#of them are enough to match the repeated subexpression, and
#this time GNU sed 4.0.7 wrongly outputs:
#  <aaaab:>
#
h
s/\(a\{0,1\}\)\{5\}b/<&:\1>/
p
g
s/\(a\{0,1\}\)\{1,5\}b/<&:\1>/
