/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */
var crypto = require("script_entries/crypto");
var longString = require("./mock/long_string.js").longString;

var Request = require("request").Request;

var cRequest = require("html_script_finder/dom_handler/request");

exports.sha1EncryptTest = function (test) {
    var str = "This is my test string";
    test.assertEqual(crypto.sha1Encrypt(str), 'e925bfd93e14174c2b2c83f68b3d3243df3005ef');
    //test.assertEqual(crypto.sha1Encrypt(longString), 'e4656e5e3af6e0d064a7f1f3681fd60a3a0f3982'); 
};

exports.sha1EncryptjQueryTest = function (test) {
    test.waitUntilDone();
    var scriptText = Request({
				 'url': 'https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js',
				 'onComplete': function (response) {
				     test.assertEqual(crypto.sha1Encrypt(response.text),'abcd2ba13348f178b17141b445bc99f1917d47af');
				     test.done();
				 }
			     }).get();

};

exports.sha1EncryptjQueryTestWithChannelRequest = function (test) {
    test.waitUntilDone();
    var scriptText = Request({
				 'url': 'https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js',
				 'onComplete': function (response) {
				     test.assertEqual(crypto.sha1Encrypt(response.text),'abcd2ba13348f178b17141b445bc99f1917d47af');
				     test.done();
				 }
			     }).get();

};