/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.FString;
import gnu.lists.IString;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.Sequences;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static int characterAt(CharSequence cseq, int index) {
        return Strings.characterAt(cseq, 0, cseq.length(), index);
    }

    public static int characterAt(CharSequence cseq, int start, int end, int index) {
        char ch0;
        if (index < start || index >= end) {
            throw new IndexOutOfBoundsException();
        }
        char ch1 = cseq.charAt(index);
        if (ch1 >= '\ud800' && ch1 <= '\udbff') {
            char ch2;
            if (index + 1 < end && (ch2 = cseq.charAt(index + 1)) >= '\udc00' && ch2 <= '\udfff') {
                return (ch1 - 55296 << 10) + (ch2 - 56320) + 65536;
            }
        } else if (ch1 >= '\udc00' && ch1 <= '\udfff' && index > start && (ch0 = cseq.charAt(index - 1)) >= '\ud800' && ch0 <= '\udbff') {
            return 0x1FFFFF;
        }
        return ch1;
    }

    public static int indexByCodePoints(CharSequence str, int index) {
        if (str instanceof IString) {
            return ((IString)str).indexByCodePoints(index);
        }
        index = Character.offsetByCodePoints(str, 0, index);
        return Character.codePointAt(str, index);
    }

    public static int offsetByCodePoints(CharSequence str, int offset, int cuStart, int cpStart) {
        if (str instanceof IString) {
            IString istr = (IString)str;
            if ((offset += cpStart) < 0 || offset > istr.size()) {
                throw new IndexOutOfBoundsException();
            }
            return istr.offsetByCodePoints(offset);
        }
        return Character.offsetByCodePoints(str, cuStart, offset);
    }

    public static int sizeInCodePoints(CharSequence str) {
        if (str instanceof IString) {
            return ((IString)str).lengthByCodePoints();
        }
        int len = str.length();
        int nsurr = 0;
        int i = 0;
        while (i < len) {
            char next;
            char ch;
            if ((ch = str.charAt(i++)) < '\ud800' || ch > '\udbff' || i >= len || (next = str.charAt(i)) < '\udc00' || next > '\udfff') continue;
            ++i;
            ++nsurr;
        }
        return len - nsurr;
    }

    public static void makeUpperCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toUpperCase(str.charAt(i)));
        }
    }

    public static void makeLowerCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toLowerCase(str.charAt(i)));
        }
    }

    public static void makeCapitalize(CharSeq str) {
        char prev = ' ';
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            ch = !Character.isLetterOrDigit(prev) ? Character.toTitleCase(ch) : Character.toLowerCase(ch);
            str.setCharAt(i, ch);
            prev = ch;
        }
    }

    public static String toJson(CharSequence str) {
        StringBuilder sbuf = new StringBuilder();
        Strings.printQuoted(str, sbuf, 3);
        return sbuf.toString();
    }

    public static void printJson(CharSequence str, Appendable ps) {
        Strings.printQuoted(str, ps, 3);
    }

    public static void printQuoted(CharSequence str, Appendable ps, int escapes) {
        int len = str.length();
        try {
            ps.append('\"');
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\\' || ch == '\"') {
                    ps.append('\\');
                } else if (escapes > 0) {
                    if (ch == '\n') {
                        ps.append("\\n");
                        continue;
                    }
                    if (ch == '\r') {
                        ps.append("\\r");
                        continue;
                    }
                    if (ch == '\t') {
                        ps.append("\\t");
                        continue;
                    }
                    if (ch == '\u0007' && escapes < 3) {
                        ps.append("\\a");
                        continue;
                    }
                    if (ch == '\b') {
                        ps.append("\\b");
                        continue;
                    }
                    if (ch == '\u000b' && escapes < 3) {
                        ps.append("\\v");
                        continue;
                    }
                    if (ch == '\f') {
                        ps.append("\\f");
                        continue;
                    }
                    if (escapes >= 3 && (ch < ' ' || ch >= '\u007f')) {
                        ps.append("\\u");
                        char d = ch;
                        for (int k = 12; k >= 0; k -= 4) {
                            ps.append(Character.forDigit(d >> k & 0xF, 16));
                        }
                        continue;
                    }
                    if (ch < ' ' || escapes > 1 && ch >= '\u007f') {
                        ps.append("\\x");
                        ps.append(Integer.toHexString(ch));
                        ps.append(';');
                        continue;
                    }
                }
                ps.append(ch);
            }
            ps.append('\"');
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyInto(CharSequence src, int start, int end, CharSeq dst, int at) {
        int dstLen = dst.length();
        int srcLen = src.length();
        if (at < 0 || at > dstLen || start < 0 || end > srcLen || end < start || dstLen - at < end - start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (at < start) {
            int i = at;
            for (int j = start; j < end; ++j) {
                dst.setCharAt(i, src.charAt(j));
                ++i;
            }
        } else {
            int i = at + end - start;
            int j = end;
            while (--j >= start) {
                dst.setCharAt(--i, src.charAt(j));
            }
        }
    }

    public static IString indirectIndexed(CharSequence base2, IntSequence indexes) {
        Range.IntRange range;
        if (indexes instanceof Range.IntRange && (range = (Range.IntRange)indexes).getStepInt() == 1) {
            int size;
            int start = range.getStartInt();
            int end = base2.length();
            if (start < 0 || start > end) {
                throw new IndexOutOfBoundsException();
            }
            if (!range.isUnbounded()) {
                size = range.size();
                if (start + size < 0 || start + size > end) {
                    throw new IndexOutOfBoundsException();
                }
            } else {
                size = end - start;
            }
            return IString.valueOf(base2, start, size);
        }
        int len = indexes.size();
        StringBuilder sbuf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int ch = Strings.indexByCodePoints(base2, indexes.getInt(i));
            if (ch >= 65536) {
                sbuf.append((char)((ch - 65536 >> 10) + 55296));
                ch = (ch & 0x3FF) + 56320;
            }
            sbuf.append((char)ch);
        }
        return new IString(sbuf.toString());
    }

    public static CharSequence substring(CharSequence base2, int start, int end) {
        FString fstr;
        if (base2 instanceof FString && ((fstr = (FString)base2).isVerySimple() || fstr.isSubRange())) {
            return (CharSequence)((Object)Sequences.copySimple(fstr, start, end, false));
        }
        if (base2 instanceof String) {
            return ((String)base2).substring(start, end);
        }
        int len = end - start;
        StringBuilder sbuf = new StringBuilder(len);
        if (base2 instanceof CharSeq) {
            try {
                ((CharSeq)base2).writeTo(start, len, sbuf);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        } else {
            for (int i = start; i < end; ++i) {
                sbuf.append(base2.charAt(i));
            }
        }
        return sbuf.toString();
    }

    public static String fromUtf8(byte[] bytes, int start, int length) {
        return new String(bytes, start, length, StandardCharsets.UTF_8);
    }

    public static byte[] toUtf16(CharSequence str, int start, int end, boolean bigEndian, boolean writeBOM) {
        int blen = 2 * (end - start) + (writeBOM ? 2 : 0);
        byte[] buf = new byte[blen];
        int hi = bigEndian ? 0 : 1;
        int lo = bigEndian ? 1 : 0;
        int i = start;
        for (int j = 0; j < blen; j += 2) {
            int ch;
            if (writeBOM) {
                ch = 65279;
                writeBOM = false;
            } else {
                ch = str.charAt(i++);
            }
            buf[j + lo] = (byte)ch;
            buf[j + hi] = (byte)(ch >> 8);
        }
        return buf;
    }

    public static int compareTo(CharSequence str1, CharSequence str2) {
        int n2;
        int n1 = str1.length();
        int n = n1 > (n2 = str2.length()) ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            char c2;
            char c1 = str1.charAt(i);
            int d = c1 - (c2 = str2.charAt(i));
            if (d == 0) continue;
            return d;
        }
        return n1 - n2;
    }

    public static String replicate(int from, int to, boolean suppliedTo, CharSequence string, int start, int end, boolean suppliedEnd) {
        int sstart = Strings.offsetByCodePoints(string, start, 0, 0);
        if (end <= start || suppliedTo && to < from) {
            if (end >= start && from == to) {
                return "";
            }
            throw new StringIndexOutOfBoundsException();
        }
        int slen = end - start;
        int startOffset = from % slen;
        if (startOffset < 0) {
            startOffset += slen;
        }
        int ptr = Strings.offsetByCodePoints(string, startOffset, sstart, start);
        int send = !suppliedEnd ? string.length() : Strings.offsetByCodePoints(string, end - startOffset, ptr, startOffset);
        StringBuilder buf = new StringBuilder();
        int i = from;
        while (suppliedTo ? i < to : ptr < send) {
            char next;
            if (ptr == send) {
                ptr = sstart;
            }
            char ch = string.charAt(ptr);
            buf.append(ch);
            if (ch >= '\ud800' && ch <= '\udbff' && ++ptr < send && (next = string.charAt(ptr)) >= '\udc00' && next <= '\udfff') {
                ++ptr;
                buf.append(next);
            }
            ++i;
        }
        return buf.toString();
    }
}

