/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.PrimIntegerVector;

public abstract class ShortVector<E>
extends PrimIntegerVector<E> {
    short[] data;
    protected static short[] empty = new short[0];

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            short[] tmp = new short[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public short[] getBuffer() {
        return this.data;
    }

    @Override
    protected void setBuffer(Object buffer) {
        this.data = (short[])buffer;
    }

    public final short shortAt(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    public final short shortAtBuffer(int index) {
        return this.data[index];
    }

    public final void setShortAt(int index, short value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.data[index] = value;
    }

    public final void setShortAtBuffer(int index, short value) {
        this.data[index] = value;
    }

    public void add(short v) {
        int sz = this.size();
        this.addSpace(sz, 1);
        this.setShortAt(sz, v);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        short[] d = this.data;
        while (--count >= 0) {
            d[start++] = 0;
        }
    }
}

