/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class let_syntax
extends Syntax
implements Printable {
    boolean recursive;

    public let_syntax(boolean bl) {
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object3 = pair.car;
        Object object4 = pair.cdr;
        int n = LList.length(object3);
        Expression[] expressionArray = new Expression[n];
        Declaration[] declarationArray = new Declaration[n];
        Macro[] macroArray = new Macro[n];
        Object[] objectArray = new Object[n];
        LetExp letExp = new LetExp(expressionArray);
        for (int i = 0; i < n; ++i) {
            Pair pair2 = (Pair)object3;
            if (!(pair2.car instanceof Pair)) {
                return translator.syntaxError("let binding is not a pair");
            }
            Pair pair3 = (Pair)pair2.car;
            if (!(pair3.car instanceof String)) {
                return translator.syntaxError("variable in let binding is not a symbol");
            }
            String string = (String)pair3.car;
            if (!(pair3.cdr instanceof Pair)) {
                return translator.syntaxError("let has no value for '" + string + "'");
            }
            pair3 = (Pair)pair3.cdr;
            if (pair3.cdr != LList.Empty) {
                return translator.syntaxError("let binding for '" + string + "' is improper list");
            }
            declarationArray[i] = new Declaration(string);
            macroArray[i] = Macro.make(declarationArray[i]);
            objectArray[i] = pair3.car;
            letExp.addDeclaration(declarationArray[i]);
            expressionArray[i] = QuoteExp.nullExp;
            object3 = pair2.cdr;
        }
        if (this.recursive) {
            translator.push(letExp);
        }
        Macro macro = translator.currentMacroDefinition;
        for (int i = 0; i < n; ++i) {
            translator.currentMacroDefinition = macroArray[i];
            expressionArray[i] = translator.rewrite(objectArray[i]);
            macroArray[i].expander = expressionArray[i];
        }
        translator.currentMacroDefinition = macro;
        if (!this.recursive) {
            translator.push(letExp);
        }
        Expression expression = translator.rewrite_body(object4);
        translator.pop(letExp);
        return expression;
    }
}

