
(defun unspacify ()
  (interactive)
  (assert (eq major-mode 'dired-mode))
  (if (string= (safe-expand-file-name dired-directory) (safe-expand-file-name "~/"))
      (error "You cannot run this command on the HOME folder"))
  (let ((list (directory-files-no-dotdotdot default-directory t nil)))
    (unspacify--list list))
  (sit-for 1)
  (revert-buffer))



(defun unspacify--init-lists ()

  (let (file-list)

    (setq file-list (directory-files-deep "c:/mp3/" nil "\\.mp3"))

    (setq file-list (directory-files "c:/mp3-files/singles/" t "\\.mp3$"))

    (setq file-list (directory-files "c:/mp3-files/albums/" t))

    (setq file-list (directory-files "c:/mp3-files/singles/" t))

    (progn
      (setq file-list (directory-files "c:/mp3-files/singles/" t "&"))
      (setq file-name (car file-list)))))



;; (unspacify--list file-list)
;; (unspacify--list (directory-files-no-dotdotdot "~/" t nil))
;;
(defun unspacify--list (file-list)
  (let ((ptr   file-list)
        (count 0))
    (while ptr
      (let* ((old-file (car ptr))
             (new-file (unspacify--de-ampersand (unspacify--file old-file))))
        (when (and (not (string= old-file new-file))
                   (not (file-exists-p new-file)))
          ;;(debug)
          (rename-file old-file new-file)
          (incf count)
          ;;(message "old-file=%s new-file=%s" old-file new-file)
          ))
      (setq ptr (cdr ptr)))
    (message "Files processed = %d" count)))

;; (unspacify--file "d:/Java Development/MastJava2")
;; (unspacify--file "d:/Java Development/Mast Java2")
(defun unspacify--file (full-name)
  (let* ((file-part (file-name-nondirectory full-name))
         (dir-part  (file-name-directory    full-name))
         (i         0)
         (len       (length file-part)))
  (while (< i len)
    (if (or (eq (aref file-part i) ? )
            (eq (aref file-part i) ?_))
        (aset file-part i ?-))
    (incf i))
  (concat dir-part file-part)
  )
  )

;; (unspacify--de-ampersand "d:/Java Development/MastJava2/")
;; (unspacify--de-ampersand "d:/Java Development/asf&rex.txt")
(defun unspacify--de-ampersand (full-name)
  (let* ((file-part (file-name-nondirectory full-name))
         (dir-part  (file-name-directory    full-name))
         (new-fp    "")
         (i         0)
         (len       (length file-part)))
    (while (< i len)
      (let ((ch (aref file-part i)))
        (if (eq ch ?&)
            (setq new-fp (concat new-fp "and"))
          (setq new-fp (format "%s%c" new-fp ch))))
      (incf i))
    (concat dir-part new-fp)))



(provide 'd-unspacify)
;;; d-unspacify.el ends here
