/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionImage;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OP_binary;
import gnu.jel.OP_call;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OP_unary;
import gnu.jel.OPlist;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class Optimizer {
    private Library lib;
    private Stack types = new Stack();
    private OPlist code = new OPlist();
    private Stack functions = new Stack();
    private Stack functionsDescriptors = new Stack();
    private Throwable caughtThrowable;
    private boolean finished = false;

    public Optimizer(Library library) {
        this.lib = library;
    }

    public void load(boolean bl) {
        this.load(Boolean.TYPE, new Boolean(bl));
    }

    public void load(byte by) {
        this.load(Byte.TYPE, new Byte(by));
    }

    public void load(char c) {
        this.load(Character.TYPE, new Character(c));
    }

    public void load(short s) {
        this.load(Short.TYPE, new Short(s));
    }

    public void load(int n) {
        this.load(Integer.TYPE, new Integer(n));
    }

    public void load(long l) {
        this.load(Long.TYPE, new Long(l));
    }

    public void load(float f) {
        this.load(Float.TYPE, new Float(f));
    }

    public void load(double d) {
        this.load(Double.TYPE, new Double(d));
    }

    private void load(Class clazz, Object object) {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_load oP_load = new OP_load(clazz, object);
        this.types.push(clazz);
        this.code.addLast(oP_load);
    }

    public void convert(Class clazz) throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        Class clazz2 = (Class)this.types.peek();
        if (!ExpressionImage.canConvert(clazz2, clazz)) {
            throw new IllegalStateException("Requested conversion (" + clazz2.toString() + " --> " + clazz.toString() + ") is not supported.");
        }
        this.code.addLast(new OP_convert(clazz));
        this.types.pop();
        this.types.push(clazz);
    }

    public void unary(int n) {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        Class clazz = (Class)this.types.peek();
        if (!ExpressionImage.canGenerateUnary(n, clazz)) {
            throw new IllegalStateException("Unary " + ExpressionImage.unaryNames[n] + " is not supported on " + clazz.getName() + "'s");
        }
        this.code.addLast(new OP_unary(n));
    }

    public void function_start() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_call oP_call = new OP_call();
        this.functions.push(oP_call);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_start(oP_call));
    }

    public void binaryOP_param() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_binary oP_binary = new OP_binary();
        this.functions.push(oP_binary);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_param(oP_binary, (Class)this.types.peek()));
    }

    public boolean function_param() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_function oP_function = (OP_function)this.functions.peek();
        int[] nArray = (int[])this.functionsDescriptors.peek();
        nArray[0] = nArray[0] + 1;
        this.code.addLast(new OP_param(oP_function, (Class)this.types.peek()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void function_call(String var1_1) throws IllegalStateException {
        block5: {
            if (this.finished) {
                throw new IllegalStateException("Attempt to modify finished function.");
            }
            var2_2 = (OP_call)this.functions.peek();
            var3_3 = (int[])this.functionsDescriptors.peek();
            var4_4 = var3_3[0];
            var5_5 = new Class[var4_4];
            var6_6 = var4_4 - 1;
            while (var6_6 >= 0) {
                var5_5[var6_6] = (Class)this.types.pop();
                --var6_6;
            }
            try {
                var7_7 = this.lib.getMethod(var1_1, var5_5);
                break block5;
            }
            catch (NoSuchMethodException var8_8) {
                var9_10 = 0;
                ** while (var9_10 < var4_4)
            }
lbl-1000:
            // 1 sources

            {
                this.types.push(var5_5[var9_10]);
                ++var9_10;
                continue;
            }
lbl22:
            // 1 sources

            throw new IllegalStateException(var8_8.getMessage());
        }
        var8_9 = var2_2;
        this.code.addLast(var8_9);
        var8_9.setMethod(this.code, var7_7, this.lib.getDynamicMethodClassID(var7_7), this.lib.isStateless(var7_7));
        this.types.push(var7_7.getReturnType());
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void binaryOP(int n) throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_binary oP_binary = (OP_binary)this.functions.peek();
        int[] cfr_ignored_0 = (int[])this.functionsDescriptors.peek();
        this.code.addLast(new OP_param(oP_binary, (Class)this.types.peek()));
        Class clazz = (Class)this.types.pop();
        Class clazz2 = (Class)this.types.pop();
        if (!ExpressionImage.canGenerateBinary(n, clazz2, clazz)) {
            this.types.push(clazz2);
            this.types.push(clazz);
            throw new IllegalStateException("Types " + clazz2.toString() + " and " + clazz.toString() + " are not suitable " + "for the operation \"" + ExpressionImage.binaryNames[n] + "\"");
        }
        Class clazz3 = ExpressionImage.getMostGeneralType(clazz2, clazz);
        OP_binary oP_binary2 = oP_binary;
        this.code.addLast(oP_binary2);
        oP_binary2.setOperation(this.code, n, clazz3);
        this.types.push(clazz3);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void finish() throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        if (this.code.size != 0 && this.types.size() != 1) {
            throw new IllegalStateException("Stack should contain single item on exit.");
        }
        if (this.functions.size() != 0 || this.functionsDescriptors.size() != 0) {
            throw new IllegalStateException("There are function calls in progress.");
        }
        this.finished = true;
    }

    public void optimize(int n) {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
        if (n == 0) {
            return;
        }
        while (this.optimizeIteration()) {
        }
    }

    protected boolean optimizeIteration() {
        OP oP = this.code.getFirst();
        boolean bl = false;
        while (oP != null && this.caughtThrowable == null) {
            OP_function oP_function;
            OP oP2 = oP.next();
            if (oP instanceof OP_function && (oP_function = (OP_function)oP).canInterpret()) {
                try {
                    oP_function.interpret(this.code);
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.caughtThrowable = throwable;
                }
            }
            oP = oP2;
        }
        return bl;
    }

    public CompiledExpression compile() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
        ExpressionImage expressionImage = new ExpressionImage();
        this.code.compile(expressionImage);
        expressionImage.asm_return();
        return expressionImage.getExpression();
    }

    public String toString() {
        return this.code.toString();
    }

    private void seeFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
    }

    private void seeNonFinished() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
    }

    public static void main(String[] stringArray) {
    }

    public static void test(Tester tester) {
    }
}

