;;; Copyright © 2021 Ricardo Wurmus <rekado@elephly.net>
;;;
;;; This program is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix extensions workflow)
  #:use-module (guix scripts)
  #:export (guix-workflow))

;; IMPORTANT: We must avoid loading any modules from the GWL here,
;; because we need to adjust the guile load paths first.  It's okay to
;; import modules from core Guile and (guix scripts) though.

(define (replace-load-paths!)
  (let ((own-load-path
         (if (getenv "GWL_UNINSTALLED")
             (list "/home/rekado/dev/gx/gwl"
                   "/home/rekado/dev/gx/gwl")
             (list "/usr/local/share/guile/site/3.0")))
        (own-load-compiled-path
         (if (getenv "GWL_UNINSTALLED")
             (list "/home/rekado/dev/gx/gwl"
                   "/home/rekado/dev/gx/gwl")
             (list "/usr/local/lib/guile/3.0/site-ccache"))))
    ;; Override load paths
    (set! %load-path
          (append own-load-path
                  ;; This is Guile's own pristine load path.
                  (list (%library-dir) (%site-dir)
                        (%global-site-dir) (%package-data-dir))
                  ;; When building in an impure environment this
                  ;; variable may contain locations that collide with
                  ;; Guile's own load path, so we put it at the very
                  ;; end.  We add it for all the additional Guile
                  ;; packages.
                  (parse-path "/gnu/store/4xy0r4yp7219k9qakmy61kw89gql7n9l-profile/share/guile/site/3.0:/home/rekado/.guix-profile/share/guile/site/3.0:/run/current-system/profile/share/guile/site/3.0:/run/current-system/profile/share/guile/site/3.0")))
    (set! %load-compiled-path
          (append own-load-compiled-path
                  ;; This is Guile's own pristine load path for
                  ;; compiled modules.
                  (let ((ccache (%site-ccache-dir)))
                    (list (string-append
                           (string-drop-right ccache
                                              (string-length "site-ccache"))
                           "ccache")
                          ccache))
                  ;; When building in an impure environment this
                  ;; variable may contain locations that collide with
                  ;; Guile's own load path, so we put it at the very
                  ;; end.  We add it for all the additional Guile
                  ;; packages.
                  (parse-path "/gnu/store/4xy0r4yp7219k9qakmy61kw89gql7n9l-profile/lib/guile/3.0/site-ccache:/gnu/store/4xy0r4yp7219k9qakmy61kw89gql7n9l-profile/share/guile/site/3.0:/home/rekado/.guix-profile/lib/guile/3.0/site-ccache:/home/rekado/.guix-profile/share/guile/site/3.0:/run/current-system/profile/lib/guile/3.0/site-ccache:/run/current-system/profile/share/guile/site/3.0:/run/current-system/profile/lib/guile/3.0/site-ccache:/run/current-system/profile/share/guile/site/3.0")))))

;;;
;;; Entry point.
;;;

(define-command (guix-workflow . args)
  (category main) ; TODO: use something else
  (synopsis "execute or visualize workflows")

  (replace-load-paths!)
  (let ((main (module-ref (resolve-interface '(gwl main))
                          'guix-workflow-main)))
    ;;(bindtextdomain "guix-workflow" "/usr/local/share/locale")
    (apply main args)))
