/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : line-edit library                                               */
/* File  : char_io.h                                                       */
/* Descr.: basic character input/output - header file                      */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

#define KEY_CTRL(x)                ((x) & 0x1f)

#define KEY_ESC(x)                 ((2<<8) | ((x)|0x20))

#define KEY_BASKSPACE              '\b'
#define KEY_DELETE                 0x7f


#if defined(__unix__) || defined(__CYGWIN__)     /********** UNIX **********/


#define KEY_EXT_FCT_1              ((1<<8) | 11)
#define KEY_EXT_FCT_2              ((1<<8) | 12)
#define KEY_EXT_FCT_3              ((1<<8) | 13)
#define KEY_EXT_FCT_4              ((1<<8) | 14)
#define KEY_EXT_FCT_5              ((1<<8) | 15)

#define KEY_EXT_FCT_6              ((1<<8) | 17)
#define KEY_EXT_FCT_7              ((1<<8) | 18)
#define KEY_EXT_FCT_8              ((1<<8) | 19)
#define KEY_EXT_FCT_9              ((1<<8) | 20)
#define KEY_EXT_FCT_10             ((1<<8) | 21)

#define KEY_EXT_FCT_11             ((1<<8) | 23)
#define KEY_EXT_FCT_12             ((1<<8) | 24)

#define KEY_EXT_UP                 ((1<<8) | 'A')
#define KEY_EXT_DOWN               ((1<<8) | 'B')
#define KEY_EXT_RIGHT              ((1<<8) | 'C')
#define KEY_EXT_LEFT               ((1<<8) | 'D')

#define KEY_EXT_HOME               ((1<<8) | 'H')
#define KEY_EXT_END                ((1<<8) | 'F')
#define KEY_EXT_PAGE_UP            ((1<<8) | 5)
#define KEY_EXT_PAGE_DOWN          ((1<<8) | 6)
#define KEY_EXT_INSERT             ((1<<8) | 2)
#define KEY_EXT_DELETE             ((1<<8) | 3)

#define KEY_CTRL_EXT_UP            ((2<<8) | 0)    /* 2<<8 | x for unknown */
#define KEY_CTRL_EXT_DOWN          ((2<<8) | 1)
#define KEY_CTRL_EXT_RIGHT         ((2<<8) | 2)
#define KEY_CTRL_EXT_LEFT          ((2<<8) | 3)

#define KEY_CTRL_EXT_HOME          ((2<<8) | 4)
#define KEY_CTRL_EXT_END           ((2<<8) | 5)
#define KEY_CTRL_EXT_PAGE_UP       ((2<<8) | 6)
#define KEY_CTRL_EXT_PAGE_DOWN     ((2<<8) | 7)
#define KEY_CTRL_EXT_INSERT        ((2<<8) | 8)
#define KEY_CTRL_EXT_DELETE        ((2<<8) | 9)


#ifdef __CYGWIN__
#define KEY_EOF                    KEY_CTRL('Z')
#else
#define KEY_EOF                    KEY_CTRL('D')
#endif


#else                                           /********** MSDOS **********/


#define KEY_EXT_FCT_1              ((1<<8) | 0x3b)
#define KEY_EXT_FCT_2              ((1<<8) | 0x3c)
#define KEY_EXT_FCT_3              ((1<<8) | 0x3d)
#define KEY_EXT_FCT_4              ((1<<8) | 0x3e)
#define KEY_EXT_FCT_5              ((1<<8) | 0x3f)

#define KEY_EXT_FCT_6              ((1<<8) | 0x40)
#define KEY_EXT_FCT_7              ((1<<8) | 0x41)
#define KEY_EXT_FCT_8              ((1<<8) | 0x42)
#define KEY_EXT_FCT_9              ((1<<8) | 0x43)
#define KEY_EXT_FCT_10             ((1<<8) | 0x44)

#define KEY_EXT_FCT_11             ((1<<8) | 0x85)
#define KEY_EXT_FCT_12             ((1<<8) | 0x86)

#define KEY_EXT_UP                 ((1<<8) | 0x48)
#define KEY_EXT_DOWN               ((1<<8) | 0x50)
#define KEY_EXT_RIGHT              ((1<<8) | 0x4d)
#define KEY_EXT_LEFT               ((1<<8) | 0x4b)

#define KEY_EXT_HOME               ((1<<8) | 0x47)
#define KEY_EXT_END                ((1<<8) | 0x4f)
#define KEY_EXT_PAGE_UP            ((1<<8) | 0x49)
#define KEY_EXT_PAGE_DOWN          ((1<<8) | 0x51)
#define KEY_EXT_INSERT             ((1<<8) | 0x52)
#define KEY_EXT_DELETE             ((1<<8) | 0x53)

#define KEY_CTRL_EXT_UP            ((1<<8) | 0x8d)
#define KEY_CTRL_EXT_DOWN          ((1<<8) | 0x91)
#define KEY_CTRL_EXT_RIGHT         ((1<<8) | 0x74)
#define KEY_CTRL_EXT_LEFT          ((1<<8) | 0x73)

#define KEY_CTRL_EXT_HOME          ((1<<8) | 0x77)
#define KEY_CTRL_EXT_END           ((1<<8) | 0x75)
#define KEY_CTRL_EXT_PAGE_UP       ((1<<8) | 0x86)
#define KEY_CTRL_EXT_PAGE_DOWN     ((1<<8) | 0x76)
#define KEY_CTRL_EXT_INSERT        ((1<<8) | 0x92)
#define KEY_CTRL_EXT_DELETE        ((1<<8) | 0x93)


#define KEY_EOF                    KEY_CTRL('Z')

#endif




/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void      LE_Put_Char           (int c,int fd_out);

int       LE_Get_Char0          (int fd_in);

int       LE_Get_Char           (int fd_in);


