/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import org.gnunet.secretsharing.Ciphertext;
import org.gnunet.secretsharing.DecryptCallback;
import org.gnunet.secretsharing.Share;
import org.gnunet.secretsharing.messages.ClientDecryptMessage;
import org.gnunet.secretsharing.messages.DecryptDoneMessage;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.RunaboutMessageReceiver;

public class Decryption {
    private Client client;
    private DecryptCallback decryptCallback;

    public Decryption(Configuration configuration, Share share, Ciphertext ciphertext, AbsoluteTime start, AbsoluteTime deadline, DecryptCallback decryptCallback) {
        this.decryptCallback = decryptCallback;
        this.client = new Client("secretsharing", configuration);
        this.client.installReceiver(new DecryptionReceiver());
        ClientDecryptMessage m = new ClientDecryptMessage();
        m.ciphertext = ciphertext;
        m.deadline = deadline.asMessage();
        m.start = start.asMessage();
        m.share = share;
        this.client.send(m);
    }

    public void disconnect() {
        if (null != this.client) {
            this.client.disconnect();
            this.client = null;
        }
    }

    private class DecryptionReceiver
    extends RunaboutMessageReceiver {
        private DecryptionReceiver() {
        }

        public void visit(DecryptDoneMessage m) {
            if (m.success != 0) {
                Decryption.this.decryptCallback.onResult(m.plaintext);
            } else {
                Decryption.this.decryptCallback.onResult(null);
            }
            Decryption.this.client.disconnect();
            Decryption.this.client = null;
        }

        @Override
        public void handleError() {
            Decryption.this.decryptCallback.onResult(null);
        }
    }
}

