/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.DisplayedCells;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.Iterator;

public class CancelCheckOutJob
extends Job {
    private ProjectCell cancelled;
    private ProjectCell former;
    private ProjectDB pdb;
    private DisplayedCells displayedCells;

    public static void cancelCheckOutThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        CancelCheckOutJob.cancelCheckOut(cell);
    }

    public static void cancelCheckOut(Cell cell) {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        boolean response = Job.getUserInterface().confirmMessage("Cancel all changes to the checked-out " + cell + " and revert to the checked-in version?");
        if (!response) {
            return;
        }
        ProjectCell cancelled = null;
        ProjectCell former = null;
        Library lib = cell.getLibrary();
        ProjectLibrary pl = Project.projectDB.findProjectLibrary(lib);
        Iterator<ProjectCell> it = pl.getProjectCells();
        while (it.hasNext()) {
            ProjectCell pc = it.next();
            if (!pc.getCellName().equals(cell.getName()) || pc.getView() != cell.getView()) continue;
            if (pc.getVersion() >= cell.getVersion()) {
                if (pc.getOwner().length() <= 0) continue;
                if (pc.getOwner().equals(Project.getCurrentUserName())) {
                    cancelled = pc;
                    continue;
                }
                pl.releaseProjectFileLock(true);
                Job.getUserInterface().showErrorMessage("This cell is not checked out to you.  Only user '" + pc.getOwner() + "' can cancel the check-out.", "Cannot Cancel Checkout");
                return;
            }
            if (former != null && former.getVersion() < pc.getVersion()) {
                former = null;
            }
            if (former != null) continue;
            former = pc;
        }
        if (cancelled == null) {
            pl.releaseProjectFileLock(true);
            Job.getUserInterface().showErrorMessage("This cell is not checked out.", "Cannot Cancel Checkout");
            return;
        }
        if (former == null) {
            pl.releaseProjectFileLock(true);
            Job.getUserInterface().showErrorMessage("Cannot find former version to restore.", "Cannot Cancel Checkout");
            return;
        }
        new CancelCheckOutJob(cancelled, former);
    }

    private CancelCheckOutJob(ProjectCell cancelled, ProjectCell former) {
        super("Cancel Check-out", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.cancelled = cancelled;
        this.former = former;
        this.pdb = Project.projectDB;
        this.displayedCells = new DisplayedCells();
        ArrayList<Cell> justOne = new ArrayList<Cell>();
        justOne.add(cancelled.getCell());
        this.displayedCells.setCellsToBeChanged(justOne);
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        EditingPreferences ep = this.getEditingPreferences();
        ProjectLibrary pl = this.cancelled.getProjectLibrary();
        pl.lockProjectFile();
        Project.setChangeStatus(true);
        Project.getCellFromRepository(this.pdb, this.former, pl.getLibrary(), false, false, ep);
        Cell oldCell = this.cancelled.getCell();
        Cell newCell = this.former.getCell();
        if (newCell == null) {
            Project.setChangeStatus(false);
            pl.releaseProjectFileLock(true);
            throw new JobException("Error bringing in former version (" + this.former.getVersion() + ")");
        }
        if (Project.useNewestVersion(oldCell, newCell, ep)) {
            Project.setChangeStatus(false);
            pl.releaseProjectFileLock(true);
            throw new JobException("Error replacing instances of former " + oldCell);
        }
        this.displayedCells.swap(oldCell, newCell);
        pl.removeProjectCell(this.cancelled);
        if (this.cancelled.getCell() != null) {
            Project.markLocked(this.cancelled.getCell(), true, ep);
        }
        this.former.setLatestVersion(true);
        Project.setChangeStatus(false);
        pl.releaseProjectFileLock(true);
        this.fieldVariableChanged("pdb");
        this.fieldVariableChanged("displayedCells");
        return true;
    }

    @Override
    public void terminateOK() {
        this.displayedCells.updateWindows();
        WindowFrame.wantToRedoLibraryTree();
    }
}

