/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.CurrentReadable;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;
import java.io.PrintWriter;

public class AmpsVsVolts {
    public PowerChannel supply;
    public CurrentReadable ammeter;
    public float voltsMin = 0.0f;
    public float voltsMax = 2.001f;
    public float voltsStep = 0.2f;
    public float settleTime = 1.0f;

    public AmpsVsVolts(PowerChannel supply, CurrentReadable ammeter) {
        this.supply = supply;
        this.ammeter = ammeter;
    }

    public AmpsVsVolts(PowerChannel supply, CurrentReadable ammeter, float voltsMin, float voltsMax, float voltsStep, float settleTime) {
        if (voltsMax < voltsMin || voltsStep < 0.0f) {
            Infrastructure.fatal("Voltage min=" + voltsMin + ", max=" + voltsMax + ", step=" + voltsStep + ".  Require max>min and step>0");
        }
        this.supply = supply;
        this.ammeter = ammeter;
        this.voltsMin = voltsMin;
        this.voltsMax = voltsMax;
        this.voltsStep = voltsStep;
        this.settleTime = settleTime;
    }

    public void measure(PrintWriter file) {
        file.println("# (volts, amps) samples");
        for (float volts = this.voltsMin; volts < this.voltsMax; volts += this.voltsStep) {
            this.supply.setVoltageWait(volts);
            try {
                Thread.sleep((int)(1000.0f * this.settleTime));
            }
            catch (InterruptedException _) {
                // empty catch block
            }
            float amps = this.ammeter.readCurrent();
            System.out.println(volts + " V:  " + amps + " A");
            file.println(volts + " " + amps);
        }
        this.supply.setVoltageWait(0.0f);
    }

    public static void main(String[] args) {
    }
}

