/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

public class StepSize {
    private double separation;
    private double low;
    private double high;
    private int rangeScale;
    private int stepScale;

    public double getLowValue() {
        return this.low;
    }

    public double getHighValue() {
        return this.high;
    }

    public double getSeparation() {
        return this.separation;
    }

    public int getStepScale() {
        return this.stepScale;
    }

    public int getRangeScale() {
        return this.rangeScale;
    }

    public StepSize(double h, double l, int n) {
        this.low = l;
        this.high = h;
        this.stepScale = 0;
        this.rangeScale = 0;
        double range = Math.max(Math.abs(l), Math.abs(h));
        if (range == 0.0) {
            this.separation = 0.0;
            return;
        }
        if (Double.isInfinite(l) || Double.isInfinite(h)) {
            this.separation = 0.0;
            return;
        }
        while (range >= 10.0) {
            range /= 10.0;
            ++this.rangeScale;
        }
        while (range <= 1.0) {
            range *= 10.0;
            --this.rangeScale;
        }
        double d = Math.abs(h - l) / (double)n;
        if (Math.abs(d / (h + l)) < 1.0E-7) {
            d = 0.1;
        }
        int mp = 0;
        while (d >= 10.0) {
            d /= 10.0;
            ++mp;
            ++this.stepScale;
        }
        while (d <= 1.0) {
            d *= 10.0;
            --mp;
            --this.stepScale;
        }
        double m = Math.pow(10.0, mp);
        int di = (int)d;
        if (di == 0) {
            this.separation = 0.0;
            return;
        }
        if (di > 2 && di <= 5) {
            di = 5;
        } else if (di > 5) {
            di = 10;
        }
        int li = (int)(l / m);
        int hi = (int)(h / m);
        li = li / di * di;
        hi = hi / di * di;
        if (li < 0) {
            li -= di;
        }
        if (hi > 0) {
            hi += di;
        }
        this.low = (double)li * m;
        this.high = (double)hi * m;
        this.separation = (double)di * m;
    }
}

