/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.SubchainNode;
import com.sun.electric.tool.simulation.test.TestNode;
import com.sun.electric.tool.simulation.test.XMLIO;
import java.util.ArrayList;

public class ChainControl
extends Logger {
    protected TestNode system;
    final JtagTester jtag;
    private int jtagKhz;
    private float jtagVolts;
    public int irBadSeverity = 3;
    public int noTestSeverity = 1;
    public int errTestSeverity = 3;
    public String xmlFile = null;

    ChainControl(String fileName) {
        this.openFile(fileName);
        this.jtag = null;
    }

    public ChainControl(String fileName, JtagTester jtagTester, float jtagVolts, int jtagKhz) {
        System.out.print("Reading xml file " + fileName + "...");
        System.out.flush();
        long ctime = System.currentTimeMillis();
        this.openFile(fileName);
        System.out.println("finished. Took " + Infrastructure.getElapsedTime(System.currentTimeMillis() - ctime));
        this.jtag = jtagTester;
        this.jtagVolts = jtagVolts;
        this.jtagKhz = jtagKhz;
        jtagTester.configure(jtagVolts, jtagKhz);
    }

    public MyTreeNode getSystem() {
        return this.system;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.jtag.disconnect();
    }

    public JtagTester getJtag() {
        return this.jtag;
    }

    public float getJtagVolts() {
        return this.jtagVolts;
    }

    public void setJtagVolts(float defaultVdd) {
        this.jtagVolts = defaultVdd;
        this.jtag.configure(defaultVdd, this.jtagKhz);
    }

    public int getJtagKhz() {
        return this.jtagKhz;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setJtagKhz(int defaultKHz) {
        this.jtagKhz = defaultKHz;
        this.jtag.configure(this.jtagVolts, defaultKHz);
    }

    public String getSubchainPin(String path) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        return chainNode.pin;
    }

    public void setSubchainPin(String path, String pin) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        chainNode.pin = pin;
    }

    public int getLength(String path) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        return chainNode.getLength();
    }

    public BitVector getInBits(String path) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        return chainNode.getInBits();
    }

    public BitVector getOutBits(String path) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        return chainNode.getOutBits();
    }

    public BitVector getExpectedBits(String path) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        return chainNode.getOldOutBitsExpected();
    }

    public void setInBits(String path, BitVector newBits) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        chainNode.setInBits(newBits);
    }

    public void setInBits(String path, String newBits) {
        SubchainNode chainNode = (SubchainNode)this.findNode(path, SubchainNode.class);
        chainNode.setInBits(newBits);
    }

    public void setInBits(String chainPath, boolean newValue) {
        int length = this.getLength(chainPath);
        BitVector bits = new BitVector(length, "setInBits()-bits");
        bits.set(0, length, newValue);
        this.setInBits(chainPath, bits);
    }

    public void resetInBits() {
        this.resetInBits(true);
    }

    public void resetInBits(boolean useMasterClearState) {
        String[] roots = this.getChainPaths();
        for (int iroot = 0; iroot < roots.length; ++iroot) {
            ChainNode chainRoot = (ChainNode)this.findNode(roots[iroot], ChainNode.class);
            chainRoot.resetInBits(useMasterClearState);
        }
    }

    public void processMasterClear(String chipName) {
        String[] roots = this.getChainPaths(chipName);
        for (int iroot = 0; iroot < roots.length; ++iroot) {
            ChainNode root = (ChainNode)this.findNode(roots[iroot], ChainNode.class);
            root.processMasterClear();
        }
    }

    public void invalidate(String chipName) {
        String[] roots = this.getChainPaths(chipName);
        for (int iroot = 0; iroot < roots.length; ++iroot) {
            ChainNode root = (ChainNode)this.findNode(roots[iroot], ChainNode.class);
            root.invalidate();
        }
    }

    public boolean shift(String chainRoot, boolean readEnable, boolean writeEnable, int irBadSeverity, int noTestSeverity, int errTestSeverity) {
        MyTreeNode node = this.findNode(chainRoot);
        if (!ChainNode.class.isInstance(node)) {
            Infrastructure.fatal("Node '" + node + "' at path '" + chainRoot + "' is of class " + node.getClass().getName() + ", but shifts must be performed on members of class " + ChainNode.class.getName());
        }
        boolean ret = ((ChainNode)node).shift(this.jtag, readEnable, writeEnable, irBadSeverity, noTestSeverity, errTestSeverity, this);
        return ret;
    }

    public boolean shift(String chainRoot, boolean readEnable, boolean writeEnable) {
        return this.shift(chainRoot, readEnable, writeEnable, this.irBadSeverity, this.noTestSeverity, this.errTestSeverity);
    }

    public boolean shiftOneBit(String chainRoot, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        MyTreeNode node = this.findNode(chainRoot);
        if (!ChainNode.class.isInstance(node)) {
            Infrastructure.fatal("Node '" + node + "' at path '" + chainRoot + "' is of class " + node.getClass().getName() + ", but shifts must be performed on members of class " + ChainNode.class.getName());
        }
        return ((ChainNode)node).shiftOneBit(this.jtag, readEnable, writeEnable, irBadSeverity, this);
    }

    public String[] getChips() {
        ArrayList<String> chips = new ArrayList<String>();
        for (int i = 0; i < this.system.getChildCount(); ++i) {
            MyTreeNode child = this.system.getChildAt(i);
            if (child.getClass() == ChipNode.class) {
                chips.add(child.getPathString(1));
                continue;
            }
            if (child.getName().equals("scanChainDataNets")) continue;
            Infrastructure.nonfatal(child + " is a child of the system node, but is not a chip");
        }
        String[] chips2 = new String[chips.size()];
        for (int i = 0; i < chips2.length; ++i) {
            chips2[i] = (String)chips.get(i);
        }
        return chips2;
    }

    public String[] getChainPaths(String chipName) {
        MyTreeNode chip = this.findNode(chipName, ChipNode.class);
        int nroot = chip.getChildCount();
        String[] roots = new String[nroot];
        for (int iroot = 0; iroot < nroot; ++iroot) {
            MyTreeNode child = chip.getChildAt(iroot);
            if (!ChainNode.class.isInstance(child)) {
                Infrastructure.fatal(child + " (class=" + child.getClass() + ") is a child of chip " + chipName + ", but is not a ChainNode");
                continue;
            }
            roots[iroot] = child.getPathString(1);
        }
        return roots;
    }

    public String[] getChainPaths() {
        int nrootTotal = 0;
        String[] chips = this.getChips();
        for (int ichip = 0; ichip < chips.length; ++ichip) {
            nrootTotal += this.getChainPaths(chips[ichip]).length;
        }
        int irootTotal = 0;
        String[] rootsTotal = new String[nrootTotal];
        for (int ichip = 0; ichip < chips.length; ++ichip) {
            String[] roots = this.getChainPaths(chips[ichip]);
            for (int iroot = 0; iroot < roots.length; ++iroot) {
                rootsTotal[irootTotal] = roots[iroot];
                ++irootTotal;
            }
        }
        return rootsTotal;
    }

    public String[] getDescendents(String path) {
        MyTreeNode node = this.findNode(path);
        MyTreeNode[] nodes = node.getDescendents();
        String[] paths = new String[nodes.length];
        for (int ind = 0; ind < nodes.length; ++ind) {
            paths[ind] = nodes[ind].getPathString(1);
        }
        return paths;
    }

    public String getParentChain(String path) {
        MyTreeNode node = this.findNode(path, SubchainNode.class);
        SubchainNode subchain = (SubchainNode)node;
        ChainNode chain = subchain.getParentChain();
        return chain.getPathString();
    }

    public int getLenIR(String chip) {
        ChipNode node = (ChipNode)this.findNode(chip, ChipNode.class);
        return node.getLengthIR();
    }

    public int getLenIR() {
        int sum = 0;
        String[] chips = this.getChips();
        for (int ichip = 0; ichip < chips.length; ++ichip) {
            sum += this.getLenIR(chips[ichip]);
        }
        return sum;
    }

    public String getOpcode(String chainRoot) {
        ChainNode node = (ChainNode)this.findNode(chainRoot, ChainNode.class);
        return node.getOpcode();
    }

    public MyTreeNode findNode(String path, MyTreeNode root) {
        if (path.equals("")) {
            return root;
        }
        MyTreeNode node = MyTreeNode.getNode(root, path);
        if (node == null) {
            Infrastructure.fatal("Can't find " + path + ".  Hints: Paths start with a chip name. " + " Hierarchy levels are separated with '.'.  " + "See chip XML file for correct paths.");
        }
        return node;
    }

    public MyTreeNode findNode(String path) {
        return this.findNode(path, this.system);
    }

    public MyTreeNode findNode(String path, Class expected) {
        MyTreeNode node = this.findNode(path);
        if (!expected.isInstance(node)) {
            Infrastructure.fatal("Node at path " + path + " is of class " + node.getClass() + ", but was expecting class " + expected);
        }
        return node;
    }

    void openFile(String name) {
        if (name == null) {
            return;
        }
        try {
            this.system = XMLIO.read(name);
            this.xmlFile = name;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ChainControl control = new ChainControl("heater.xml");
        MyTreeNode node = control.findNode("heater.pScan");
        System.out.println(node);
        MyTreeNode node2 = control.findNode("p0.column", node);
        System.out.println(node2);
        String[] chips = control.getChips();
        for (int ind = 0; ind < chips.length; ++ind) {
            System.out.println(ind + ": " + chips[ind] + ", lengthIR=" + control.getLenIR(chips[ind]));
        }
        System.out.println("Total IR length = " + control.getLenIR());
        System.out.println("\nChains of heater:");
        String[] roots = control.getChainPaths();
        for (int ind = 0; ind < roots.length; ++ind) {
            System.out.println(ind + ": " + roots[ind] + ", length=" + control.getLength(roots[ind]));
        }
        System.out.println("\nSubchains of heater:");
        String[] subchains = control.getDescendents("heater");
        for (int ind = 0; ind < subchains.length; ++ind) {
            System.out.println(ind + ": " + subchains[ind]);
        }
        control.setSubchainPin("heater", "toad");
        control.shift("heater.pScan.p0", false, false);
    }
}

