/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.TempPref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ParasiticTab
extends ProjSettingsPanel {
    private HashMap<Layer, TempPref> layerResistanceOptions;
    private HashMap<Layer, TempPref> layerCapacitanceOptions;
    private HashMap<Layer, TempPref> layerEdgeCapacitanceOptions;
    private HashMap<Technology, TempPref> techMinResistance;
    private HashMap<Technology, TempPref> techMinCapacitance;
    private HashMap<Technology, TempPref> techGateLengthShrink;
    private HashMap<Technology, TempPref> techIncludeGateInResistance;
    private HashMap<Technology, TempPref> techIncludeGroundNetwork;
    private HashMap<Technology, TempPref> techMaxSeriesResistance;
    private JList layerList;
    private DefaultListModel layerListModel;
    private boolean changing;
    private JTextField capacitance;
    private JTextField edgeCapacitance;
    private ButtonGroup exemptedNetsGroup;
    private JButton factoryReset;
    private JTextField gateLengthSubtraction;
    private JPanel globalValues;
    private JCheckBox includeGate;
    private JCheckBox includeGround;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JTextField maxSeriesResistance;
    private JTextField minCapacitance;
    private JTextField minResistance;
    private JTextField resistance;
    private JScrollPane spiceLayer;
    private JComboBox techSelection;
    private JPanel techValues;
    private JPanel topPanel;

    public ParasiticTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.topPanel;
    }

    public String getName() {
        return "Parasitic";
    }

    public void init() {
        this.changing = false;
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParasiticTab.this.layerListClick();
            }
        });
        this.layerResistanceOptions = new HashMap();
        this.layerCapacitanceOptions = new HashMap();
        this.layerEdgeCapacitanceOptions = new HashMap();
        this.techMinResistance = new HashMap();
        this.techMinCapacitance = new HashMap();
        this.techGateLengthShrink = new HashMap();
        this.techIncludeGateInResistance = new HashMap();
        this.techIncludeGroundNetwork = new HashMap();
        this.techMaxSeriesResistance = new HashMap();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.techSelection.addItem(tech.getTechName());
            this.techMinResistance.put(tech, TempPref.makeDoublePref(tech.getMinResistance()));
            this.techMinCapacitance.put(tech, TempPref.makeDoublePref(tech.getMinCapacitance()));
            this.techGateLengthShrink.put(tech, TempPref.makeDoublePref(tech.getGateLengthSubtraction()));
            this.techIncludeGateInResistance.put(tech, TempPref.makeBooleanPref(tech.isGateIncluded()));
            this.techIncludeGroundNetwork.put(tech, TempPref.makeBooleanPref(tech.isGroundNetIncluded()));
            this.techMaxSeriesResistance.put(tech, TempPref.makeDoublePref(tech.getMaxSeriesResistance()));
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                this.layerResistanceOptions.put(layer, TempPref.makeDoublePref(layer.getResistance()));
                this.layerCapacitanceOptions.put(layer, TempPref.makeDoublePref(layer.getCapacitance()));
                this.layerEdgeCapacitanceOptions.put(layer, TempPref.makeDoublePref(layer.getEdgeCapacitance()));
            }
        }
        this.techSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.techChanged();
            }
        });
        this.techSelection.setSelectedItem(Technology.getCurrent().getTechName());
        this.resistance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerResistanceOptions, this));
        this.capacitance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerCapacitanceOptions, this));
        this.edgeCapacitance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerEdgeCapacitanceOptions, this));
        this.minResistance.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.minCapacitance.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.maxSeriesResistance.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.gateLengthSubtraction.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.includeGate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.updateTechnologyGlobals();
            }
        });
        this.includeGround.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.updateTechnologyGlobals();
            }
        });
    }

    private void techChanged() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        TempPref pref = this.techMinResistance.get(tech);
        this.minResistance.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = this.techMinCapacitance.get(tech);
        this.minCapacitance.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = this.techGateLengthShrink.get(tech);
        this.gateLengthSubtraction.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = this.techMaxSeriesResistance.get(tech);
        this.maxSeriesResistance.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = this.techIncludeGateInResistance.get(tech);
        this.includeGate.setSelected(pref.getBoolean());
        pref = this.techIncludeGroundNetwork.get(tech);
        this.includeGround.setSelected(pref.getBoolean());
        this.layerListModel.clear();
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            this.layerListModel.addElement(layer.getName());
        }
        this.layerList.setSelectedIndex(0);
        this.layerListClick();
        this.changing = false;
    }

    private void layerListClick() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        String layerName = (String)this.layerList.getSelectedValue();
        Layer layer = tech.findLayer(layerName);
        if (layer != null) {
            TempPref resistancePref = this.layerResistanceOptions.get(layer);
            this.resistance.setText(TextUtils.formatDouble(resistancePref.getDouble()));
            TempPref capacitancePref = this.layerCapacitanceOptions.get(layer);
            this.capacitance.setText(TextUtils.formatDouble(capacitancePref.getDouble()));
            TempPref edgeCapacitancePref = this.layerEdgeCapacitanceOptions.get(layer);
            this.edgeCapacitance.setText(TextUtils.formatDouble(edgeCapacitancePref.getDouble()));
        }
        this.changing = false;
    }

    private void updateTechnologyGlobals() {
        if (this.changing) {
            return;
        }
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        TempPref pref = this.techMinResistance.get(tech);
        pref.setDouble(TextUtils.atof(this.minResistance.getText()));
        pref = this.techMinCapacitance.get(tech);
        pref.setDouble(TextUtils.atof(this.minCapacitance.getText()));
        pref = this.techGateLengthShrink.get(tech);
        pref.setDouble(TextUtils.atof(this.gateLengthSubtraction.getText()));
        pref = this.techMaxSeriesResistance.get(tech);
        pref.setDouble(TextUtils.atof(this.maxSeriesResistance.getText()));
        pref = this.techIncludeGateInResistance.get(tech);
        pref.setBoolean(this.includeGate.isSelected());
        pref = this.techIncludeGroundNetwork.get(tech);
        pref.setBoolean(this.includeGround.isSelected());
    }

    public void term() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            TempPref pref = this.techMinResistance.get(tech);
            if (pref != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setMinResistance(pref.getDouble());
            }
            if ((pref = this.techMinCapacitance.get(tech)) != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setMinCapacitance(pref.getDouble());
            }
            if ((pref = this.techMaxSeriesResistance.get(tech)) != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setMaxSeriesResistance(pref.getDouble());
            }
            if ((pref = this.techGateLengthShrink.get(tech)) != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setGateLengthSubtraction(pref.getDouble());
            }
            if ((pref = this.techIncludeGateInResistance.get(tech)) != null && pref.getBooleanFactoryValue() != pref.getBoolean()) {
                tech.setGateIncluded(pref.getBoolean());
            }
            if ((pref = this.techIncludeGroundNetwork.get(tech)) != null && pref.getBooleanFactoryValue() != pref.getBoolean()) {
                tech.setGroundNetIncluded(pref.getBoolean());
            }
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                TempPref edgeCapacitancePref;
                TempPref capacitancePref;
                Layer layer = lIt.next();
                TempPref resistancePref = this.layerResistanceOptions.get(layer);
                if (resistancePref != null && resistancePref.getDoubleFactoryValue() != resistancePref.getDouble()) {
                    layer.setResistance(resistancePref.getDouble());
                }
                if ((capacitancePref = this.layerCapacitanceOptions.get(layer)) != null && capacitancePref.getDoubleFactoryValue() != capacitancePref.getDouble()) {
                    layer.setCapacitance(capacitancePref.getDouble());
                }
                if ((edgeCapacitancePref = this.layerEdgeCapacitanceOptions.get(layer)) == null || edgeCapacitancePref.getDoubleFactoryValue() == edgeCapacitancePref.getDouble()) continue;
                layer.setEdgeCapacitance(edgeCapacitancePref.getDouble());
            }
        }
    }

    private void factoryResetActionPerformed(ActionEvent evt) {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        int ret = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all layers for technology " + techName + " to their default resistance and capacitance values?", "Factory Reset", 2, 2);
        if (ret == 0) {
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                layer.resetToFactoryParasitics();
            }
            this.init();
        }
    }

    private void initComponents() {
        this.exemptedNetsGroup = new ButtonGroup();
        this.topPanel = new JPanel();
        this.techValues = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resistance = new JTextField();
        this.jLabel12 = new JLabel();
        this.capacitance = new JTextField();
        this.edgeCapacitance = new JTextField();
        this.factoryReset = new JButton();
        this.globalValues = new JPanel();
        this.jLabel20 = new JLabel();
        this.minResistance = new JTextField();
        this.jLabel21 = new JLabel();
        this.minCapacitance = new JTextField();
        this.jLabel5 = new JLabel();
        this.gateLengthSubtraction = new JTextField();
        this.includeGate = new JCheckBox();
        this.includeGround = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.maxSeriesResistance = new JTextField();
        this.jLabel3 = new JLabel();
        this.techSelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new GridBagLayout());
        this.techValues.setLayout(new GridBagLayout());
        this.techValues.setBorder(BorderFactory.createTitledBorder("Layer Values"));
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.techValues.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel2.setText("Perimeter Cap (fF/um):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel2, gridBagConstraints);
        this.resistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.resistance, gridBagConstraints);
        this.jLabel12.setText("Area Cap (fF/um^2):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel12, gridBagConstraints);
        this.capacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.capacitance, gridBagConstraints);
        this.edgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.edgeCapacitance, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.factoryResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.factoryReset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topPanel.add((Component)this.techValues, gridBagConstraints);
        this.globalValues.setLayout(new GridBagLayout());
        this.globalValues.setBorder(BorderFactory.createTitledBorder("Global Values"));
        this.jLabel20.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel20, gridBagConstraints);
        this.minResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minResistance, gridBagConstraints);
        this.jLabel21.setText("Min. Capacitance (fF):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel21, gridBagConstraints);
        this.minCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minCapacitance, gridBagConstraints);
        this.jLabel5.setText("Gate Length Shrink (Subtraction) um:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.gateLengthSubtraction, gridBagConstraints);
        this.includeGate.setText("Include Gate In Resistance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGate, gridBagConstraints);
        this.includeGround.setText("Include Ground Network");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGround, gridBagConstraints);
        this.jLabel1.setText("Max. Series Resistance: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.maxSeriesResistance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.globalValues, gridBagConstraints);
        this.jLabel3.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.techSelection, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    public static void main(String[] args) {
        new ParasiticTab((Frame)new JFrame(), true).setVisible(true);
    }

    private static class ParasiticTechDocumentListener
    implements DocumentListener {
        private ParasiticTab dialog;

        ParasiticTechDocumentListener(ParasiticTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParasiticLayerDocumentListener
    implements DocumentListener {
        private ParasiticTab dialog;
        private HashMap<Layer, TempPref> map;

        ParasiticLayerDocumentListener(HashMap<Layer, TempPref> map, ParasiticTab dialog) {
            this.dialog = dialog;
            this.map = map;
        }

        private void change(DocumentEvent e) {
            String text;
            if (this.dialog.changing) {
                return;
            }
            String techName = (String)this.dialog.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            String layerName = (String)this.dialog.layerList.getSelectedValue();
            Layer layer = tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            TempPref pref = this.map.get(layer);
            double v = TextUtils.atof(text);
            pref.setDouble(v);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }
}

