/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class DRCTab
extends PreferencePanel {
    private boolean requestedDRCClearDates;
    private JPanel drc;
    private JButton drcClearValidDates;
    private JRadioButton drcErrorCell;
    private JRadioButton drcErrorDefault;
    private JRadioButton drcErrorExaustive;
    private JCheckBox drcIgnoreArea;
    private JCheckBox drcIgnoreCenterCuts;
    private JCheckBox drcIgnoreExtensionRules;
    private JCheckBox drcIncrementalOn;
    private ButtonGroup errorTypeGroup;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;

    public DRCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.drc;
    }

    public String getName() {
        return "DRC";
    }

    public void init() {
        this.drcIncrementalOn.setSelected(DRC.isIncrementalDRCOn());
        switch (DRC.getErrorType()) {
            case 0: {
                this.drcErrorDefault.setSelected(true);
                break;
            }
            case 1: {
                this.drcErrorCell.setSelected(true);
                break;
            }
            case 2: {
                this.drcErrorExaustive.setSelected(true);
            }
        }
        this.drcIgnoreCenterCuts.setSelected(DRC.isIgnoreCenterCuts());
        this.drcIgnoreArea.setSelected(DRC.isIgnoreAreaChecking());
        this.drcIgnoreExtensionRules.setSelected(DRC.isIgnoreExtensionRuleChecking());
        this.requestedDRCClearDates = false;
        this.drcClearValidDates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DRCTab.this.drcClearValidDates.setEnabled(false);
                DRCTab.this.requestedDRCClearDates = true;
            }
        });
    }

    public void term() {
        boolean currentValue = this.drcIncrementalOn.isSelected();
        if (currentValue != DRC.isIncrementalDRCOn()) {
            DRC.setIncrementalDRCOn(currentValue);
        }
        if (this.drcErrorDefault.isSelected()) {
            DRC.setErrorType(0);
        } else if (this.drcErrorCell.isSelected()) {
            DRC.setErrorType(1);
        } else if (this.drcErrorExaustive.isSelected()) {
            DRC.setErrorType(2);
        }
        currentValue = this.drcIgnoreCenterCuts.isSelected();
        if (currentValue != DRC.isIgnoreCenterCuts()) {
            DRC.setIgnoreCenterCuts(currentValue);
        }
        if ((currentValue = this.drcIgnoreArea.isSelected()) != DRC.isIgnoreAreaChecking()) {
            DRC.setIgnoreAreaChecking(currentValue);
        }
        if ((currentValue = this.drcIgnoreExtensionRules.isSelected()) != DRC.isIgnoreExtensionRuleChecking()) {
            DRC.setIgnoreExtensionRuleChecking(currentValue);
        }
        if (this.requestedDRCClearDates) {
            DRC.resetDRCDates();
        }
    }

    private void initComponents() {
        this.errorTypeGroup = new ButtonGroup();
        this.drc = new JPanel();
        this.jPanel3 = new JPanel();
        this.drcIncrementalOn = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.drcClearValidDates = new JButton();
        this.drcErrorCell = new JRadioButton();
        this.drcErrorDefault = new JRadioButton();
        this.drcErrorExaustive = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.drcIgnoreCenterCuts = new JCheckBox();
        this.drcIgnoreExtensionRules = new JCheckBox();
        this.drcIgnoreArea = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DRCTab.this.closeDialog(evt);
            }
        });
        this.drc.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new TitledBorder("Incremental DRC"));
        this.drcIncrementalOn.setText("On");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel3.add((Component)this.drcIncrementalOn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Hierarchical DRC"));
        this.drcClearValidDates.setText("Clear valid DRC dates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel4.add((Component)this.drcClearValidDates, gridBagConstraints);
        this.errorTypeGroup.add(this.drcErrorCell);
        this.drcErrorCell.setText("Report just 1 error per cell");
        this.drcErrorCell.setAutoscrolls(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 1, 4);
        this.jPanel4.add((Component)this.drcErrorCell, gridBagConstraints);
        this.errorTypeGroup.add(this.drcErrorDefault);
        this.drcErrorDefault.setSelected(true);
        this.drcErrorDefault.setText("Report just 1 error per pair of geometries");
        this.drcErrorDefault.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel4.add((Component)this.drcErrorDefault, gridBagConstraints);
        this.errorTypeGroup.add(this.drcErrorExaustive);
        this.drcErrorExaustive.setText("Report all errors");
        this.drcErrorExaustive.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.jPanel4.add((Component)this.drcErrorExaustive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new TitledBorder("Incremental and Hierarchical"));
        this.drcIgnoreCenterCuts.setText("Ignore center cuts in large contacts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.drcIgnoreCenterCuts, gridBagConstraints);
        this.drcIgnoreExtensionRules.setText("Ignore extension rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.drcIgnoreExtensionRules, gridBagConstraints);
        this.drcIgnoreArea.setText("Ignore area checking");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.jPanel5.add((Component)this.drcIgnoreArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.jPanel5, gridBagConstraints);
        this.getContentPane().add((Component)this.drc, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

