/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.user.ui.WaveformWindow;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Stimuli {
    public static final int LOGIC = 3;
    public static final int LOGIC_LOW = 0;
    public static final int LOGIC_X = 1;
    public static final int LOGIC_HIGH = 2;
    public static final int LOGIC_Z = 3;
    public static final int STRENGTH = 12;
    public static final int OFF_STRENGTH = 0;
    public static final int NODE_STRENGTH = 4;
    public static final int GATE_STRENGTH = 8;
    public static final int VDD_STRENGTH = 12;
    private WaveformWindow ww;
    private Engine engine;
    private Cell cell;
    private FileType type;
    private URL fileURL;
    private List signals;
    private HashMap signalNames = new HashMap();
    private List allBussedSignals;
    private List sweeps;
    private char separatorChar;
    private double[] commonTime;
    private List sweepCommonTime;

    public Stimuli() {
        this.signals = new ArrayList();
        this.sweeps = new ArrayList();
        this.allBussedSignals = new ArrayList();
        this.sweepCommonTime = new ArrayList();
        this.separatorChar = (char)46;
    }

    public List getSignals() {
        return this.signals;
    }

    public List getBussedSignals() {
        return this.allBussedSignals;
    }

    public void nameSignal(Signal ws, String sigName) {
        String name = TextUtils.canonicString(sigName);
        this.signalNames.put(name, ws);
        if (name.indexOf(95) >= 0 && !name.endsWith("_")) {
            this.signalNames.put(name + "_", ws);
        }
    }

    public void addSignal(Signal ws) {
        this.signals.add(ws);
        String sigName = ws.getFullName();
        if (sigName != null) {
            this.nameSignal(ws, sigName);
        }
    }

    public void buildCommonTime(int numEvents) {
        this.commonTime = new double[numEvents];
    }

    public void addCommonTime(int numEvents) {
        double[] sct = new double[numEvents];
        this.sweepCommonTime.add(sct);
    }

    public void setCommonTime(int index, double time) {
        this.commonTime[index] = time;
    }

    public double[] getCommonTimeArray() {
        return this.commonTime;
    }

    public void setCommonTime(int index, int sweep, double time) {
        double[] sct = (double[])this.sweepCommonTime.get(sweep);
        sct[index] = time;
    }

    public double[] getCommonTimeArray(int sweep) {
        return (double[])this.sweepCommonTime.get(sweep);
    }

    public void addSweep(Object obj) {
        this.sweeps.add(obj);
    }

    public List getSweepList() {
        return this.sweeps;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setWaveformWindow(WaveformWindow ww) {
        this.ww = ww;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(char sep) {
        this.separatorChar = sep;
    }

    public void setDataType(FileType type) {
        this.type = type;
    }

    public FileType getDataType() {
        return this.type;
    }

    public void setFileURL(URL fileURL) {
        this.fileURL = fileURL;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public WaveformWindow getWaveformWindow() {
        return this.ww;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = new Rectangle2D.Double();
        boolean first = true;
        Iterator it = this.signals.iterator();
        while (it.hasNext()) {
            Signal sig = (Signal)it.next();
            Rectangle2D sigBounds = sig.getBounds();
            if (first) {
                bounds = sigBounds;
                first = false;
                continue;
            }
            Rectangle2D.union(bounds, sigBounds, bounds);
        }
        return bounds;
    }

    public boolean isAnalog() {
        Signal sSig;
        return this.getSignals().size() > 0 && (sSig = (Signal)this.getSignals().get(0)) instanceof AnalogSignal;
    }

    public Signal findSignalForNetworkQuickly(String netName) {
        String lookupName = TextUtils.canonicString(netName);
        Signal sSig = (Signal)this.signalNames.get(lookupName);
        return sSig;
    }

    public Signal findSignalForNetwork(String netName) {
        return this.findSignalForNetworkQuickly(netName);
    }

    public static int strengthToIndex(int strength) {
        return strength / 4;
    }

    public static int indexToStrength(int index) {
        return index * 4;
    }

    public static String describeLevel(int state) {
        switch (state & 3) {
            case 0: {
                return "low";
            }
            case 2: {
                return "high";
            }
            case 1: {
                return "undefined";
            }
            case 3: {
                return "floating";
            }
        }
        return "?";
    }

    public static String describeLevelBriefly(int state) {
        switch (state & 3) {
            case 0: {
                return "L";
            }
            case 2: {
                return "H";
            }
            case 1: {
                return "X";
            }
            case 3: {
                return "Z";
            }
        }
        return "?";
    }

    public static int parseLevel(String s1) {
        if (s1.length() > 0) {
            switch (s1.charAt(0)) {
                case 'L': 
                case 'l': {
                    return 0;
                }
                case 'X': 
                case 'x': {
                    return 1;
                }
                case 'H': 
                case 'h': {
                    return 2;
                }
                case 'Z': 
                case 'z': {
                    return 3;
                }
            }
        }
        return 1;
    }

    public static String describeStrength(int strength) {
        switch (strength & 0xC) {
            case 0: {
                return "off";
            }
            case 4: {
                return "node";
            }
            case 8: {
                return "gate";
            }
            case 12: {
                return "power";
            }
        }
        return "?";
    }
}

