/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalPartitionResult {
    private NccGlobals globals;
    private List badPartRecs;
    private List badWireRecs;

    private void prln(String s) {
        System.out.println(s);
    }

    private List getNotMatchedEquivRecs(Iterator it) {
        ArrayList<EquivRecord> mismatched = new ArrayList<EquivRecord>();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (!er.isMismatched()) continue;
            mismatched.add(er);
        }
        return mismatched;
    }

    private void printCircuitContents(List notMatched, List matched, String cktName, String t) {
        NetObject o;
        int numPrint;
        int numNetObjs = notMatched.size() + matched.size();
        this.prln("      " + cktName + " has " + numNetObjs + " of these " + t + ":");
        int maxPrint = this.globals.getOptions().maxEquivRecMembersToPrint;
        if (numNetObjs > maxPrint) {
            this.prln("        Too many " + t + "! I'll only print the first " + maxPrint);
        }
        Iterator it = notMatched.iterator();
        for (numPrint = 0; it.hasNext() && numPrint <= maxPrint; ++numPrint) {
            o = (NetObject)it.next();
            this.prln("      * " + o.fullDescription());
        }
        it = matched.iterator();
        while (it.hasNext() && numPrint <= maxPrint) {
            o = (NetObject)it.next();
            this.prln("        " + o.fullDescription());
            ++numPrint;
        }
    }

    private void printBadRecord(EquivRecord r, String t) {
        this.prln("    The " + t + " in this equivalence class share the following characteristics:");
        List reasons = r.getPartitionReasonsFromRootToMe();
        Iterator it = reasons.iterator();
        while (it.hasNext()) {
            this.prln("      " + it.next());
        }
        ArrayList[] matched = this.getMatchedNetObjs(r);
        ArrayList[] notMatched = this.getNotMatchedNetObjs(r);
        for (int cktNdx = 0; cktNdx < matched.length; ++cktNdx) {
            String cktName = this.globals.getRootCellNames()[cktNdx];
            this.printCircuitContents(notMatched[cktNdx], matched[cktNdx], cktName, t);
        }
    }

    private void printBadRecords(List badRecs, String t) {
        Iterator it = badRecs.iterator();
        while (it.hasNext()) {
            this.printBadRecord((EquivRecord)it.next(), t);
        }
    }

    public LocalPartitionResult(NccGlobals globals) {
        this.globals = globals;
        this.badPartRecs = this.getNotMatchedEquivRecs(globals.getPartLeafEquivRecs().getNotMatched());
        this.badWireRecs = this.getNotMatchedEquivRecs(globals.getWireLeafEquivRecs().getNotMatched());
    }

    public boolean matches() {
        return this.badPartRecs.size() == 0 && this.badWireRecs.size() == 0;
    }

    public int size() {
        return this.badPartRecs.size() + this.badWireRecs.size();
    }

    public Iterator getBadPartEquivRecs() {
        return this.badPartRecs.iterator();
    }

    public int badPartEquivRecCount() {
        return this.badPartRecs.size();
    }

    public Iterator getBadWireEquivRecs() {
        return this.badWireRecs.iterator();
    }

    public int badWireEquivRecCount() {
        return this.badWireRecs.size();
    }

    public ArrayList[] getMatchedNetObjs(EquivRecord er) {
        GetNetObjs gno = new GetNetObjs(this.globals);
        gno.doFor(er);
        return gno.getMatchedNetObjs();
    }

    public ArrayList[] getNotMatchedNetObjs(EquivRecord er) {
        GetNetObjs gno = new GetNetObjs(this.globals);
        gno.doFor(er);
        return gno.getNotMatchedNetObjs();
    }

    public void printErrorReport() {
        if (!this.matches()) {
            this.prln("\n  Mismatches found during local partitioning:\n");
        }
        this.printBadRecords(this.badPartRecs, "Parts");
        this.printBadRecords(this.badWireRecs, "Wires");
    }

    private static class GetNetObjs
    extends Strategy {
        private ArrayList[] matches;
        private ArrayList[] notMatches;

        private void appendNetObjsFromCircuit(ArrayList[] lists, EquivRecord er) {
            int i = 0;
            Iterator itC = er.getCircuits();
            while (itC.hasNext()) {
                Circuit ckt = (Circuit)itC.next();
                Iterator itN = ckt.getNetObjs();
                while (itN.hasNext()) {
                    lists[i].add(itN.next());
                }
                ++i;
            }
        }

        GetNetObjs(NccGlobals globals) {
            super(globals);
            int numDesigns = globals.getNumNetlistsBeingCompared();
            this.matches = new ArrayList[numDesigns];
            this.notMatches = new ArrayList[numDesigns];
            for (int i = 0; i < numDesigns; ++i) {
                this.matches[i] = new ArrayList();
                this.notMatches[i] = new ArrayList();
            }
        }

        public LeafList doFor(EquivRecord er) {
            if (er.isLeaf()) {
                this.appendNetObjsFromCircuit(er.isMatched() ? this.matches : this.notMatches, er);
                return new LeafList();
            }
            return super.doFor(er);
        }

        ArrayList[] getMatchedNetObjs() {
            return this.matches;
        }

        ArrayList[] getNotMatchedNetObjs() {
            return this.notMatches;
        }
    }
}

