/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PartType;
import com.sun.electric.tool.ncc.netlist.PartTypeTable;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Resistor
extends Part {
    public static final PartTypeTable TYPES;
    private static final Set PIN_TYPES;
    private static final Map TYPE_TO_PINTYPE;
    private static final int[] PIN_COEFFS;
    private final PartType type;
    private final double width;
    private final double length;

    private void flip() {
        Wire w = this.pins[0];
        this.pins[0] = this.pins[1];
        this.pins[1] = w;
    }

    public Resistor(PartType type, NccNameProxy.PartNameProxy name, double width, double length, Wire w1, Wire w2) {
        super(name, new Wire[]{w1, w2});
        this.type = type;
        this.width = width;
        this.length = length;
    }

    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    public String valueDescription() {
        String sz = "W= " + this.width + " L=" + this.length;
        return sz;
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return new Integer(hc);
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    public boolean parallelMerge(Part p) {
        return false;
    }

    public int typeCode() {
        int tw = 4;
        return 0 + (this.type.getOrdinal() << 4);
    }

    public Set getPinTypes() {
        return PIN_TYPES;
    }

    public PinType getPinTypeOfNthPin(int n) {
        return (PinType)TYPE_TO_PINTYPE.get(this.type);
    }

    public String typeString() {
        return this.type.getName();
    }

    public String connectionDescription(int n) {
        String s = this.pins[0].getName();
        String e = this.pins[1].getName();
        return "S= " + s + " E= " + e;
    }

    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = s + (i == 0 ? "S" : "E");
        }
        return s;
    }

    static {
        PartType t;
        TYPES = new PartTypeTable(new String[][]{{"N-Poly-RPO-Resistor", "N-Poly-RPO-Resistor"}, {"P-Poly-RPO-Resistor", "P-Poly-RPO-Resistor"}});
        PIN_TYPES = new HashSet();
        TYPE_TO_PINTYPE = new HashMap();
        Iterator it = TYPES.iterator();
        while (it.hasNext()) {
            t = (PartType)it.next();
            PIN_TYPES.add(new ResistorPinType(t));
        }
        it = TYPES.iterator();
        while (it.hasNext()) {
            t = (PartType)it.next();
            TYPE_TO_PINTYPE.put(t, new ResistorPinType(t));
        }
        PIN_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    }

    private static class ResistorPinType
    implements PinType {
        private PartType type;

        public ResistorPinType(PartType t) {
            this.type = t;
        }

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Resistor)) {
                return 0;
            }
            Resistor r = (Resistor)p;
            if (r.type != this.type) {
                return 0;
            }
            int numConns = 0;
            for (int i = 0; i < p.pins.length; ++i) {
                if (p.pins[i] != w) continue;
                ++numConns;
            }
            return numConns;
        }

        public String description() {
            return this.type.getName();
        }
    }
}

