/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import java.awt.Frame;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Spice
extends Topology {
    public static final Variable.Key SPICE_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template");
    public static final Variable.Key SPICE_2_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_spice2");
    public static final Variable.Key SPICE_3_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_spice3");
    public static final Variable.Key SPICE_H_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_hspice");
    public static final Variable.Key SPICE_P_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_pspice");
    public static final Variable.Key SPICE_GC_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_gnucap");
    public static final Variable.Key SPICE_SM_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_smartspice");
    public static final Variable.Key SPICE_CARD_KEY = ElectricObject.newKey("SIM_spice_card");
    public static final Variable.Key SPICE_MODEL_KEY = ElectricObject.newKey("SIM_spice_model");
    public static final Variable.Key SPICE_MODEL_FILE_KEY = ElectricObject.newKey("SIM_spice_behave_file");
    public static final String SPICE_EXTENSION_PREFIX = "Extension ";
    private static final int SPICEMAXLENSUBCKTNAME = 70;
    private static final int CDLMAXLENSUBCKTNAME = 40;
    private static final String SPICELEGALCHARS = "!#$%*+-/<>[]_@";
    private static final String PSPICELEGALCHARS = "!#$%*+-/<>[]_";
    private static final String CDLNOBRACKETLEGALCHARS = "!#$%*+-/<>_";
    private static final boolean CDLWRITESEMPTYSUBCKTS = false;
    private static final boolean USE_GLOBALS = true;
    private Technology layoutTechnology;
    private double maskScale;
    private boolean useCDL;
    private String legalSpiceChars;
    private Variable.Key preferedEngineTemplateKey;
    private int spiceEngine;
    private HashSet modelOverrides = new HashSet();
    private Map uniquifyCells;
    private int uniqueID;
    private Map uniqueNames;
    private static final boolean CELLISEMPTYDEBUG = false;
    private HashMap checkedCells = new HashMap();

    public static void writeSpiceFile(Output.OutputCellInfo cellJob, boolean cdl) {
        String runSpice;
        Spice out = new Spice();
        out.useCDL = cdl;
        if (out.openTextOutputStream(cellJob.filePath)) {
            return;
        }
        if (out.writeCell(cellJob.cell, cellJob.context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(cellJob.filePath + " written");
        if (out.useCDL) {
            String templateFile;
            String deckFile = cellJob.filePath;
            String deckPath = "";
            int lastDirSep = deckFile.lastIndexOf(File.separatorChar);
            if (lastDirSep > 0) {
                deckPath = deckFile.substring(0, lastDirSep);
                deckFile = deckFile.substring(lastDirSep + 1);
            }
            if (out.openTextOutputStream(templateFile = deckPath + File.separator + cellJob.cell.getName() + ".cdltemplate")) {
                return;
            }
            String libName = Simulation.getCDLLibName();
            String libPath = Simulation.getCDLLibPath();
            out.printWriter.print("cdlInKeys = list(nil\n");
            out.printWriter.print("    'searchPath             \"" + deckFile + "");
            if (libPath.length() > 0) {
                out.printWriter.print("\n                             " + libPath);
            }
            out.printWriter.print("\"\n");
            out.printWriter.print("    'cdlFile                \"" + deckPath + File.separator + deckFile + "\"\n");
            out.printWriter.print("    'userSkillFile          \"\"\n");
            out.printWriter.print("    'opusLib                \"" + libName + "\"\n");
            out.printWriter.print("    'primaryCell            \"" + cellJob.cell.getName() + "\"\n");
            out.printWriter.print("    'caseSensitivity        \"lower\"\n");
            out.printWriter.print("    'hierarchy              \"flatten\"\n");
            out.printWriter.print("    'cellTable              \"\"\n");
            out.printWriter.print("    'viewName               \"netlist\"\n");
            out.printWriter.print("    'viewType               \"\"\n");
            out.printWriter.print("    'pr                     nil\n");
            out.printWriter.print("    'skipDevice             nil\n");
            out.printWriter.print("    'schemaLib              \"sample\"\n");
            out.printWriter.print("    'refLib                 \"\"\n");
            out.printWriter.print("    'globalNodeExpand       \"full\"\n");
            out.printWriter.print(")\n");
            if (out.closeTextOutputStream()) {
                return;
            }
            System.out.println(templateFile + " written");
        }
        if (!(runSpice = Simulation.getSpiceRunChoice()).equals("Don't Run")) {
            String workdir;
            String command = Simulation.getSpiceRunProgram() + " " + Simulation.getSpiceRunProgramArgs();
            String rundir = workdir = User.getWorkingDirectory();
            if (Simulation.getSpiceUseRunDir()) {
                rundir = Simulation.getSpiceRunDir();
            }
            File dir = new File(rundir);
            int start = cellJob.filePath.lastIndexOf(File.separator);
            if (start == -1) {
                start = 0;
            } else if (++start > cellJob.filePath.length()) {
                start = cellJob.filePath.length();
            }
            int end = cellJob.filePath.lastIndexOf(".");
            if (end == -1) {
                end = cellJob.filePath.length();
            }
            String filename_noext = cellJob.filePath.substring(start, end);
            String filename = cellJob.filePath.substring(start, cellJob.filePath.length());
            command = command.replaceAll("\\$\\{WORKING_DIR}", workdir);
            command = command.replaceAll("\\$\\{USE_DIR}", rundir);
            command = command.replaceAll("\\$\\{FILENAME}", filename);
            command = command.replaceAll("\\$\\{FILENAME_NO_EXT}", filename_noext);
            FileType type = Simulate.getCurrentSpiceOutputType();
            String[] extensions = type.getExtensions();
            String outFile = rundir + File.separator + filename_noext + "." + extensions[0];
            SpiceFinishedListener l = new SpiceFinishedListener(cellJob.cell, type, outFile);
            if (runSpice.equals("Run, Ingore Output")) {
                Exec e = new Exec(command, null, dir, null, null);
                if (Simulation.getSpiceRunProbe()) {
                    e.addFinishedListener(l);
                }
                e.start();
            }
            if (runSpice.equals("Run, Report Output")) {
                ExecDialog dialog = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
                if (Simulation.getSpiceRunProbe()) {
                    dialog.addFinishedListener(l);
                }
                dialog.startProcess(command, null, dir);
            }
            System.out.println("Running spice command: " + command);
        }
    }

    Spice() {
    }

    protected void start() {
        this.layoutTechnology = Schematics.getDefaultSchematicTechnology();
        this.spiceEngine = Simulation.getSpiceEngine();
        this.preferedEngineTemplateKey = SPICE_TEMPLATE_KEY;
        switch (this.spiceEngine) {
            case 0: {
                this.preferedEngineTemplateKey = SPICE_2_TEMPLATE_KEY;
                break;
            }
            case 1: {
                this.preferedEngineTemplateKey = SPICE_3_TEMPLATE_KEY;
                break;
            }
            case 2: {
                this.preferedEngineTemplateKey = SPICE_H_TEMPLATE_KEY;
                break;
            }
            case 3: {
                this.preferedEngineTemplateKey = SPICE_P_TEMPLATE_KEY;
                break;
            }
            case 4: {
                this.preferedEngineTemplateKey = SPICE_GC_TEMPLATE_KEY;
                break;
            }
            case 5: {
                this.preferedEngineTemplateKey = SPICE_SM_TEMPLATE_KEY;
            }
        }
        this.maskScale = 1.0;
        this.uniquifyCells = new HashMap();
        this.uniqueID = 0;
        this.uniqueNames = new HashMap();
        this.checkIfParameterized(this.topCell);
        this.legalSpiceChars = SPICELEGALCHARS;
        if (this.spiceEngine == 3) {
            this.legalSpiceChars = PSPICELEGALCHARS;
        }
        if (this.useCDL) {
            if (Simulation.isCDLConvertBrackets()) {
                this.legalSpiceChars = CDLNOBRACKETLEGALCHARS;
            }
            this.multiLinePrint(true, "* First line is ignored\n");
        } else {
            this.writeHeader(this.topCell);
        }
        Netlist netList = this.getNetlistForCell(this.topCell);
        Global.Set globals = netList.getGlobals();
        int globalSize = globals.size();
        if (!(Simulation.isSpiceUseNodeNames() && this.spiceEngine == 1 || globalSize <= 0)) {
            StringBuffer infstr = new StringBuffer();
            infstr.append("\n.global");
            for (int i = 0; i < globalSize; ++i) {
                Global global = globals.get(i);
                String name = global.getName();
                if (global == Global.power && this.getPowerName(null) != null) {
                    name = this.getPowerName(null);
                }
                if (global == Global.ground && this.getGroundName(null) != null) {
                    name = this.getGroundName(null);
                }
                infstr.append(" " + name);
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
    }

    protected void done() {
        if (!this.useCDL) {
            this.writeTrailer(this.topCell);
            this.multiLinePrint(false, ".END\n");
        }
    }

    private void writeMFactor(VarContext context, Nodable no, StringBuffer infstr) {
        Variable mVar = no.getVar(Simulation.M_FACTOR_KEY);
        if (mVar == null) {
            return;
        }
        Object value = context.evalVar(mVar);
        if (mVar.getObject().toString().equals("@M") || mVar.getObject().toString().equals("P(\"M\")")) {
            System.out.println("Warning: M=@M [eval=" + value + "] on " + no.getName() + " is a bad idea, not writing it out: " + context.push(no).getInstPath("."));
            return;
        }
        if (this.useCDL) {
            infstr.append(" M=" + value.toString());
        } else {
            infstr.append(" M=" + Spice.formatParam(value.toString()));
        }
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        Iterator sIt;
        String message;
        Netlist netList = cni.getNetList();
        if (cell == this.topCell && !Simulation.isSpiceForceGlobalPwrGnd()) {
            if (cni.getPowerNet() == null) {
                System.out.println("WARNING: cannot find power at top level of circuit");
            }
            if (cni.getGroundNet() == null) {
                System.out.println("WARNING: cannot find ground at top level of circuit");
            }
        }
        HashMap<Network, SpiceNet> spiceNetMap = new HashMap<Network, SpiceNet>();
        Iterator it = netList.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            SpiceNet spNet = new SpiceNet();
            spNet.network = net;
            spNet.transistorCount = 0;
            spNet.diffArea = 0.0;
            spNet.diffPerim = 0.0;
            spNet.nonDiffCapacitance = 0.0f;
            spNet.merge = new PolyMerge();
            spiceNetMap.put(net, spNet);
        }
        int bipolarTrans = 0;
        int nmosTrans = 0;
        int pmosTrans = 0;
        Iterator aIt = cell.getNodes();
        while (aIt.hasNext()) {
            NodeInst ni = (NodeInst)aIt.next();
            this.addNodeInformation(netList, spiceNetMap, ni);
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRANS) {
                ++bipolarTrans;
                continue;
            }
            if (fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS) {
                ++nmosTrans;
                continue;
            }
            if (fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS) continue;
            ++pmosTrans;
        }
        aIt = cell.getArcs();
        while (aIt.hasNext()) {
            Network net;
            SpiceNet spNet;
            ArcInst ai = (ArcInst)aIt.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || (spNet = (SpiceNet)spiceNetMap.get(net = netList.getNetwork(ai, 0))) == null) continue;
            this.addArcInformation(spNet.merge, ai);
        }
        Iterator it2 = netList.getNetworks();
        while (it2.hasNext()) {
            Network net = (Network)it2.next();
            SpiceNet spNet = (SpiceNet)spiceNetMap.get(net);
            Iterator lIt = spNet.merge.getKeyIterator();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                List polyList = spNet.merge.getMergedPoints(layer, true);
                if (polyList == null) continue;
                if (polyList.size() > 1) {
                    Collections.sort(polyList, GeometryHandler.shapeSort);
                }
                Iterator pIt = polyList.iterator();
                while (pIt.hasNext()) {
                    PolyBase poly = (PolyBase)pIt.next();
                    double perim = poly.getPerimeter();
                    double area = poly.getArea();
                    double scale = this.layoutTechnology.getScale();
                    if (layer.isDiffusionLayer()) {
                        spNet.diffArea += area * this.maskScale * this.maskScale;
                        spNet.diffPerim += perim * this.maskScale;
                        continue;
                    }
                    area = area * scale * scale / 1000000.0;
                    perim = perim * scale / 1000.0;
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getCapacitance() * area * this.maskScale * this.maskScale);
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getEdgeCapacitance() * perim * this.maskScale);
                }
            }
        }
        Network groundNet = cni.getGroundNet();
        Network powerNet = cni.getPowerNet();
        if (pmosTrans != 0 && powerNet == null) {
            message = "WARNING: no power connection for P-transistor wells in " + cell;
            this.dumpErrorMessage(message);
        }
        if (nmosTrans != 0 && groundNet == null) {
            message = "WARNING: no ground connection for N-transistor wells in " + cell;
            this.dumpErrorMessage(message);
        }
        if (cell == this.topCell && !this.useCDL) {
            this.multiLinePrint(true, "\n*** TOP LEVEL CELL: " + cell.describe(false) + "\n");
        } else {
            Topology.CellSignal cs;
            Global global;
            if (this.useCDL && this.cellIsEmpty(cell)) {
                return;
            }
            String cellName = cni.getParameterizedName();
            this.multiLinePrint(false, "\n*** CELL: " + cell.describe(false) + "\n");
            StringBuffer infstr = new StringBuffer();
            infstr.append(".SUBCKT " + cellName);
            sIt = cni.getCellSignals();
            while (sIt.hasNext()) {
                Topology.CellSignal cs2 = (Topology.CellSignal)sIt.next();
                Export pp = cs2.getExport();
                if (pp == null || cs2.isGlobal() && !cs2.getNetwork().isExported()) continue;
                if (this.useCDL) {
                    // empty if block
                }
                infstr.append(" " + cs2.getName());
            }
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == 1) {
                for (int i = 0; i < globalSize; ++i) {
                    global = globals.get(i);
                    Network net = netList.getNetwork(global);
                    cs = cni.getCellSignal(net);
                    infstr.append(" " + cs.getName());
                }
            }
            if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                Iterator it3 = cell.getVariables();
                while (it3.hasNext()) {
                    Variable paramVar = (Variable)it3.next();
                    if (!paramVar.isParam()) continue;
                    infstr.append(" " + paramVar.getTrueName() + "=" + paramVar.getPureValue(-1));
                }
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
            for (int i = 0; i < globalSize; ++i) {
                global = globals.get(i);
                Network net = netList.getNetwork(global);
                cs = cni.getCellSignal(net);
                this.multiLinePrint(true, "** GLOBAL " + cs.getName() + "\n");
            }
            Iterator sIt2 = cni.getCellSignals();
            while (sIt2.hasNext()) {
                Topology.CellSignal cs3 = (Topology.CellSignal)sIt2.next();
                Export pp = cs3.getExport();
                if (pp == null || cs3.isGlobal()) continue;
                this.multiLinePrint(true, "** PORT " + cs3.getName() + "\n");
            }
        }
        Iterator nIt = netList.getNodables();
        while (nIt.hasNext()) {
            TransistorSize size;
            Nodable no = (Nodable)nIt.next();
            NodeProto niProto = no.getProto();
            if (niProto instanceof Cell) {
                Cell subCell = (Cell)niProto;
                Variable varTemplate = subCell.getVar(this.preferedEngineTemplateKey);
                if (varTemplate == null) {
                    varTemplate = subCell.getVar(SPICE_TEMPLATE_KEY);
                }
                if (varTemplate != null && !this.useCDL) {
                    String line = varTemplate.getObject().toString();
                    StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni);
                    this.writeMFactor(context, no, infstr);
                    infstr.append('\n');
                    this.multiLinePrint(false, infstr.toString());
                    continue;
                }
                Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
                if (subCni == null || this.useCDL && this.cellIsEmpty((Cell)niProto)) continue;
                String modelChar = "X";
                if (no.getName() != null) {
                    modelChar = modelChar + this.getSafeNetName(no.getName(), false);
                }
                StringBuffer infstr = new StringBuffer();
                infstr.append(modelChar);
                Iterator sIt3 = subCni.getCellSignals();
                while (sIt3.hasNext()) {
                    Topology.CellSignal subCS = (Topology.CellSignal)sIt3.next();
                    Export pp = subCS.getExport();
                    if (pp == null) continue;
                    Network net = netList.getNetwork(no, pp, subCS.getExportIndex());
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(" " + cs.getName());
                }
                if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == 1) {
                    Global.Set globals = subCni.getNetList().getGlobals();
                    int globalSize = globals.size();
                    for (int i = 0; i < globalSize; ++i) {
                        Global global = globals.get(i);
                        infstr.append(" " + global.getName());
                    }
                }
                if (this.useCDL) {
                    infstr.append(" /" + subCni.getParameterizedName());
                } else {
                    infstr.append(" " + subCni.getParameterizedName());
                }
                if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                    Iterator it4 = subCell.getVariables();
                    while (it4.hasNext()) {
                        Variable paramVar = (Variable)it4.next();
                        if (!paramVar.isParam()) continue;
                        Variable instVar = no.getVar(paramVar.getKey());
                        String paramStr = "??";
                        if (instVar != null) {
                            paramStr = Spice.formatParam(Spice.trimSingleQuotes(String.valueOf(context.evalVar(instVar))));
                        }
                        infstr.append(" " + paramVar.getTrueName() + "=" + paramStr);
                    }
                }
                this.writeMFactor(context, no, infstr);
                infstr.append("\n");
                this.multiLinePrint(false, infstr.toString());
                continue;
            }
            NodeInst ni = (NodeInst)no;
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.RESIST || fun == PrimitiveNode.Function.INDUCT || fun == PrimitiveNode.Function.CAPAC || fun == PrimitiveNode.Function.ECAPAC || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                String extra;
                if (fun == PrimitiveNode.Function.RESIST) {
                    if (this.useCDL && Simulation.getCDLIgnoreResistors()) continue;
                    Variable resistVar = ni.getVar(Schematics.SCHEM_RESISTANCE);
                    extra = "";
                    if (resistVar != null && TextUtils.isANumber(extra = resistVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.formatDoublePostFix(pureValue);
                    }
                    this.writeTwoPort(ni, "R", extra, cni, netList, context);
                    continue;
                }
                if (fun == PrimitiveNode.Function.CAPAC || fun == PrimitiveNode.Function.ECAPAC) {
                    Variable capacVar = ni.getVar(Schematics.SCHEM_CAPACITANCE);
                    extra = "";
                    if (capacVar != null && TextUtils.isANumber(extra = capacVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.formatDoublePostFix(pureValue);
                    }
                    this.writeTwoPort(ni, "C", extra, cni, netList, context);
                    continue;
                }
                if (fun == PrimitiveNode.Function.INDUCT) {
                    Variable inductVar = ni.getVar(Schematics.SCHEM_INDUCTANCE);
                    extra = "";
                    if (inductVar != null && TextUtils.isANumber(extra = inductVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.formatDoublePostFix(pureValue);
                    }
                    this.writeTwoPort(ni, "L", extra, cni, netList, context);
                    continue;
                }
                if (fun != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.DIODEZ) continue;
                Variable diodeVar = ni.getVar(Schematics.SCHEM_DIODE);
                extra = "";
                if (diodeVar != null) {
                    extra = diodeVar.describe(context, ni);
                }
                if (extra.length() == 0) {
                    extra = "DIODE";
                }
                this.writeTwoPort(ni, "D", extra, cni, netList, context);
                continue;
            }
            if (((PrimitiveNode)niProto).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
            Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
            Topology.CellSignal gateCs = cni.getCellSignal(gateNet);
            Network sourceNet = netList.getNetwork(ni.getTransistorSourcePort());
            Topology.CellSignal sourceCs = cni.getCellSignal(sourceNet);
            Network drainNet = netList.getNetwork(ni.getTransistorDrainPort());
            Topology.CellSignal drainCs = cni.getCellSignal(drainNet);
            Topology.CellSignal biasCs = null;
            PortInst biasPort = ni.getTransistorBiasPort();
            if (biasPort != null) {
                biasCs = cni.getCellSignal(netList.getNetwork(biasPort));
            }
            if (gateCs == null || sourceCs == null || drainCs == null) {
                String message2 = "WARNING: " + ni + " not fully connected in " + cell;
                this.dumpErrorMessage(message2);
            }
            String modelName = null;
            Variable modelVar = ni.getVar(SPICE_MODEL_KEY);
            if (modelVar != null) {
                modelName = modelVar.getObject().toString();
            }
            String modelChar = "";
            if (fun == PrimitiveNode.Function.TRANSREF) {
                modelChar = "X";
                biasCs = cni.getCellSignal(groundNet);
                modelName = niProto.getName();
            } else if (fun == PrimitiveNode.Function.TRANMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                if (modelName == null) {
                    modelName = "N";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "N";
                }
            } else if (fun == PrimitiveNode.Function.TRADMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRA4DMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRAPMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(powerNet);
                if (modelName == null) {
                    modelName = "P";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "P";
                }
            } else if (fun == PrimitiveNode.Function.TRANPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRAPNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRANJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRAPJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "DMES";
            } else if (fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "EMES";
            } else if (fun == PrimitiveNode.Function.TRANS) {
                modelChar = "Q";
            }
            if (ni.getName() != null) {
                modelChar = modelChar + this.getSafeNetName(ni.getName(), false);
            }
            StringBuffer infstr = new StringBuffer();
            infstr.append(modelChar + " " + drainCs.getName() + " " + gateCs.getName() + " " + sourceCs.getName());
            if (biasCs != null) {
                infstr.append(" " + biasCs.getName());
            }
            if (modelName != null) {
                infstr.append(" " + modelName);
            }
            if ((size = ni.getTransistorSize(context)).getDoubleWidth() > 0.0 || size.getDoubleLength() > 0.0) {
                double w = this.maskScale * size.getDoubleWidth();
                double l = this.maskScale * size.getDoubleLength();
                double lengthSubtraction = this.layoutTechnology.getGateLengthSubtraction() / this.layoutTechnology.getScale() * 1000.0;
                l -= lengthSubtraction;
                if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                    l *= this.layoutTechnology.getScale() / 1000.0;
                    w *= this.layoutTechnology.getScale() / 1000.0;
                }
                if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || (fun == PrimitiveNode.Function.TRANJFET || fun == PrimitiveNode.Function.TRAPJFET || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRAEMES) && this.spiceEngine == 2) {
                    if (size.getDoubleLength() == 0.0 && size.getLength() instanceof String) {
                        if (lengthSubtraction != 0.0) {
                            infstr.append(" L=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getLength()) + " - " + lengthSubtraction));
                        } else {
                            infstr.append(" L=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getLength())));
                        }
                    } else {
                        infstr.append(" L=" + TextUtils.formatDouble(l, 2));
                        if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                            infstr.append("U");
                        }
                    }
                    if (size.getDoubleWidth() == 0.0 && size.getWidth() instanceof String) {
                        infstr.append(" W=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getWidth())));
                    } else {
                        infstr.append(" W=" + TextUtils.formatDouble(w, 2));
                        if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                            infstr.append("U");
                        }
                    }
                }
                if (fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS) {
                    infstr.append(" AREA=" + TextUtils.formatDouble(l * w, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
            } else {
                double lengthSubtraction = this.layoutTechnology.getGateLengthSubtraction() / this.layoutTechnology.getScale() * 1000.0;
                if (size.getDoubleLength() == 0.0 && size.getLength() instanceof String) {
                    if (lengthSubtraction != 0.0) {
                        infstr.append(" L=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getLength()) + " - " + lengthSubtraction));
                    } else {
                        infstr.append(" L=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getLength())));
                    }
                }
                if (size.getDoubleWidth() == 0.0 && size.getWidth() instanceof String) {
                    infstr.append(" W=" + Spice.formatParam(Spice.trimSingleQuotes((String)size.getWidth())));
                }
            }
            SpiceNet spNetGate = (SpiceNet)spiceNetMap.get(gateNet);
            SpiceNet spNetSource = (SpiceNet)spiceNetMap.get(sourceNet);
            SpiceNet spNetDrain = (SpiceNet)spiceNetMap.get(drainNet);
            if (spNetGate == null || spNetSource == null || spNetDrain == null) continue;
            if (!(this.useCDL || fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS)) {
                double as = 0.0;
                double ad = 0.0;
                double ps = 0.0;
                double pd = 0.0;
                if (spNetSource.transistorCount != 0) {
                    as = spNetSource.diffArea / (double)spNetSource.transistorCount;
                    ps = spNetSource.diffPerim / (double)spNetSource.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        as *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        ps *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (spNetDrain.transistorCount != 0) {
                    ad = spNetDrain.diffArea / (double)spNetDrain.transistorCount;
                    pd = spNetDrain.diffPerim / (double)spNetDrain.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        ad *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        pd *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (as > 0.0) {
                    infstr.append(" AS=" + TextUtils.formatDouble(as, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
                if (ad > 0.0) {
                    infstr.append(" AD=" + TextUtils.formatDouble(ad, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
                if (ps > 0.0) {
                    infstr.append(" PS=" + TextUtils.formatDouble(ps, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                }
                if (pd > 0.0) {
                    infstr.append(" PD=" + TextUtils.formatDouble(pd, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                }
            }
            this.writeMFactor(context, ni, infstr);
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
        if (!this.useCDL && Simulation.isSpiceUseParasitics()) {
            boolean first = true;
            int capacNum = 1;
            sIt = cni.getCellSignals();
            while (sIt.hasNext()) {
                Topology.CellSignal cs = (Topology.CellSignal)sIt.next();
                Network net = cs.getNetwork();
                if (net == cni.getGroundNet()) continue;
                SpiceNet spNet = (SpiceNet)spiceNetMap.get(net);
                if (!((double)spNet.nonDiffCapacitance > this.layoutTechnology.getMinCapacitance())) continue;
                if (first) {
                    first = false;
                    this.multiLinePrint(true, "** Extracted Parasitic Elements:\n");
                }
                this.multiLinePrint(false, "C" + capacNum + " " + cs.getName() + " 0 " + TextUtils.formatDouble(spNet.nonDiffCapacitance, 2) + "fF\n");
                ++capacNum;
            }
        }
        Iterator it5 = cell.getNodes();
        while (it5.hasNext()) {
            Object obj;
            Variable cardVar;
            NodeInst ni = (NodeInst)it5.next();
            if (ni.getProto() != Generic.tech.invisiblePinNode || (cardVar = ni.getVar(SPICE_CARD_KEY)) == null || !((obj = cardVar.getObject()) instanceof String) && !(obj instanceof String[]) || !cardVar.isDisplay()) continue;
            if (obj instanceof String) {
                StringBuffer buf = this.replacePortsAndVars((String)obj, context.getNodable(), context.pop(), null);
                this.multiLinePrint(false, buf.toString() + "\n");
                continue;
            }
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                StringBuffer buf = this.replacePortsAndVars(strings[i], context.getNodable(), context.pop(), null);
                this.multiLinePrint(false, buf.toString() + "\n");
            }
        }
        if (cell != this.topCell || this.useCDL) {
            this.multiLinePrint(false, ".ENDS " + cni.getParameterizedName() + "\n");
        }
    }

    private boolean checkIfParameterized(Cell cell) {
        boolean mark = false;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
            if (ni.getVar("ATTR_LEGATE") != null) {
                mark = true;
                continue;
            }
            if (ni.getVar("ATTR_LEKEEPER") != null) {
                mark = true;
                continue;
            }
            Cell proto = ((Cell)ni.getProto()).contentsView();
            if (proto == null) {
                proto = (Cell)ni.getProto();
            }
            if (!this.checkIfParameterized(proto)) continue;
            mark = true;
        }
        if (mark) {
            this.uniquifyCells.put(cell, cell);
        }
        return mark;
    }

    protected String parameterizedName(Nodable no, VarContext context) {
        Cell cell = (Cell)no.getProto();
        StringBuffer uniqueCellName = new StringBuffer(this.getUniqueCellName(cell));
        if (this.uniquifyCells.get(cell) != null) {
            VarContext vc = context.push(no);
            uniqueCellName.append("_" + vc.getInstPath("."));
        } else if (this.canParameterizeNames() && no.getProto() instanceof Cell) {
            Variable var;
            ArrayList<Variable> paramValues = new ArrayList<Variable>();
            Iterator it = no.getVariables();
            while (it.hasNext()) {
                var = (Variable)it.next();
                if (!var.isParam()) continue;
                paramValues.add(var);
            }
            it = paramValues.iterator();
            while (it.hasNext()) {
                var = (Variable)it.next();
                String eval = var.describe(context, no);
                if (eval == null) continue;
                uniqueCellName.append("-" + eval.toString());
            }
        }
        int limit = this.maxNameLength();
        if (limit > 0 && uniqueCellName.length() > limit) {
            Integer i = (Integer)this.uniqueNames.get(uniqueCellName.toString());
            if (i == null) {
                i = new Integer(this.uniqueID);
                ++this.uniqueID;
                this.uniqueNames.put(uniqueCellName.toString(), i);
            }
            uniqueCellName = uniqueCellName.delete(limit - 10, uniqueCellName.length());
            uniqueCellName.append("-ID" + i);
        }
        return this.getSafeCellName(uniqueCellName.toString());
    }

    private StringBuffer replacePortsAndVars(String line, Nodable no, VarContext context, Topology.CellNetInfo cni) {
        StringBuffer infstr = new StringBuffer();
        Cell subCell = null;
        if (no != null) {
            subCell = (Cell)no.getProto();
        }
        for (int pt = 0; pt < line.length(); ++pt) {
            int start;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = start = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            if (subCell == null) continue;
            String paramName = line.substring(start, pt);
            PortProto pp = subCell.findPortProto(paramName);
            if (cni != null && pp != null) {
                Network net = cni.getNetList().getNetwork(no, pp, 0);
                Topology.CellSignal cs = cni.getCellSignal(net);
                infstr.append(cs.getName());
                continue;
            }
            if (paramName.equalsIgnoreCase("node_name")) {
                String nodeName = this.getSafeNetName(no.getName(), false);
                infstr.append(nodeName);
                continue;
            }
            String varName = "ATTR_" + paramName;
            Variable attrVar = no.getVar(varName);
            if (attrVar == null) {
                attrVar = no.getParameter(varName);
            }
            if (attrVar == null) {
                infstr.append("??");
                continue;
            }
            infstr.append(Spice.trimSingleQuotes(String.valueOf(context.evalVar(attrVar, no))));
        }
        return infstr;
    }

    protected String getSafeCellName(String name) {
        return this.getSafeNetName(name, false);
    }

    protected String getPowerName(Network net) {
        if (net != null) {
            Iterator it = net.getNames();
            while (it.hasNext()) {
                String netName = (String)it.next();
                if (!netName.equalsIgnoreCase("vdd")) continue;
                return "vdd";
            }
        }
        return null;
    }

    protected String getGroundName(Network net) {
        if (this.spiceEngine == 3) {
            return "0";
        }
        if (net != null) {
            Iterator it = net.getNames();
            while (it.hasNext()) {
                String netName = (String)it.next();
                if (!netName.equalsIgnoreCase("gnd")) continue;
                return "gnd";
            }
        }
        return null;
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    protected boolean isAggregateNamesSupported() {
        return false;
    }

    protected boolean isSeparateInputAndOutput() {
        return false;
    }

    protected boolean skipCellAndSubcells(Cell cell) {
        String fileName;
        if (this.useCDL) {
            return false;
        }
        Variable varTemplate = cell.getVar(this.preferedEngineTemplateKey);
        if (varTemplate != null) {
            return true;
        }
        varTemplate = cell.getVar(SPICE_TEMPLATE_KEY);
        if (varTemplate != null) {
            return true;
        }
        Variable var = cell.getVar(SPICE_MODEL_FILE_KEY);
        if (var != null && !(fileName = var.getObject().toString()).startsWith("-----")) {
            if (!this.modelOverrides.contains(cell)) {
                this.multiLinePrint(true, "\n* " + cell + " is described in this file:\n");
                this.addIncludeFile(fileName);
                this.modelOverrides.add(cell);
            }
            return true;
        }
        return false;
    }

    protected String getSafeNetName(String name, boolean bus) {
        boolean allAlNum = true;
        int len = name.length();
        if (len <= 0) {
            return name;
        }
        for (int i = 0; i < len; ++i) {
            boolean valid = TextUtils.isLetterOrDigit(name.charAt(i));
            if (i == 0) {
                valid = Character.isLetter(name.charAt(i));
            }
            if (valid) continue;
            allAlNum = false;
            break;
        }
        if (allAlNum) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(name.charAt(0))) {
            sb.append('_');
        }
        for (int t = 0; t < name.length(); ++t) {
            char chr = name.charAt(t);
            boolean legalChar = TextUtils.isLetterOrDigit(chr);
            if (!legalChar) {
                for (int j = 0; j < this.legalSpiceChars.length(); ++j) {
                    char legalChr = this.legalSpiceChars.charAt(j);
                    if (chr != legalChr) continue;
                    legalChar = true;
                    break;
                }
            }
            if (!legalChar) {
                chr = '_';
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    protected Netlist getNetlistForCell(Cell cell) {
        boolean shortResistors = false;
        if (this.useCDL && Simulation.getCDLIgnoreResistors()) {
            shortResistors = true;
        }
        Netlist netList = cell.getNetlist(shortResistors);
        return netList;
    }

    protected boolean canParameterizeNames() {
        return true;
    }

    protected int maxNameLength() {
        if (this.useCDL) {
            return 40;
        }
        return 70;
    }

    private void writeHeader(Cell cell) {
        String headerFile;
        this.multiLinePrint(true, "*** SPICE deck for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        this.emitCopyright("*** ", "");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.multiLinePrint(true, "*** Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + "\n");
            this.multiLinePrint(true, "*** Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + "\n");
            this.multiLinePrint(true, "*** Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + "\n");
        } else {
            this.multiLinePrint(true, "*** Written by Electric VLSI Design System\n");
        }
        this.multiLinePrint(true, "*** UC SPICE *** , MIN_RESIST " + this.layoutTechnology.getMinResistance() + ", MIN_CAPAC " + this.layoutTechnology.getMinCapacitance() + "FF\n");
        this.multiLinePrint(false, ".OPTIONS NOMOD NOPAGE\n");
        if (Simulation.isSpiceWriteTransSizeInLambda()) {
            double scale = this.layoutTechnology.getScale();
            this.multiLinePrint(false, "*** Lambda Conversion ***\n");
            this.multiLinePrint(false, ".opt scale=" + TextUtils.formatDouble(scale / 1000.0, 3) + "U\n\n");
        }
        if ((headerFile = Simulation.getSpiceHeaderCardInfo()).length() > 0) {
            if (headerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String headerPath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
                String ext = headerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = headerPath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Model cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                    return;
                }
            } else {
                File test = new File(headerFile);
                if (!test.exists()) {
                    System.out.println("Warning: cannot find model file '" + headerFile + "'");
                }
                this.multiLinePrint(true, "* Model cards are described in this file:\n");
                this.addIncludeFile(headerFile);
                return;
            }
        }
        int level = TextUtils.atoi(Simulation.getSpiceLevel());
        String[] header = null;
        switch (level) {
            case 1: {
                header = this.layoutTechnology.getSpiceHeaderLevel1();
                break;
            }
            case 2: {
                header = this.layoutTechnology.getSpiceHeaderLevel2();
                break;
            }
            case 3: {
                header = this.layoutTechnology.getSpiceHeaderLevel3();
            }
        }
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                this.multiLinePrint(false, header[i] + "\n");
            }
            return;
        }
        System.out.println("WARNING: no model cards for SPICE level " + level + " in " + this.layoutTechnology.getTechName() + " technology");
    }

    private void writeTrailer(Cell cell) {
        String trailerFile = Simulation.getSpiceTrailerCardInfo();
        if (trailerFile.length() > 0) {
            if (trailerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String trailerpath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
                String filePart = cell.getName() + "." + trailerFile.substring(SPICE_EXTENSION_PREFIX.length());
                String fileName = trailerpath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                }
            } else {
                this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                this.addIncludeFile(trailerFile);
            }
        }
    }

    private void writeTwoPort(NodeInst ni, String partName, String extra, Topology.CellNetInfo cni, Netlist netList, VarContext context) {
        String message;
        PortInst port0 = ni.getPortInst(0);
        PortInst port1 = ni.getPortInst(1);
        Network net0 = netList.getNetwork(port0);
        Network net1 = netList.getNetwork(port1);
        Topology.CellSignal cs0 = cni.getCellSignal(net0);
        Topology.CellSignal cs1 = cni.getCellSignal(net1);
        if (cs0 == null || cs1 == null) {
            message = "WARNING: " + ni + " component not fully connected in " + ni.getParent();
            this.dumpErrorMessage(message);
        }
        if (cs0 != null && cs1 != null && cs0 == cs1) {
            message = "WARNING: " + ni + " component appears to be shorted on net " + net0.toString() + " in " + ni.getParent();
            this.dumpErrorMessage(message);
            return;
        }
        if (ni.getName() != null) {
            partName = partName + this.getSafeNetName(ni.getName(), false);
        }
        StringBuffer sbExtra = new StringBuffer(extra);
        this.writeMFactor(context, ni, sbExtra);
        this.multiLinePrint(false, partName + " " + cs1.getName() + " " + cs0.getName() + " " + sbExtra.toString() + "\n");
    }

    private static String formatParam(String param) {
        if (param.endsWith("'") || param.startsWith("'")) {
            return param;
        }
        return "'" + param + "'";
    }

    private static String trimSingleQuotes(String param) {
        if (param.startsWith("'") && param.endsWith("'")) {
            return param.substring(1, param.length() - 1);
        }
        return param;
    }

    private void addNodeInformation(Netlist netList, HashMap spiceNets, NodeInst ni) {
        NodeProto np = ni.getProto();
        if (np instanceof Cell) {
            return;
        }
        PrimitiveNode.Function function = ni.getFunction();
        Technology tech = np.getTechnology();
        AffineTransform trans = ni.rotateOut();
        Poly[] polyList = tech.getShapeOfNode(ni, null, null, true, true, null);
        int tot = polyList.length;
        for (int i = 0; i < tot; ++i) {
            SpiceNet spNet;
            Poly poly = polyList[i];
            PortProto pp = poly.getPort();
            if (pp == null) continue;
            Network net = netList.getNetwork(ni, pp, 0);
            Layer layer = poly.getLayer();
            if (!layer.isDiffusionLayer() && layer.getCapacitance() == 0.0 || layer.getTechnology() != Technology.getCurrent() || layer.getFunction() == Layer.Function.GATE || (spNet = (SpiceNet)spiceNets.get(net)) == null) continue;
            poly.transform(trans);
            spNet.merge.addPolygon(layer, poly);
            if (!layer.isDiffusionLayer() || !function.isTransistor()) continue;
            ++spNet.transistorCount;
        }
    }

    private void addArcInformation(PolyMerge merge, ArcInst ai) {
        boolean isDiffArc = ai.isDiffusionArc();
        Technology tech = ai.getProto().getTechnology();
        Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
        int tot = arcInstPolyList.length;
        for (int j = 0; j < tot; ++j) {
            Layer layer;
            Poly poly = arcInstPolyList[j];
            if (poly.getStyle().isText() || (layer = poly.getLayer()).getTechnology() != Technology.getCurrent() || (layer.getFunctionExtras() & 0x1000) != 0 || !layer.isDiffusionLayer() && (isDiffArc || !(layer.getCapacitance() > 0.0))) continue;
            merge.addPolygon(layer, poly);
        }
    }

    private void addIncludeFile(String fileName) {
        if (this.spiceEngine == 0 || this.spiceEngine == 1 || this.spiceEngine == 4 || this.spiceEngine == 5) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
        } else if (this.spiceEngine == 2) {
            this.multiLinePrint(false, ".include '" + fileName + "'\n");
        } else if (this.spiceEngine == 3) {
            this.multiLinePrint(false, ".INC " + fileName + "\n");
        }
    }

    private boolean cellIsEmpty(Cell cell) {
        Boolean b = (Boolean)this.checkedCells.get(cell);
        if (b != null) {
            return b;
        }
        boolean empty = true;
        ArrayList emptyCells = new ArrayList();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() instanceof Cell) {
                if (ni.isIconOfParent()) continue;
                Cell iconCell = (Cell)ni.getProto();
                Cell schCell = iconCell.contentsView();
                if (schCell == null) {
                    schCell = iconCell;
                }
                if (this.cellIsEmpty(schCell)) continue;
                empty = false;
                break;
            }
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.RESIST || fun == PrimitiveNode.Function.INDUCT || fun == PrimitiveNode.Function.CAPAC || fun == PrimitiveNode.Function.ECAPAC || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                empty = false;
                break;
            }
            if (((PrimitiveNode)ni.getProto()).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
            empty = false;
            break;
        }
        this.checkedCells.put(cell, new Boolean(empty));
        return empty;
    }

    private void dumpErrorMessage(String message) {
        this.multiLinePrint(true, "*** " + message + "\n");
        System.out.println(message);
    }

    private void multiLinePrint(boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                this.printWriter.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < 78 || insideQuotes) continue;
            if (lastSpace < 0) {
                lastSpace = pt;
            }
            String partial = str.substring(lineStart, lastSpace + 1);
            this.printWriter.print(partial + "\n" + contChar);
            count = 1;
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            this.printWriter.print(partial);
        }
    }

    private static class SpiceFinishedListener
    implements Exec.FinishedListener {
        private Cell cell;
        private FileType type;
        private String file;

        private SpiceFinishedListener(Cell cell, FileType type, String file) {
            this.cell = cell;
            this.type = type;
            this.file = file;
        }

        public void processFinished(Exec.FinishedEvent e) {
            URL fileURL = TextUtils.makeURLToFile(this.file);
            WaveformWindow ww = WaveformWindow.findWaveformWindow(this.cell);
            Simulate.plotSimulationResults(this.type, this.cell, fileURL, ww);
        }
    }

    private static class SpiceNet {
        Network network;
        PolyMerge merge;
        double diffArea;
        double diffPerim;
        float nonDiffCapacitance;
        int transistorCount;

        private SpiceNet() {
        }
    }
}

