/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.TextAttributesPanel;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class GetInfoText
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoText theDialog = null;
    private EditWindow wnd;
    private CachedTextInfo cti;
    private JButton apply;
    private JButton cancel;
    private JLabel evaluation;
    private JLabel header;
    private JButton ok;
    private JTextComponent theText;
    private JPanel buttonsPanel;
    private TextInfoPanel textPanel;
    private TextAttributesPanel attrPanel;
    private JCheckBox multiLine;

    public static void showDialog() {
        if (theDialog == null) {
            if (TopLevel.isMDIMode()) {
                TopLevel jf = TopLevel.getCurrentJFrame();
                theDialog = new GetInfoText((Frame)jf, false);
            } else {
                theDialog = new GetInfoText(null, false);
            }
        }
        theDialog.loadTextInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadTextInfo();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadTextInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        if (this.cti != null) {
            Iterator it = batch.getChanges();
            while (it.hasNext()) {
                Undo.Change change = (Undo.Change)it.next();
                ElectricObject obj = change.getObject();
                if (obj != this.cti.owner) continue;
                reload = true;
                break;
            }
        }
        if (reload) {
            this.loadTextInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    public boolean isGUIListener() {
        return true;
    }

    private void loadTextInfo() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        Highlight textHighlight = null;
        int textCount = 0;
        if (this.wnd != null) {
            Iterator it = this.wnd.getHighlighter().getHighlights().iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.TEXT || h.getVar() == null && h.getElectricObject() instanceof Export) continue;
                textHighlight = h;
                ++textCount;
            }
        }
        if (textCount > 1) {
            textHighlight = null;
        }
        boolean enabled = textHighlight != null;
        this.focusClearOnTextField(this.theText);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
        if (!enabled) {
            this.header.setText("No Text Selected");
            this.evaluation.setText(" ");
            this.theText.setText("");
            this.theText.setEnabled(false);
            this.cti = null;
            this.textPanel.setTextDescriptor(null, null, null);
            this.attrPanel.setVariable(null, null, null, null);
            this.ok.setEnabled(false);
            this.apply.setEnabled(false);
            this.multiLine.setEnabled(false);
            return;
        }
        this.cti = new CachedTextInfo(textHighlight);
        this.ok.setEnabled(true);
        this.apply.setEnabled(true);
        this.header.setText(this.cti.description);
        this.theText.setText(this.cti.initialText);
        this.theText.setEditable(true);
        if (this.cti.initialText.indexOf(10) != -1) {
            if (this.cti.var == null && this.cti.shownText != null && this.cti.shownText.getName() != null) {
                this.multiLine.setEnabled(false);
                this.multiLine.setSelected(false);
            } else {
                this.multiLine.setEnabled(true);
                this.multiLine.setSelected(true);
            }
        } else {
            if (this.cti.var == null && this.cti.shownText != null && this.cti.shownText.getName() != null) {
                this.multiLine.setEnabled(false);
            } else {
                this.multiLine.setEnabled(true);
            }
            this.multiLine.setSelected(false);
        }
        this.evaluation.setText(" ");
        if (this.cti.var != null && this.cti.var.isCode()) {
            this.evaluation.setText("Evaluation: " + this.cti.var.describe(-1));
        }
        boolean cellInstanceName = false;
        if (this.cti.var == null && this.cti.shownText.getName() == null && this.cti.owner instanceof NodeInst) {
            cellInstanceName = true;
        }
        this.textPanel.setTextDescriptor(this.cti.td, null, this.cti.owner);
        this.attrPanel.setVariable(this.cti.var, cellInstanceName ? null : this.cti.td, null, this.cti.owner);
        this.changeTextComponent(this.cti.initialText, this.multiLine.isSelected());
        this.focusOnTextField(this.theText);
        if (cellInstanceName) {
            this.theText.setEditable(false);
            this.theText.setEnabled(false);
            this.multiLine.setEnabled(false);
        }
    }

    private GetInfoText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.setLocation(100, 50);
        Undo.addDatabaseChangeListener(this);
        this.loadTextInfo();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    public static void editTextInPlace() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            return;
        }
        Highlight theHigh = null;
        int textCount = 0;
        Iterator it = curWnd.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.TEXT) continue;
            theHigh = h;
            ++textCount;
        }
        if (textCount > 1) {
            theHigh = null;
        }
        if (theHigh == null) {
            return;
        }
        CachedTextInfo cti = new CachedTextInfo(theHigh);
        if (cti.isInstanceName()) {
            GetInfoText.showDialog();
            return;
        }
        Font theFont = curWnd.getFont(cti.td);
        if (theFont == null) {
            GetInfoText.showDialog();
            return;
        }
        Point2D[] points = Highlighter.describeHighlightText(curWnd, cti.owner, cti.var, cti.shownText.getName());
        int lowX = 0;
        int highX = 0;
        int lowY = 0;
        int highY = 0;
        for (int i = 0; i < points.length; ++i) {
            Point pt = curWnd.databaseToScreen(points[i]);
            if (i == 0) {
                lowX = highX = pt.x;
                lowY = highY = pt.y;
                continue;
            }
            if (pt.x < lowX) {
                lowX = pt.x;
            }
            if (pt.x > highX) {
                highX = pt.x;
            }
            if (pt.y < lowY) {
                lowY = pt.y;
            }
            if (pt.y <= highY) continue;
            highY = pt.y;
        }
        if (cti.td.getDispPart() != TextDescriptor.DispPos.VALUE && (cti.var == null || cti.var.getLength() == 1)) {
            GlyphVector gv = curWnd.getGlyphs(cti.initialText, theFont);
            Rectangle2D glyphBounds = gv.getVisualBounds();
            lowX = highX - (int)glyphBounds.getWidth();
        }
        EditInPlaceListener eip = new EditInPlaceListener(cti, curWnd, theFont, lowX, lowY);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.header = new JLabel();
        this.apply = new JButton();
        this.evaluation = new JLabel();
        this.theText = new JTextField();
        this.textPanel = new TextInfoPanel();
        this.attrPanel = new TextAttributesPanel();
        this.buttonsPanel = new JPanel();
        this.multiLine = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.ok);
        this.setTitle("Text Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoText.this.closeDialog(evt);
            }
        });
        this.header.setText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.header, gridBagConstraints);
        this.changeTextComponent("", false);
        this.multiLine.setText("Multi-Line Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.multiLine, gridBagConstraints);
        this.multiLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GetInfoText.this.multiLineStateChanged();
            }
        });
        this.evaluation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.evaluation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.attrPanel, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void multiLineStateChanged() {
        this.changeTextComponent(this.theText.getText(), this.multiLine.isSelected());
    }

    private void changeTextComponent(String currentText, boolean multipleLines) {
        if (this.cti == null || this.cti.shownText == null) {
            return;
        }
        this.getContentPane().remove(this.theText);
        if (currentText == null) {
            currentText = "";
        }
        if (multipleLines) {
            int size;
            this.theText = new JTextArea();
            String[] text = currentText.split("\\n");
            if (text.length > (size = 1)) {
                size = text.length;
            }
            ((JTextArea)this.theText).setRows(size);
            ((JTextArea)this.theText).setBorder(BorderFactory.createBevelBorder(1));
            this.theText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    JTextArea area = (JTextArea)GetInfoText.this.theText;
                    area.setRows(area.getLineCount());
                    GetInfoText.this.pack();
                }
            });
        } else {
            this.theText = new JTextField();
            JTextField field = (JTextField)this.theText;
            if (currentText.matches(".*?\\n.*")) {
                currentText = currentText.substring(0, currentText.indexOf(10));
            }
        }
        this.theText.setText(currentText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.theText, gridBagConstraints);
        this.pack();
        this.theText.requestFocus();
    }

    private String getDelimtedText(JTextComponent c) {
        String currentText = c.getText();
        if (c instanceof JTextArea) {
            JTextArea area = (JTextArea)c;
            StringBuffer text = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < area.getLineCount(); ++i) {
                try {
                    if (!first) {
                        text.append("\n");
                    }
                    int startPos = area.getLineStartOffset(i);
                    int endPos = area.getLineEndOffset(i);
                    text.append(currentText.substring(startPos, endPos));
                    System.out.println("Line " + i + " is: " + currentText.substring(startPos, endPos));
                    first = false;
                    continue;
                }
                catch (BadLocationException e) {
                    ActivityLogger.logException(e);
                }
            }
            currentText = text.toString();
        }
        return currentText;
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (this.cti.shownText == null) {
            return;
        }
        this.textPanel.applyChanges();
        this.attrPanel.applyChanges();
        boolean changed = false;
        String currentText = this.theText.getText();
        if (!currentText.equals(this.cti.initialText)) {
            changed = true;
        }
        if (changed) {
            String str;
            int i;
            String[] textArray = currentText.split("\\n");
            ArrayList<String> textList = new ArrayList<String>();
            for (i = 0; i < textArray.length; ++i) {
                str = textArray[i];
                if ((str = str.trim()).equals("")) continue;
                textList.add(str);
            }
            textArray = new String[textList.size()];
            for (i = 0; i < textList.size(); ++i) {
                textArray[i] = str = (String)textList.get(i);
            }
            if (textArray.length > 0) {
                ChangeText job = new ChangeText(this.cti, textArray);
                this.cti.initialText = currentText;
            }
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    protected static class ChangeText
    extends Job {
        CachedTextInfo cti;
        String[] newText;

        protected ChangeText(CachedTextInfo cti, String[] newText) {
            super("Modify Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cti = cti;
            this.newText = newText;
            this.startJob();
        }

        public boolean doIt() {
            if (this.cti.var != null) {
                Variable newVar = null;
                newVar = this.newText.length > 1 ? this.cti.owner.updateVar(this.cti.var.getKey(), (Object)this.newText) : this.cti.owner.updateVar(this.cti.var.getKey(), (Object)this.newText[0]);
                if (newVar != null) {
                    this.cti.shownText.setVar(newVar);
                }
            } else if (this.cti.shownText.getName() != null) {
                if (this.cti.owner != null) {
                    ((Geometric)this.cti.owner).setName(this.newText[0]);
                }
            } else if (this.cti.owner instanceof Export) {
                Export pp = (Export)this.cti.owner;
                pp.rename(this.newText[0]);
            }
            return true;
        }
    }

    public static class EditInPlaceListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private CachedTextInfo cti;
        private EditWindow wnd;
        private EventListener oldListener;
        private JTextComponent tc;
        private MenuBar mb;

        public EditInPlaceListener(CachedTextInfo cti, EditWindow wnd, Font theFont, int lowX, int lowY) {
            this.cti = cti;
            this.wnd = wnd;
            if (cti.isMultiLineCapable() || cti.var != null && cti.var.getLength() > 1) {
                EIPEditorPane ep = new EIPEditorPane(cti.initialText);
                this.tc = ep;
            } else {
                EIPTextField tf = new EIPTextField(cti.initialText);
                tf.addActionListener(new ActionListener(this){
                    private final /* synthetic */ EditInPlaceListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        EditInPlaceListener.access$600(this.this$0);
                    }
                });
                this.tc = tf;
            }
            this.tc.addKeyListener(this);
            this.tc.setSize(this.figureSize());
            this.tc.setLocation(lowX, lowY);
            this.tc.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (theFont != null) {
                this.tc.setFont(theFont);
            }
            this.tc.selectAll();
            wnd.add(this.tc);
            this.tc.setVisible(true);
            this.tc.repaint();
            this.oldListener = WindowFrame.getListener();
            WindowFrame.setListener(this);
            TopLevel top = TopLevel.getCurrentJFrame();
            this.mb = top.getTheMenuBar();
            this.mb.setIgnoreTextEditKeys(true);
        }

        private Dimension figureSize() {
            Font theFont = this.wnd.getFont(this.cti.td);
            double size = EditWindow.getDefaultFontSize();
            if (this.cti.td != null) {
                size = this.cti.td.getTrueSize(this.wnd);
            }
            if (size <= 0.0) {
                size = 1.0;
            }
            size = theFont.getSize();
            String[] textArray = this.tc.getText().split("\\n");
            double totalHeight = 0.0;
            double totalWidth = 0.0;
            for (int i = 0; i < textArray.length; ++i) {
                String str = textArray[i];
                GlyphVector gv = this.wnd.getGlyphs(str, theFont);
                Rectangle2D glyphBounds = gv.getVisualBounds();
                totalHeight += size;
                if (!(glyphBounds.getWidth() > totalWidth)) continue;
                totalWidth = glyphBounds.getWidth();
            }
            if (textArray.length > 1) {
                totalHeight *= 2.0;
            }
            return new Dimension((int)totalWidth + 5, (int)totalHeight + 5);
        }

        private void closeEditInPlace() {
            WindowFrame.setListener(this.oldListener);
            this.wnd.remove(this.tc);
            this.wnd.repaint();
            this.mb.setIgnoreTextEditKeys(false);
            String currentText = this.tc.getText();
            if (!currentText.equals(this.cti.initialText)) {
                String str;
                int i;
                String[] textArray = currentText.split("\\n");
                ArrayList<String> textList = new ArrayList<String>();
                for (i = 0; i < textArray.length; ++i) {
                    str = textArray[i];
                    if ((str = str.trim()).equals("")) continue;
                    textList.add(str);
                }
                textArray = new String[textList.size()];
                for (i = 0; i < textList.size(); ++i) {
                    textArray[i] = str = (String)textList.get(i);
                }
                if (textArray.length > 0) {
                    ChangeText job = new ChangeText(this.cti, textArray);
                }
            }
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            this.closeEditInPlace();
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyReleased(KeyEvent evt) {
            this.tc.setSize(this.figureSize());
        }

        public void keyTyped(KeyEvent evt) {
        }

        static /* synthetic */ void access$600(EditInPlaceListener x0) {
            x0.closeEditInPlace();
        }
    }

    private static class EIPEditorPane
    extends JEditorPane {
        EIPEditorPane(String text) {
            super("text/plain", text);
        }

        public void paint(Graphics g) {
            this.requestFocus();
            super.paint(g);
        }
    }

    private static class EIPTextField
    extends JTextField {
        EIPTextField(String text) {
            super(text);
        }

        public void paint(Graphics g) {
            this.requestFocus();
            super.paint(g);
        }
    }

    private static class CachedTextInfo {
        private Highlight shownText;
        private String initialText;
        private Variable var;
        private TextDescriptor td;
        private ElectricObject owner;
        private String description;
        private boolean instanceName;
        private boolean multiLineCapable;

        CachedTextInfo(Highlight h) {
            this.shownText = h;
            this.description = "Unknown text";
            this.initialText = "";
            this.td = null;
            this.owner = this.shownText.getElectricObject();
            this.multiLineCapable = false;
            this.instanceName = false;
            NodeInst ni = null;
            if (this.owner instanceof NodeInst) {
                ni = (NodeInst)this.owner;
            }
            this.var = this.shownText.getVar();
            if (this.var != null) {
                if (ni != null && ni.isInvisiblePinWithText() && this.var.getKey() == Artwork.ART_MESSAGE) {
                    this.multiLineCapable = true;
                }
                this.td = this.var.getTextDescriptor();
                Object obj = this.var.getObject();
                if (obj instanceof Object[]) {
                    Object[] theArray = (Object[])obj;
                    this.initialText = "";
                    for (int i = 0; i < theArray.length; ++i) {
                        if (i != 0) {
                            this.initialText = this.initialText + "\n";
                        }
                        this.initialText = this.initialText + theArray[i];
                    }
                } else {
                    this.initialText = this.var.getPureValue(-1);
                }
                this.description = this.var.getFullDescription(this.owner);
            } else if (this.shownText.getName() != null) {
                if (this.owner instanceof Geometric) {
                    Geometric geom = (Geometric)this.owner;
                    this.td = geom.getNameTextDescriptor();
                    this.description = geom instanceof NodeInst ? "Name of node " + ((NodeInst)geom).getProto().describe() : "Name of arc " + ((ArcInst)geom).getProto().describe();
                    this.initialText = geom.getName();
                }
            } else if (this.owner instanceof NodeInst) {
                this.description = "Name of cell instance " + ni.describe();
                this.td = ni.getProtoTextDescriptor();
                this.initialText = ni.getProto().describe();
                this.instanceName = true;
            } else if (this.owner instanceof Export) {
                Export pp = (Export)this.owner;
                this.description = "Name of export " + pp.getName();
                this.td = pp.getTextDescriptor();
                this.initialText = pp.getName();
            }
        }

        public boolean isInstanceName() {
            return this.instanceName;
        }

        public boolean isMultiLineCapable() {
            return this.multiLineCapable;
        }
    }
}

