/*
 * Electric(tm) VLSI Design System
 *
 * File: aidtable.c
 * Aid dispatch table
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */
#include "global.h"

/*
 * sample routines and their arguments:
 *
 * aa_init(INTBIG *argc, char *argv[], AIDENTRY *aid) {}
 * INTSML aa_set(INTSML count, char *par[]) {}
 * INTBIG aa_request(char *command,...) {}
 * aa_examinenodeproto(NODEPROTO *np) {}
 * aa_slice() {}
 * aa_done() {}
 * aa_startbatch(INTSML source, INTSML undoredo) {}
 * aa_endbatch() {}
 * aa_startobjectchange(INTBIG addr, INTBIG type) {}
 * aa_endobjectchange(INTBIG addr, INTBIG type) {}
 * aa_modifynodeinst(NODEINST *ni, INTBIG olx, INTBIG oly, INTBIG ohx, INTBIG ohy,
 *    INTSML orot, INTSML otran) {}
 * aa_modifyarcinst(ARCINST *ai, INTBIG oxA, INTBIG oyA, INTBIG oxB, INTBIG oyB,
 *    INTBIG owid, INTBIG olen) {}
 * aa_modifyportproto(PORTPROTO *pp) {}
 * aa_modifynodeproto(NODEPROTO *np) {}
 * aa_modifydescript(INTBIG addr, INTBIG type, VARIABLE *var, INTBIG old) {}
 * aa_newobject(INTBIG addr, INTBIG type) {}
 * aa_killobject(INTBIG addr, INTBIG type) {}
 * aa_newvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG newtype) {}
 * aa_killvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG oldaddr,
 *    INTBIG oldtype, INTBIG olddescript) {}
 * aa_modifyvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype,
 *    INTBIG aindex, INTBIG oldvalue) {}
 * aa_insertvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype, INTBIG aindex) {}
 * aa_deletevariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype, INTBIG aindex,
 *    INTBIG ovalue) {}
 * aa_readlibrary(LIBRARY *lib) {}
 * aa_eraselibrary(LIBRARY *lib) {}
 * aa_writelibrary(LIBRARY *lib, INTSML pass) {}
 */

/*
 * first come the interactive tools:
 *    us     user interface aid
 *    io     input/output in many forms
 * now come the synthesis tools:
 *    com    compaction
 *    pla    PLA generator
 *    ro     wire router (stitching and river-routing only)
 *    sc     Quisc silicon compiler (Queen's University)
 *    map    FPGA mapper
 *    vhdl   VHDL compiler (Queen's University)
 *    compen compensation
 *    le     logical effort analyzer/sizer
 * now the aids preceeded by the network tool:
 *    net    network maintenance and comparison
 *    dr     incremental design rule checking
 *    erc    electrical rule checking
 *    sim    simulation (esim,rsim,rnl,mossim,spice,als,verilog,silos,etc.)
 *    proj   project management (should be last)
 * the rest is dreaming:
 *    rat    ratio check
 *    pow    power estimation
 *    vec    test vector generation
 *    nov    novice user help
 *    fra    fracturing for fabrication
 *    sea    function search
 *    tv     timing verification
 *    pr     placement and routing for TTL
 *    ga     gate array layout
 *    pad    pad frame support
 *    flr    floor planning
 */

#if COMAID
# include "compact.h"
  extern COMCOMP com_compactp;
#endif

#if COMPENAID
# include "compensate.h"
  extern COMCOMP compen_compensatep;
#endif

#if DRCAID
# include "drc.h"
  extern COMCOMP dr_drcp;
#endif

#if ERCAID
# include "erc.h"
  extern COMCOMP erc_tablep;
#endif

# include "eio.h"
extern COMCOMP io_iop;

#if LOGEFFAID
# include "logeffort.h"
  extern COMCOMP le_tablep;
#endif

#if MAPPERAID
# include "mapper.h"
  extern COMCOMP map_mapperp;
#endif

#include "network.h"
extern COMCOMP net_networkp;

#if PLAAID
# include "pla.h"
  extern COMCOMP pla_plap;
#endif

#if PROJECTAID
# include "projecttool.h"
  extern COMCOMP proj_projp;
#endif

#if ROUTAID
# include "rout.h"
  extern COMCOMP ro_routerp;
#endif

#if SCAID
# include "sc1.h"
  extern COMCOMP sc_silcomp;
#endif

#if SIMAID
# include "sim.h"
  extern COMCOMP sim_simulatorp;
#endif

# include "usr.h"
extern COMCOMP us_userp;

#if VHDLAID
# include "vhdl.h"
  extern COMCOMP vhdl_comp;
#endif

AIDENTRY el_aids[] =
{
	/********** the interactive tools **********/

	/* user interface */
	{"user", AIDON | AIDINCREMENTAL | USEDIALOGS, 0, &us_userp, NOCLUSTER,
	us_init,               us_done,              us_set,				/* init/done/set */
	us_request,            us_examinenodeproto,  us_slice,				/* request/examine/slice */
	us_startbatch,         us_endbatch,									/* startbatch/endbatch */
	us_startobjectchange,  us_endobjectchange,							/* startobject/endobject */
	us_modifynodeinst,     0,                    0,						/* modnode/modarc/modport */
	us_modifynodeproto,    0,											/* modnodeproto/moddescript */
	us_newobject,          us_killobject,								/* newobject/killobject */
	us_newvariable,        us_killvariable,								/* newvariable/killvariable */
	us_modifyvariable,     0,                    0,						/* modvar/insvar/delvar */
	us_readlibrary,        us_eraselibrary,      us_writelibrary,		/* readlib/eraselib/writelib */
	NOVARIABLE, 0},

	/* I/O module */
	{"io", 0, 0, &io_iop, NOCLUSTER,
	io_init,               io_done,              io_set,				/* init/done/set */
	io_request,            0,                    io_slice,				/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},

#if COMAID
	/* compaction module */
	{"compaction", AIDSYNTHESIS,              0, &com_compactp, NOCLUSTER,
	com_init,              com_done,             com_set,				/* init/done/set */
	0,                     0,                    com_slice,				/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if PLAAID
	/* PLA generation module */
	{"pla", AIDSYNTHESIS,                     0, &pla_plap, NOCLUSTER,
	pla_init,              pla_done,             pla_set,				/* init/done/set */
	0,                     0,                    pla_slice,				/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if ROUTAID
	/* wire routing module */
	{"routing", AIDINCREMENTAL | AIDSYNTHESIS, 0, &ro_routerp, NOCLUSTER,
	ro_init,               ro_done,              ro_set,				/* init/done/set */
	0,                     0,                    ro_slice,				/* request/examine/slice */
	ro_startbatch,         0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	ro_modifynodeinst,     ro_modifyarcinst,     ro_modifyportproto,	/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	ro_newobject,          ro_killobject,								/* newobject/killobject */
	ro_newvariable,        0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if SCAID
	/* Quisc "Silicon" Compiler module */
	{"silicon-compiler", AIDSYNTHESIS,	0,	&sc_silcomp,	NOCLUSTER,
	sc_init,               sc_done,              sc_set,				/* init/done/set */
	0,                     0,                    sc_slice,				/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if MAPPERAID
	/* mapper module */
	{"mapper", AIDSYNTHESIS,	0,	&map_mapperp,	NOCLUSTER,
	map_init,              map_done,             map_set,				/* init/done/set */
	map_request,           map_examinenodeproto, map_slice,				/* request/examine/slice */
	map_startbatch,        map_endbatch,								/* startbatch/endbatch */
	map_startobjectchange, map_endobjectchange,							/* startobject/endobject */
	map_modifynodeinst,    map_modifyarcinst,    map_modifyportproto,	/* modnode/modarc/modport */
	map_modifynodeproto,   map_modifydescript,							/* modnodeproto/moddescript */
	map_newobject,         map_killobject,								/* newobject/killobject */
	map_newvariable,       map_killvariable,							/* newvariable/killvariable */
	map_modifyvariable,    map_insertvariable,   map_deletevariable,	/* modvar/insvar/delvar */
	map_readlibrary,       map_eraselibrary,     map_writelibrary,		/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if VHDLAID
	/* VHDL compiler module */
	{"vhdl-compiler", AIDSYNTHESIS,	0,	&vhdl_comp,	NOCLUSTER,
	vhdl_init,             vhdl_done,            vhdl_set,				/* init/done/set */
	vhdl_request,          0,                    vhdl_slice,			/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if COMPENAID
	/* compensation module */
	{"compensation", AIDSYNTHESIS,	0,	&compen_compensatep,	NOCLUSTER,
	compen_init,           compen_done,          compen_set,			/* init/done/set */
	0,                     0,                    compen_slice,			/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	compen_modifynodeinst, 0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     compen_killobject,							/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if LOGEFFAID
	/* logical effort module */
	{"logeffort", AIDSYNTHESIS,	0,	&le_tablep,	NOCLUSTER,
	le_init,               le_done,              le_set,				/* init/done/set */
	0,                     0,                    0,						/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

	/* network maintenance and comparison */
	{"network", AIDON | AIDINCREMENTAL, 0, &net_networkp, NOCLUSTER,
	net_init,              net_done,             net_set,				/* init/done/set */
	net_request,           net_examinenodeproto, 0,						/* request/examine/slice */
	net_startbatch,        net_endbatch,								/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    net_modifyportproto,	/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	net_newobject,         net_killobject,								/* newobject/killobject */
	net_newvariable,       net_killvariable,							/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	net_readlibrary,       0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},

#if DRCAID
	/* design-rule checker */
	{"drc", AIDON | AIDINCREMENTAL | AIDANALYSIS, 0, &dr_drcp, NOCLUSTER,
	dr_init,               dr_done,              dr_set,				/* init/done/set */
	0,                     dr_examinenodeproto,  dr_slice,				/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	dr_modifynodeinst,     dr_modifyarcinst,     0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	dr_newobject,          dr_killobject,								/* newobject/killobject */
	dr_newvariable,        0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	dr_readlibrary,        dr_eraselibrary,      0,						/* readlib/eraselib/writelib */
	NOVARIABLE,0},
#endif

#if ERCAID
	/* electrical-rule checker */
	{"erc", AIDANALYSIS, 0, &erc_tablep, NOCLUSTER,
	erc_init,              erc_done,             erc_set,				/* init/done/set */
	0,                     0,                    0,						/* request/examine/slice */
	0,                     0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	0,                     0,                    0,						/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	0,                     0,											/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE,0},
#endif

#if SIMAID
	/* simulation module */
	{"simulation", AIDANALYSIS, 0, &sim_simulatorp, NOCLUSTER,
	sim_init,              sim_done,             sim_set,				/* init/done/set */
	0,                     0,                    sim_slice,				/* request/examine/slice */
	sim_startbatch,        0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	sim_modifynodeinst,    sim_modifyarcinst,    sim_modifyportproto,	/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	sim_newobject,         sim_killobject,								/* newobject/killobject */
	sim_newvariable,       sim_killvariable,							/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	0,                     0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

#if PROJECTAID
	/* project management module */
	{"project", AIDON | AIDINCREMENTAL, 0, &proj_projp, NOCLUSTER,
	proj_init,             proj_done,            proj_set,				/* init/done/set */
	0,                     0,                    proj_slice,			/* request/examine/slice */
	proj_startbatch,       0,											/* startbatch/endbatch */
	0,                     0,											/* startobject/endobject */
	proj_modifynodeinst,   proj_modifyarcinst,   proj_modifyportproto,	/* modnode/modarc/modport */
	0,                     0,											/* modnodeproto/moddescript */
	proj_newobject,        proj_killobject,								/* newobject/killobject */
	0,                     0,											/* newvariable/killvariable */
	0,                     0,                    0,						/* modvar/insvar/delvar */
	proj_readlibrary,      0,                    0,						/* readlib/eraselib/writelib */
	NOVARIABLE, 0},
#endif

	/* termination */
	{NULL, 0, 0, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, 0}
};
