;;;;;;;;; ANS-7: Abstract Notation System based on a Base7 nummeric system
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; It makes it easy to calculate with notation while keeping in mind that there are basic note ("The White Keys") as well as sharp or flat notes and finally enharmonic notes (gisis) 
; Each note is represented by a number which points to an absolute notename in lilypond syntax.
; This is especially desinged to make diatonic shifting, real transpostion and other modifications more easy for script-authors.
; System by Nils Gey 2010 (thanks to Till Hartmann for table generation)

; +1 is for microtones, needs to be defined if needed.
; +10 is flat/sharp switching
; +100 is one diatonic step and preserves the accidental
; +100 and rounding the last two digits to 0 reverts to the basic "white key"
; +1000 is one octave

;000-600   c,,, 		; humans cannot hear this c
;1000-1600  c,,
;2000-2600  c,
;3000-3600  c
;4000-4600  c'  	; "Middle"-C
;5000-5600 c'' 
;6000-6600  c''' 	; Soprano high C
;10000-10600 c''''
;11000-10600 c''''' ; goes beyond the range of a modern piano


(define ANS-7::Base7NoteTable (make-hash-table 330))

(let createANS-7::Base7NoteTable ()

(hashq-set! ANS-7::Base7NoteTable '000 "c,,,")
        (hashq-set! ANS-7::Base7NoteTable '010 "ceses,,,")
        (hashq-set! ANS-7::Base7NoteTable '020 "ces,,,")
        (hashq-set! ANS-7::Base7NoteTable '030 "cis,,,")
        (hashq-set! ANS-7::Base7NoteTable '040 "cisis,,,")
(hashq-set! ANS-7::Base7NoteTable '100 "d,,,")
        (hashq-set! ANS-7::Base7NoteTable '110 "deses,,,")
        (hashq-set! ANS-7::Base7NoteTable '120 "des,,,")
        (hashq-set! ANS-7::Base7NoteTable '130 "dis,,,")
        (hashq-set! ANS-7::Base7NoteTable '140 "disis,,,")
(hashq-set! ANS-7::Base7NoteTable '200 "e,,,")
        (hashq-set! ANS-7::Base7NoteTable '210 "eeses,,,")
        (hashq-set! ANS-7::Base7NoteTable '220 "ees,,,")
        (hashq-set! ANS-7::Base7NoteTable '230 "eis,,,")
        (hashq-set! ANS-7::Base7NoteTable '240 "eisis,,,")
(hashq-set! ANS-7::Base7NoteTable '300 "f,,,")
        (hashq-set! ANS-7::Base7NoteTable '310 "feses,,,")
        (hashq-set! ANS-7::Base7NoteTable '320 "fes,,,")
        (hashq-set! ANS-7::Base7NoteTable '330 "fis,,,")
        (hashq-set! ANS-7::Base7NoteTable '340 "fisis,,,")
(hashq-set! ANS-7::Base7NoteTable '400 "g,,,")
        (hashq-set! ANS-7::Base7NoteTable '410 "geses,,,")
        (hashq-set! ANS-7::Base7NoteTable '420 "ges,,,")
        (hashq-set! ANS-7::Base7NoteTable '430 "gis,,,")
        (hashq-set! ANS-7::Base7NoteTable '440 "gisis,,,")
(hashq-set! ANS-7::Base7NoteTable '500 "a,,,")
        (hashq-set! ANS-7::Base7NoteTable '510 "aeses,,,")
        (hashq-set! ANS-7::Base7NoteTable '520 "aes,,,")
        (hashq-set! ANS-7::Base7NoteTable '530 "ais,,,")
        (hashq-set! ANS-7::Base7NoteTable '540 "aisis,,,")
(hashq-set! ANS-7::Base7NoteTable '600 "b,,,")
        (hashq-set! ANS-7::Base7NoteTable '610 "beses,,,")
        (hashq-set! ANS-7::Base7NoteTable '620 "bes,,,")
        (hashq-set! ANS-7::Base7NoteTable '630 "bis,,,")
        (hashq-set! ANS-7::Base7NoteTable '640 "bisis,,,")
(hashq-set! ANS-7::Base7NoteTable '1000 "c,,")
        (hashq-set! ANS-7::Base7NoteTable '1010 "ceses,,")
        (hashq-set! ANS-7::Base7NoteTable '1020 "ces,,")
        (hashq-set! ANS-7::Base7NoteTable '1030 "cis,,")
        (hashq-set! ANS-7::Base7NoteTable '1040 "cisis,,")
(hashq-set! ANS-7::Base7NoteTable '1100 "d,,")
        (hashq-set! ANS-7::Base7NoteTable '1110 "deses,,")
        (hashq-set! ANS-7::Base7NoteTable '1120 "des,,")
        (hashq-set! ANS-7::Base7NoteTable '1130 "dis,,")
        (hashq-set! ANS-7::Base7NoteTable '1140 "disis,,")
(hashq-set! ANS-7::Base7NoteTable '1200 "e,,")
        (hashq-set! ANS-7::Base7NoteTable '1210 "eeses,,")
        (hashq-set! ANS-7::Base7NoteTable '1220 "ees,,")
        (hashq-set! ANS-7::Base7NoteTable '1230 "eis,,")
        (hashq-set! ANS-7::Base7NoteTable '1240 "eisis,,")
(hashq-set! ANS-7::Base7NoteTable '1300 "f,,")
        (hashq-set! ANS-7::Base7NoteTable '1310 "feses,,")
        (hashq-set! ANS-7::Base7NoteTable '1320 "fes,,")
        (hashq-set! ANS-7::Base7NoteTable '1330 "fis,,")
        (hashq-set! ANS-7::Base7NoteTable '1340 "fisis,,")
(hashq-set! ANS-7::Base7NoteTable '1400 "g,,")
        (hashq-set! ANS-7::Base7NoteTable '1410 "geses,,")
        (hashq-set! ANS-7::Base7NoteTable '1420 "ges,,")
        (hashq-set! ANS-7::Base7NoteTable '1430 "gis,,")
        (hashq-set! ANS-7::Base7NoteTable '1440 "gisis,,")
(hashq-set! ANS-7::Base7NoteTable '1500 "a,,")
        (hashq-set! ANS-7::Base7NoteTable '1510 "aeses,,")
        (hashq-set! ANS-7::Base7NoteTable '1520 "aes,,")
        (hashq-set! ANS-7::Base7NoteTable '1530 "ais,,")
        (hashq-set! ANS-7::Base7NoteTable '1540 "aisis,,")
(hashq-set! ANS-7::Base7NoteTable '1600 "b,,")
        (hashq-set! ANS-7::Base7NoteTable '1610 "beses,,")
        (hashq-set! ANS-7::Base7NoteTable '1620 "bes,,")
        (hashq-set! ANS-7::Base7NoteTable '1630 "bis,,")
        (hashq-set! ANS-7::Base7NoteTable '1640 "bisis,,")
(hashq-set! ANS-7::Base7NoteTable '2000 "c,")
        (hashq-set! ANS-7::Base7NoteTable '2010 "ceses,")
        (hashq-set! ANS-7::Base7NoteTable '2020 "ces,")
        (hashq-set! ANS-7::Base7NoteTable '2030 "cis,")
        (hashq-set! ANS-7::Base7NoteTable '2040 "cisis,")
(hashq-set! ANS-7::Base7NoteTable '2100 "d,")
        (hashq-set! ANS-7::Base7NoteTable '2110 "deses,")
        (hashq-set! ANS-7::Base7NoteTable '2120 "des,")
        (hashq-set! ANS-7::Base7NoteTable '2130 "dis,")
        (hashq-set! ANS-7::Base7NoteTable '2140 "disis,")
(hashq-set! ANS-7::Base7NoteTable '2200 "e,")
        (hashq-set! ANS-7::Base7NoteTable '2210 "eeses,")
        (hashq-set! ANS-7::Base7NoteTable '2220 "ees,")
        (hashq-set! ANS-7::Base7NoteTable '2230 "eis,")
        (hashq-set! ANS-7::Base7NoteTable '2240 "eisis,")
(hashq-set! ANS-7::Base7NoteTable '2300 "f,")
        (hashq-set! ANS-7::Base7NoteTable '2310 "feses,")
        (hashq-set! ANS-7::Base7NoteTable '2320 "fes,")
        (hashq-set! ANS-7::Base7NoteTable '2330 "fis,")
        (hashq-set! ANS-7::Base7NoteTable '2340 "fisis,")
(hashq-set! ANS-7::Base7NoteTable '2400 "g,")
        (hashq-set! ANS-7::Base7NoteTable '2410 "geses,")
        (hashq-set! ANS-7::Base7NoteTable '2420 "ges,")
        (hashq-set! ANS-7::Base7NoteTable '2430 "gis,")
        (hashq-set! ANS-7::Base7NoteTable '2440 "gisis,")
(hashq-set! ANS-7::Base7NoteTable '2500 "a,")
        (hashq-set! ANS-7::Base7NoteTable '2510 "aeses,")
        (hashq-set! ANS-7::Base7NoteTable '2520 "aes,")
        (hashq-set! ANS-7::Base7NoteTable '2530 "ais,")
        (hashq-set! ANS-7::Base7NoteTable '2540 "aisis,")
(hashq-set! ANS-7::Base7NoteTable '2600 "b,")
        (hashq-set! ANS-7::Base7NoteTable '2Base7NoteTable610 "beses,")
        (hashq-set! ANS-7::Base7NoteTable '2620 "bes,")
        (hashq-set! ANS-7::Base7NoteTable '2630 "bis,")
        (hashq-set! ANS-7::Base7NoteTable '2640 "bisis,")
(hashq-set! ANS-7::Base7NoteTable '3000 "c")
        (hashq-set! ANS-7::Base7NoteTable '3010 "ceses")
        (hashq-set! ANS-7::Base7NoteTable '3020 "ces")
        (hashq-set! ANS-7::Base7NoteTable '3030 "cis")
        (hashq-set! ANS-7::Base7NoteTable '3040 "cisis")
(hashq-set! ANS-7::Base7NoteTable '3100 "d")
        (hashq-set! ANS-7::Base7NoteTable '3110 "deses")
        (hashq-set! ANS-7::Base7NoteTable '3120 "des")
        (hashq-set! ANS-7::Base7NoteTable '3130 "dis")
        (hashq-set! ANS-7::Base7NoteTable '3140 "disis")
(hashq-set! ANS-7::Base7NoteTable '3200 "e")
        (hashq-set! ANS-7::Base7NoteTable '3210 "eeses")
        (hashq-set! ANS-7::Base7NoteTable '3220 "ees")
        (hashq-set! ANS-7::Base7NoteTable '3230 "eis")
        (hashq-set! ANS-7::Base7NoteTable '3240 "eisis")
(hashq-set! ANS-7::Base7NoteTable '3300 "f")
        (hashq-set! ANS-7::Base7NoteTable '3310 "feses")
        (hashq-set! ANS-7::Base7NoteTable '3320 "fes")
        (hashq-set! ANS-7::Base7NoteTable '3330 "fis")
        (hashq-set! ANS-7::Base7NoteTable '3340 "fisis")
(hashq-set! ANS-7::Base7NoteTable '3400 "g")
        (hashq-set! ANS-7::Base7NoteTable '3410 "geses")
        (hashq-set! ANS-7::Base7NoteTable '3420 "ges")
        (hashq-set! ANS-7::Base7NoteTable '3430 "gis")
        (hashq-set! ANS-7::Base7NoteTable '3440 "gisis")
(hashq-set! ANS-7::Base7NoteTable '3500 "a")
        (hashq-set! ANS-7::Base7NoteTable '3510 "aeses")
        (hashq-set! ANS-7::Base7NoteTable '3520 "aes")
        (hashq-set! ANS-7::Base7NoteTable '3530 "ais")
        (hashq-set! ANS-7::Base7NoteTable '3540 "aisis")
(hashq-set! ANS-7::Base7NoteTable '3600 "b")
        (hashq-set! ANS-7::Base7NoteTable '3610 "beses")
        (hashq-set! ANS-7::Base7NoteTable '3620 "bes")
        (hashq-set! ANS-7::Base7NoteTable '3630 "bis")
        (hashq-set! ANS-7::Base7NoteTable '3640 "bisis")
(hashq-set! ANS-7::Base7NoteTable '4000 "c'")
        (hashq-set! ANS-7::Base7NoteTable '4010 "ceses'")
        (hashq-set! ANS-7::Base7NoteTable '4020 "ces'")
        (hashq-set! ANS-7::Base7NoteTable '4030 "cis'")
        (hashq-set! ANS-7::Base7NoteTable '4040 "cisis'")
(hashq-set! ANS-7::Base7NoteTable '4100 "d'")
        (hashq-set! ANS-7::Base7NoteTable '4110 "deses'")
        (hashq-set! ANS-7::Base7NoteTable '4120 "des'")
        (hashq-set! ANS-7::Base7NoteTable '4130 "dis'")
        (hashq-set! ANS-7::Base7NoteTable '4140 "disis'")
(hashq-set! ANS-7::Base7NoteTable '4200 "e'")
        (hashq-set! ANS-7::Base7NoteTable '4210 "eeses'")
        (hashq-set! ANS-7::Base7NoteTable '4220 "ees'")
        (hashq-set! ANS-7::Base7NoteTable '4230 "eis'")
        (hashq-set! ANS-7::Base7NoteTable '4240 "eisis'")
(hashq-set! ANS-7::Base7NoteTable '4300 "f'")
        (hashq-set! ANS-7::Base7NoteTable '4310 "feses'")
        (hashq-set! ANS-7::Base7NoteTable '4320 "fes'")
        (hashq-set! ANS-7::Base7NoteTable '4330 "fis'")
        (hashq-set! ANS-7::Base7NoteTable '4340 "fisis'")
(hashq-set! ANS-7::Base7NoteTable '4400 "g'")
        (hashq-set! ANS-7::Base7NoteTable '4410 "geses'")
        (hashq-set! ANS-7::Base7NoteTable '4420 "ges'")
        (hashq-set! ANS-7::Base7NoteTable '4430 "gis'")
        (hashq-set! ANS-7::Base7NoteTable '4440 "gisis'")
(hashq-set! ANS-7::Base7NoteTable '4500 "a'")
        (hashq-set! ANS-7::Base7NoteTable '4510 "aeses'")
        (hashq-set! ANS-7::Base7NoteTable '4520 "aes'")
        (hashq-set! ANS-7::Base7NoteTable '4530 "ais'")
        (hashq-set! ANS-7::Base7NoteTable '4540 "aisis'")
(hashq-set! ANS-7::Base7NoteTable '4600 "b'")
        (hashq-set! ANS-7::Base7NoteTable '4610 "beses'")
        (hashq-set! ANS-7::Base7NoteTable '4620 "bes'")
        (hashq-set! ANS-7::Base7NoteTable '4630 "bis'")
        (hashq-set! ANS-7::Base7NoteTable '4640 "bisis'")
(hashq-set! ANS-7::Base7NoteTable '5000 "c''")
        (hashq-set! ANS-7::Base7NoteTable '5010 "ceses''")
        (hashq-set! ANS-7::Base7NoteTable '5020 "ces''")
        (hashq-set! ANS-7::Base7NoteTable '5030 "cis''")
        (hashq-set! ANS-7::Base7NoteTable '5040 "cisis''")
(hashq-set! ANS-7::Base7NoteTable '5100 "d''")
        (hashq-set! ANS-7::Base7NoteTable '5110 "deses''")
        (hashq-set! ANS-7::Base7NoteTable '5120 "des''")
        (hashq-set! ANS-7::Base7NoteTable '5130 "dis''")
        (hashq-set! ANS-7::Base7NoteTable '5140 "disis''")
(hashq-set! ANS-7::Base7NoteTable '5200 "e''")
        (hashq-set! ANS-7::Base7NoteTable '5210 "eeses''")
        (hashq-set! ANS-7::Base7NoteTable '5220 "ees''")
        (hashq-set! ANS-7::Base7NoteTable '5230 "eis''")
        (hashq-set! ANS-7::Base7NoteTable '5240 "eisis''")
(hashq-set! ANS-7::Base7NoteTable '5300 "f''")
        (hashq-set! ANS-7::Base7NoteTable '5310 "feses''")
        (hashq-set! ANS-7::Base7NoteTable '5320 "fes''")
        (hashq-set! ANS-7::Base7NoteTable '5330 "fis''")
        (hashq-set! ANS-7::Base7NoteTable '5340 "fisis''")
(hashq-set! ANS-7::Base7NoteTable '5400 "g''")
        (hashq-set! ANS-7::Base7NoteTable '5410 "geses''")
        (hashq-set! ANS-7::Base7NoteTable '5420 "ges''")
        (hashq-set! ANS-7::Base7NoteTable '5430 "gis''")
        (hashq-set! ANS-7::Base7NoteTable '5440 "gisis''")
(hashq-set! ANS-7::Base7NoteTable '5500 "a''")
        (hashq-set! ANS-7::Base7NoteTable '5510 "aeses''")
        (hashq-set! ANS-7::Base7NoteTable '5520 "aes''")
        (hashq-set! ANS-7::Base7NoteTable '5530 "ais''")
        (hashq-set! ANS-7::Base7NoteTable '5540 "aisis''")
(hashq-set! ANS-7::Base7NoteTable '5600 "b''")
        (hashq-set! ANS-7::Base7NoteTable '5610 "beses''")
        (hashq-set! ANS-7::Base7NoteTable '5620 "bes''")
        (hashq-set! ANS-7::Base7NoteTable '5630 "bis''")
        (hashq-set! ANS-7::Base7NoteTable '5640 "bisis''")
(hashq-set! ANS-7::Base7NoteTable '6000 "c'''")
        (hashq-set! ANS-7::Base7NoteTable '6010 "ceses'''")
        (hashq-set! ANS-7::Base7NoteTable '6020 "ces'''")
        (hashq-set! ANS-7::Base7NoteTable '6030 "cis'''")
        (hashq-set! ANS-7::Base7NoteTable '6040 "cisis'''")
(hashq-set! ANS-7::Base7NoteTable '6100 "d'''")
        (hashq-set! ANS-7::Base7NoteTable '6110 "deses'''")
        (hashq-set! ANS-7::Base7NoteTable '6120 "des'''")
        (hashq-set! ANS-7::Base7NoteTable '6130 "dis'''")
        (hashq-set! ANS-7::Base7NoteTable '6140 "disis'''")
(hashq-set! ANS-7::Base7NoteTable '6200 "e'''")
        (hashq-set! ANS-7::Base7NoteTable '6210 "eeses'''")
        (hashq-set! ANS-7::Base7NoteTable '6220 "ees'''")
        (hashq-set! ANS-7::Base7NoteTable '6230 "eis'''")
        (hashq-set! ANS-7::Base7NoteTable '6240 "eisis'''")
(hashq-set! ANS-7::Base7NoteTable '6300 "f'''")
        (hashq-set! ANS-7::Base7NoteTable '6310 "feses'''")
        (hashq-set! ANS-7::Base7NoteTable '6320 "fes'''")
        (hashq-set! ANS-7::Base7NoteTable '6330 "fis'''")
        (hashq-set! ANS-7::Base7NoteTable '6340 "fisis'''")
(hashq-set! ANS-7::Base7NoteTable '6400 "g'''")
        (hashq-set! ANS-7::Base7NoteTable '6410 "geses'''")
        (hashq-set! ANS-7::Base7NoteTable '6420 "ges'''")
        (hashq-set! ANS-7::Base7NoteTable '6430 "gis'''")
        (hashq-set! ANS-7::Base7NoteTable '6440 "gisis'''")
(hashq-set! ANS-7::Base7NoteTable '6500 "a'''")
        (hashq-set! ANS-7::Base7NoteTable '6510 "aeses'''")
        (hashq-set! ANS-7::Base7NoteTable '6520 "aes'''")
        (hashq-set! ANS-7::Base7NoteTable '6530 "ais'''")
        (hashq-set! ANS-7::Base7NoteTable '6540 "aisis'''")
(hashq-set! ANS-7::Base7NoteTable '6600 "b'''")
        (hashq-set! ANS-7::Base7NoteTable '6610 "beses'''")
        (hashq-set! ANS-7::Base7NoteTable '6620 "bes'''")
        (hashq-set! ANS-7::Base7NoteTable '6630 "bis'''")
        (hashq-set! ANS-7::Base7NoteTable '6640 "bisis'''")
(hashq-set! ANS-7::Base7NoteTable '10000 "c''''")
        (hashq-set! ANS-7::Base7NoteTable '10010 "ceses''''")
        (hashq-set! ANS-7::Base7NoteTable '10020 "ces''''")
        (hashq-set! ANS-7::Base7NoteTable '10030 "cis''''")
        (hashq-set! ANS-7::Base7NoteTable '10040 "cisis''''")
(hashq-set! ANS-7::Base7NoteTable '10100 "d''''")
        (hashq-set! ANS-7::Base7NoteTable '10110 "deses''''")
        (hashq-set! ANS-7::Base7NoteTable '10120 "des''''")
        (hashq-set! ANS-7::Base7NoteTable '10130 "dis''''")
        (hashq-set! ANS-7::Base7NoteTable '10140 "disis''''")
(hashq-set! ANS-7::Base7NoteTable '10200 "e''''")
        (hashq-set! ANS-7::Base7NoteTable '10210 "eeses''''")
        (hashq-set! ANS-7::Base7NoteTable '10220 "ees''''")
        (hashq-set! ANS-7::Base7NoteTable '10230 "eis''''")
        (hashq-set! ANS-7::Base7NoteTable '10240 "eisis''''")
(hashq-set! ANS-7::Base7NoteTable '10300 "f''''")
        (hashq-set! ANS-7::Base7NoteTable '10310 "feses''''")
        (hashq-set! ANS-7::Base7NoteTable '10320 "fes''''")
        (hashq-set! ANS-7::Base7NoteTable '10330 "fis''''")
        (hashq-set! ANS-7::Base7NoteTable '10340 "fisis''''")
(hashq-set! ANS-7::Base7NoteTable '10400 "g''''")
        (hashq-set! ANS-7::Base7NoteTable '10410 "geses''''")
        (hashq-set! ANS-7::Base7NoteTable '10420 "ges''''")
        (hashq-set! ANS-7::Base7NoteTable '10430 "gis''''")
        (hashq-set! ANS-7::Base7NoteTable '10440 "gisis''''")
(hashq-set! ANS-7::Base7NoteTable '10500 "a''''")
        (hashq-set! ANS-7::Base7NoteTable '10510 "aeses''''")
        (hashq-set! ANS-7::Base7NoteTable '10520 "aes''''")
        (hashq-set! ANS-7::Base7NoteTable '10530 "ais''''")
        (hashq-set! ANS-7::Base7NoteTable '10540 "aisis''''")
(hashq-set! ANS-7::Base7NoteTable '10600 "b''''")
        (hashq-set! ANS-7::Base7NoteTable '10610 "beses''''")
        (hashq-set! ANS-7::Base7NoteTable '10620 "bes''''")
        (hashq-set! ANS-7::Base7NoteTable '10630 "bis''''")
        (hashq-set! ANS-7::Base7NoteTable '10640 "bisis''''")
)


(define ANS-7::Base7NoteTableR (make-hash-table 330))

(let createANS-7::Base7NoteTableR ()

(hashq-set! ANS-7::Base7NoteTableR 'c,,, "000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses,,, "100")
        (hashq-set! ANS-7::Base7NoteTableR 'ces,,, "020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis,,, "030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis,,, "040")
(hashq-set! ANS-7::Base7NoteTableR 'd,,, "100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses,,, "110")
        (hashq-set! ANS-7::Base7NoteTableR 'des,,, "120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis,,, "130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis,,, "140")
(hashq-set! ANS-7::Base7NoteTableR 'e,,, "200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses,,, "210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees,,, "220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis,,, "230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis,,, "240")
(hashq-set! ANS-7::Base7NoteTableR 'f,,, "300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses,,, "310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes,,, "320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis,,, "330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis,,, "340")
(hashq-set! ANS-7::Base7NoteTableR 'g,,, "400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses,,, "410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges,,, "420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis,,, "430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis,,, "440")
(hashq-set! ANS-7::Base7NoteTableR 'a,,, "500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses,,, "510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes,,, "520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais,,, "530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis,,, "540")
(hashq-set! ANS-7::Base7NoteTableR 'b,,, "600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses,,, "610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes,,, "620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis,,, "630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis,,, "640")
(hashq-set! ANS-7::Base7NoteTableR 'c,, "1000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses,, "1010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces,, "1020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis,, "1030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis,, "1040")
(hashq-set! ANS-7::Base7NoteTableR 'd,, "1100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses,, "1110")
        (hashq-set! ANS-7::Base7NoteTableR 'des,, "1120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis,, "1130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis,, "1140")
(hashq-set! ANS-7::Base7NoteTableR 'e,, "1200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses,, "1210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees,, "1220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis,, "1230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis,, "1240")
(hashq-set! ANS-7::Base7NoteTableR 'f,, "1300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses,, "1310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes,, "1320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis,, "1330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis,, "1340")
(hashq-set! ANS-7::Base7NoteTableR 'g,, "1400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses,, "1410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges,, "1420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis,, "1430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis,, "1440")
(hashq-set! ANS-7::Base7NoteTableR 'a,, "1500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses,, "1510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes,, "1520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais,, "1530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis,, "1540")
(hashq-set! ANS-7::Base7NoteTableR 'b,, "1600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses,, "1610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes,, "1620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis,, "1630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis,, "1640")
(hashq-set! ANS-7::Base7NoteTableR 'c, "2000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses, "2010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces, "2020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis, "2030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis, "2040")
(hashq-set! ANS-7::Base7NoteTableR 'd, "2100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses, "2110")
        (hashq-set! ANS-7::Base7NoteTableR 'des, "2120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis, "2130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis, "2140")
(hashq-set! ANS-7::Base7NoteTableR 'e, "2200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses, "2210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees, "2220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis, "2230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis, "2240")
(hashq-set! ANS-7::Base7NoteTableR 'f, "2300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses, "2310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes, "2320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis, "2330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis, "2340")
(hashq-set! ANS-7::Base7NoteTableR 'g, "2400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses, "2410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges, "2420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis, "2430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis, "2440")
(hashq-set! ANS-7::Base7NoteTableR 'a, "2500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses, "2510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes, "2520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais, "2530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis, "2540")
(hashq-set! ANS-7::Base7NoteTableR 'b, "2600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses, "2610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes, "2620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis, "2630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis, "2640")
(hashq-set! ANS-7::Base7NoteTableR 'c "3000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses "3010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces "3020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis "3030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis "3040")
(hashq-set! ANS-7::Base7NoteTableR 'd "3100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses "3110")
        (hashq-set! ANS-7::Base7NoteTableR 'des "3120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis "3130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis "3140")
(hashq-set! ANS-7::Base7NoteTableR 'e "3200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses "3210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees "3220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis "3230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis "3240")
(hashq-set! ANS-7::Base7NoteTableR 'f "3300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses "3310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes "3320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis "3330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis "3340")
(hashq-set! ANS-7::Base7NoteTableR 'g "3400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses "3410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges "3420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis "3430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis "3440")
(hashq-set! ANS-7::Base7NoteTableR 'a "3500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses "3510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes "3520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais "3530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis "3540")
(hashq-set! ANS-7::Base7NoteTableR 'b "3600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses "3610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes "3620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis "3630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis "3640")
(hashq-set! ANS-7::Base7NoteTableR 'c' "4000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses' "4010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces' "4020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis' "4030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis' "4040")
(hashq-set! ANS-7::Base7NoteTableR 'd' "4100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses' "4110")
        (hashq-set! ANS-7::Base7NoteTableR 'des' "4120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis' "4130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis' "4140")
(hashq-set! ANS-7::Base7NoteTableR 'e' "4200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses' "4210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees' "4220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis' "4230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis' "4240")
(hashq-set! ANS-7::Base7NoteTableR 'f' "4300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses' "4310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes' "4320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis' "4330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis' "4340")
(hashq-set! ANS-7::Base7NoteTableR 'g' "4400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses' "4410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges' "4420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis' "4430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis' "4440")
(hashq-set! ANS-7::Base7NoteTableR 'a' "4500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses' "4510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes' "4520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais' "4530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis' "4540")
(hashq-set! ANS-7::Base7NoteTableR 'b' "4600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses' "4610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes' "4620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis' "4630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis' "4640")
(hashq-set! ANS-7::Base7NoteTableR 'c'' "5000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses'' "5010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces'' "5020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis'' "5030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis'' "5040")
(hashq-set! ANS-7::Base7NoteTableR 'd'' "5100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses'' "5110")
        (hashq-set! ANS-7::Base7NoteTableR 'des'' "5120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis'' "5130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis'' "5140")
(hashq-set! ANS-7::Base7NoteTableR 'e'' "5200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses'' "5210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees'' "5220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis'' "5230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis'' "5240")
(hashq-set! ANS-7::Base7NoteTableR 'f'' "5300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses'' "5310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes'' "5320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis'' "5330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis'' "5340")
(hashq-set! ANS-7::Base7NoteTableR 'g'' "5400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses'' "5410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges'' "5420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis'' "5430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis'' "5440")
(hashq-set! ANS-7::Base7NoteTableR 'a'' "5500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses'' "5510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes'' "5520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais'' "5530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis'' "5540")
(hashq-set! ANS-7::Base7NoteTableR 'b'' "5600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses'' "5610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes'' "5620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis'' "5630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis'' "5640")
(hashq-set! ANS-7::Base7NoteTableR 'c''' "6000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses''' "6010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces''' "6020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis''' "6030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis''' "6040")
(hashq-set! ANS-7::Base7NoteTableR 'd''' "6100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses''' "6110")
        (hashq-set! ANS-7::Base7NoteTableR 'des''' "6120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis''' "6130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis''' "6140")
(hashq-set! ANS-7::Base7NoteTableR 'e''' "6200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses''' "6210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees''' "6220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis''' "6230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis''' "6240")
(hashq-set! ANS-7::Base7NoteTableR 'f''' "6300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses''' "6310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes''' "6320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis''' "6330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis''' "6340")
(hashq-set! ANS-7::Base7NoteTableR 'g''' "6400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses''' "6410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges''' "6420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis''' "6430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis''' "6440")
(hashq-set! ANS-7::Base7NoteTableR 'a''' "6500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses''' "6510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes''' "6520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais''' "6530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis''' "6540")
(hashq-set! ANS-7::Base7NoteTableR 'b''' "6600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses''' "6610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes''' "6620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis''' "6630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis''' "6640")
(hashq-set! ANS-7::Base7NoteTableR 'c'''' "10000")
        (hashq-set! ANS-7::Base7NoteTableR 'ceses'''' "10010")
        (hashq-set! ANS-7::Base7NoteTableR 'ces'''' "10020")
        (hashq-set! ANS-7::Base7NoteTableR 'cis'''' "10030")
        (hashq-set! ANS-7::Base7NoteTableR 'cisis'''' "10040")
(hashq-set! ANS-7::Base7NoteTableR 'd'''' "10100")
        (hashq-set! ANS-7::Base7NoteTableR 'deses'''' "10110")
        (hashq-set! ANS-7::Base7NoteTableR 'des'''' "10120")
        (hashq-set! ANS-7::Base7NoteTableR 'dis'''' "10130")
        (hashq-set! ANS-7::Base7NoteTableR 'disis'''' "10140")
(hashq-set! ANS-7::Base7NoteTableR 'e'''' "10200")
        (hashq-set! ANS-7::Base7NoteTableR 'eeses'''' "10210")
        (hashq-set! ANS-7::Base7NoteTableR 'ees'''' "10220")
        (hashq-set! ANS-7::Base7NoteTableR 'eis'''' "10230")
        (hashq-set! ANS-7::Base7NoteTableR 'eisis'''' "10240")
(hashq-set! ANS-7::Base7NoteTableR 'f'''' "10300")
        (hashq-set! ANS-7::Base7NoteTableR 'feses'''' "10310")
        (hashq-set! ANS-7::Base7NoteTableR 'fes'''' "10320")
        (hashq-set! ANS-7::Base7NoteTableR 'fis'''' "10330")
        (hashq-set! ANS-7::Base7NoteTableR 'fisis'''' "10340")
(hashq-set! ANS-7::Base7NoteTableR 'g'''' "10400")
        (hashq-set! ANS-7::Base7NoteTableR 'geses'''' "10410")
        (hashq-set! ANS-7::Base7NoteTableR 'ges'''' "10420")
        (hashq-set! ANS-7::Base7NoteTableR 'gis'''' "10430")
        (hashq-set! ANS-7::Base7NoteTableR 'gisis'''' "10440")
(hashq-set! ANS-7::Base7NoteTableR 'a'''' "10500")
        (hashq-set! ANS-7::Base7NoteTableR 'aeses'''' "10510")
        (hashq-set! ANS-7::Base7NoteTableR 'aes'''' "10520")
        (hashq-set! ANS-7::Base7NoteTableR 'ais'''' "10530")
        (hashq-set! ANS-7::Base7NoteTableR 'aisis'''' "10540")
(hashq-set! ANS-7::Base7NoteTableR 'b'''' "10600")
        (hashq-set! ANS-7::Base7NoteTableR 'beses'''' "10610")
        (hashq-set! ANS-7::Base7NoteTableR 'bes'''' "10620")
        (hashq-set! ANS-7::Base7NoteTableR 'bis'''' "10630")
        (hashq-set! ANS-7::Base7NoteTableR 'bisis'''' "10640")
)


;;;; Basic functions
;;;; Important: All these work with strings because there is no native number base7 system in Scheme.

(define (ANS-7::Ly2Ans lilynote) ;wants string, returns string
	(hashq-ref ANS-7::Base7NoteTableR (string->symbol lilynote))
)

;TODO: Chordtranslation is missing. But keep the single note functions, will be faster.

(define (ANS-7::Ans2Ly ansNote) ;wants string, returns strings
	(hashq-ref ANS-7::Base7NoteTable (string->number ansNote))
)

(define (ANS-7::GetChordNotes); For singles and chords. Returns string of ANS-7 notes as pseudo-list divided by space: : "3500 4030 4200". 
	(define newList #f)
	(set! newList (string-tokenize (d-GetNotes)) )

	(let transformChordList ((i 0) )
	(if (<= i (-(length newList )1)) 
		(begin
			(set! newList (replace-nth newList i (ANS-7::Ly2Ans (list-ref newList i) )))
			(transformChordList (+ i 1)))))

	(string-join newList)
)

(define* (ANS-7::InsertNotes ansNotes #:optional (duration #f)); wants string of ANS-7 notes string, can be a pseudo-list divided by space: "3500 4030 4200". Optional duration. returns #t or #f
	(if (string? ansNotes)
		(begin (d-InsertA) (ANS-7::ChangeChordNotes ansNotes)))
)

(define (ANS-7::ChangeChordNotes ansNotes); wants string of ANS-7 notes, can be a pseudo-list divided by space: "c' e'' gis,". 
	(define newList #f)
	(set! newList (string-tokenize ansNotes) )

	(let transformChordList ((i 0) )
	(if (<= i (-(length newList )1)) 
		(begin
			(set! newList (replace-nth newList i (ANS-7::Ans2Ly (list-ref newList i) )))
			(transformChordList (+ i 1)))))

	(d-ChangeChordNotes (string-join newList))
)

(define (ANS-7::MakeWhiteKey ansNote) ; wants string, returns string
	(string-append (string-drop-right ansNote  2  ) "00") 
)

(define (ANS-7::+ one two); wants two strings 
	(number->string (+	(string->number one 7) (string->number two 7)) 7)
)

(define (ANS-7::- one two); wants two strings 
	(number->string (-	(string->number one 7) (string->number two 7)) 7)
)

;Calculate the a diatonic step up or down and keep it in scale / according to the prevailing keysignature
;wants lilypond and returns the next diatonic step in lilypond. Defaults to upward step. There is an optional bool parameter, if set to #t  the step goes down.
(define* (ANS-7::CalculateDiatonicStep sourceLilypond #:optional (down #f)) ;
       (define listi (string-tokenize(d-GetPrevailingKeysig)))
       
       (let calc ((sourceNumber 0)(nextNumber 0) (thirdDigit 0) )
		(set! sourceNumber (ANS-7::Ly2Ans sourceLilypond))
		(set! nextNumber (ANS-7::MakeWhiteKey sourceNumber))
		(if down
			(set! nextNumber (ANS-7::- nextNumber  "100"))
			(set! nextNumber (ANS-7::+ nextNumber  "100"))
		)

		(set! thirdDigit
		; always take the third-last digit which shows the note as "white key" and regardless of the octave.  This is done for the target-note, not for the origin.
			(string-ref nextNumber (- (string-length nextNumber) 3) )) ; string-ref returns char, not string.

		(set! thirdDigit (string->number (string thirdDigit))) ; transfer the char to a real number
			
		 (case (string->number (list-ref listi thirdDigit))
		   ((0)		(set! nextNumber (ANS-7::+ nextNumber  "0"))) ; natural
		   ((1)		(set! nextNumber (ANS-7::+ nextNumber  "30"))) ;sharp
		   ((-1)		(set! nextNumber (ANS-7::+ nextNumber  "20"))) ;flat
		   (else   #f ) ; someone might introduce some insane feature in the future where you can add doublecrosses or similar to a keysig. Or maybe there is even a real usage for micotonals like turkish maqam.
		  )
		   (ANS-7::Ans2Ly nextNumber) ; Return note as Lilypond-syntax
       )    
)
