%{!?release: %define release 0}
%{!?epoch:   %define epoch 0}
%{!?version: %define version 1.9.4}

%{!?uses_stdcpp:  %define uses_stdcpp 1}

%if %uses_stdcpp
%define _devel_requires libstdc++-devel
%else
%define	_config_stdcpp --disable-stdcpp
%endif

Name: ucommon
Summary: "ucommon" - portable embedded runtime
Version: %{version}
Release: %{release}%{?dist}
Epoch: %{epoch}
License: GPL
URL: http://www.gnu.org/software/commoncpp
Group: Development/Libraries
Source0: http://www.gnutelephony.org/dist/tarballs/ucommon-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: %{?_devel_requires}
BuildRequires: gcc-c++ 

%package devel
Requires: %{?_devel_requires}
Requires: ucommon = %{epoch}:%{version}-%{release}
Group: Development/Libraries
Summary: Headers and static link library

%description
uCommon is a lightweight C++ library to facilitate using C++ design patterns
even for very deeply embedded applications, such as for systems using uClibc
along with POSIX threading support. For this reason, UCommon disables language
features that consume memory or introduce runtime overhead. UCommon introduces
some design patterns from Objective-C, such as reference counted objects,
memory pools, and smart pointers. UCommon introduces some new concepts for
handling of thread locking and synchronization.

%description devel
Static link and header files for building applications that use uCommon.

%changelog

%prep
%setup
%build

%configure %{?_config_stdcpp} --enable-debug CXXFLAGS="$RPM_OPT_FLAGS" 
%{__make} %{?_smp_mflags} 

%install

%makeinstall
%{__rm} -rf %{buildroot}/%{_infodir}
%{__chmod} +x %{buildroot}/%{_bindir}/ucommon-config
%{__strip} %{buildroot}/%{_libdir}/libucommon-*.so.*.*

%clean
rm -fr %{buildroot}

%files 
%defattr(-,root,root,-)
%doc README COPYING INSTALL NEWS BUILDS
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root,-)
%{_bindir}/ucommon-config
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/*.la
%dir %{_includedir}/ucommon
%{_includedir}/ucommon/*.h
%{_libdir}/pkgconfig/*.pc

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

