/* 

        Copyright (C) 1995
        Free Software Foundation, Inc.

   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/

/*******************************************************************/
/*                                                                 */
/* File Image copying                                              */
/*                                                                 */
/* client part for remote copying                                  */
/*                                                                 */
/*******************************************************************/

#define INET 1

#include "cf.defs.h"
#include "cf.extern.h"

/*********************************************************************/

int IdentifyForVerification(sd,fqname)

int sd;
char *fqname;

{ char sendbuff[bufsize],dnsname[maxvarsize];
  struct sockaddr_in saddr;
  struct in_addr *iaddr;           
  struct hostent *hp;
  struct stat statbuf;
  int n, len;
  struct passwd *user_ptr;
  char *uname;
  
bzero(sendbuff,bufsize);

if (strcmp(VDOMAIN,CF_START_DOMAIN) == 0)
   {
   CfLog(cferror,"Undefined domain name","");
   return false;
   }
 
/* First we need to find out the IP address and DNS name of the socket
   we are sending from. This is not necessarily the same as fqname if
   the machine has a different uname from its IP name (!) This can
   happen on stupidly set up machines or on hosts with multiple
   interfaces, with different names on each interface ... */ 

len = sizeof(struct sockaddr_in);

if (getsockname(sd,(struct sockaddr *)&saddr,&len) == -1)
   {
   CfLog(cferror,"Couldn't get socket address\n","getsockname");
   return false;
   }

Debug("Identifying as %s i.e. %s, with signature %d\n",inet_ntoa(saddr.sin_addr),VFQNAME,CFSIGNATURE);

iaddr = &(saddr.sin_addr);
hp = gethostbyaddr((void *)iaddr,sizeof(struct in_addr),AF_INET);

if ((hp == NULL) || (hp->h_name == NULL))
   {
   CfLog(cferror,"Couldn't lookup IP address\n","gethostbyaddr");
   return false;
   }

strcpy(dnsname,hp->h_name);
 
/*if (strstr(hp->h_name,VDOMAIN)== 0)*/

if (strstr(hp->h_name,".") == 0) 
   {
   strcat(dnsname,".");
   strcat(dnsname,VDOMAIN);
   }
 
/*
#ifdef NT
if (stat("/etc/passwd",&statbuf) == -1)
   {
   CfLog(cferror,"Make sure you have made /etc/passwd with mkpasswd for remote copy to work\n","");
   }
#endif 

Replace this with code below instead...

*/

user_ptr = getpwuid(getuid());
uname = user_ptr ? user_ptr->pw_name : "UNKNOWN";
sprintf(sendbuff,"CAUTH %s %s %s %d",inet_ntoa(saddr.sin_addr),dnsname,uname,CFSIGNATURE);

if ((n = send(sd,sendbuff,bufsize,0)) == -1)
   {
   printf("send\n");
   sprintf(OUTPUT,"socket verify only sent %d bytes\n",n);
   CfLog(cferror,OUTPUT,"send");
   return false;
   }

return true;
}
