var groundview_x = -0.3;  # left/right, left side is default 
var groundview_y = 0.7;	  # up/down 
var groundview_z = 4.6;     # fore/aft
var groundview_roll = -15;  # left side is default
var viewdir_h = 1;
var zoomtime = 0.2;
var leantime = 0.5;
var defFOV = 55;
var def_head = 0;
var def_pit = 0;
var aim_offset_h = 10;
var aim_offset_p = 10;
var defView_x = 0.0;
var defView_y = 0.0;
var defView_z = 0.0;
var defView_roll = 0.0;


var view_on = func () {

  if (getprop ("sim/current-view/view-number") == 0) {

    if (getprop ("controls/doors/canopy/position-norm") == 1 ) {
      if ( getprop ("sim/current-view/heading-offset-deg") >= 180 ) {   # if looking right, invert the leaning direction
        viewdir_h = -1;
      } else {
        viewdir_h = 1;
      }
      taxiview ();
    }
    if (getprop ("controls/doors/canopy/position-norm") == 0 ) {
      zoomview ();
    }
  }
}

var taxiview = func (){



  interpolate ("sim/current-view/x-offset-m" , groundview_x * viewdir_h, leantime );
  interpolate ("sim/current-view/y-offset-m" , groundview_y, leantime );
  interpolate ("sim/current-view/z-offset-m" , groundview_z, leantime );
  interpolate ("sim/current-view/roll-offset-deg" , groundview_roll * viewdir_h, leantime );

}

var zoomview = func () {
  defFOV = getprop ("sim/current-view/field-of-view");
  def_head = getprop ("sim/view[0]/config/heading-offset-deg");
  def_pit = getprop ("sim/view[0]/config/pitch-offset-deg");
  
  var h_offset = getprop ("sim/current-view/heading-offset-deg") - aim_offset_h;
  
 print ( h_offset,"X", def_pit,"X", aim_offset_h,"X", aim_offset_p);
  if (h_offset <= 0 or h_offset >= ( 360 - 2 * aim_offset_h) ) {
    print ("Well, yes");
    interpolate ("sim/current-view/heading-offset-deg" ,def_head, zoomtime );
    interpolate ("sim/current-view/pitch-offset-deg" ,def_pit, zoomtime );
  #  interpolate ("sim/current-view/z-offset-m" ,getprop ("sim/view[0]/config/z-offset-m"), leantime );
  }
  
  
  interpolate ("sim/current-view/field-of-view", 30, zoomtime );



}



var view_off = func () {

  if (getprop ("sim/current-view/view-number") == 0) {


    defView_roll = getprop ("sim/view[0]/config/roll-offset-deg");
    if (getprop ("sim/current-view/field-of-view") != defFOV ) {
      interpolate ("sim/current-view/field-of-view", defFOV, zoomtime );
    }
    interpolate ("sim/current-view/x-offset-m" ,getprop ("sim/view[0]/config/x-offset-m"), leantime );
    interpolate ("sim/current-view/y-offset-m" ,getprop ("sim/view[0]/config/y-offset-m"), leantime );
    interpolate ("sim/current-view/z-offset-m" ,getprop ("sim/view[0]/config/z-offset-m"), leantime );
    interpolate ("sim/current-view/roll-offset-deg" ,getprop ("sim/view[0]/config/roll-offset-deg"), leantime );

  }

}




