#	All Properties and variables used by the aircraft's (nasal-coded) systems 
var electrical = props.globals.getNode( "/systems/electrical", 1 );
var batt = {
	temp: [
		electrical.getNode( "battery-temp-degc[0]", 1 ),
		electrical.getNode( "battery-temp-degc[1]", 1 ),
	],
	status: [
		electrical.initNode( "battery-status[0]", 0, "INT" ),	# 0 = ERROR; 1 = READY; 2 = ACTIVE
		electrical.initNode( "battery-status[1]", 0, "INT" ),	# 0 = ERROR; 1 = READY; 2 = ACTIVE
	],
	present: [
		props.globals.getNode("/alpha_electro/battery-front-present", 1),
		props.globals.getNode("/alpha_electro/battery-rear-present", 1),
	],
	mass: [
		props.globals.getNode("/fdm/jsbsim/inertia/pointmass-weight-lbs[3]", 1),
		props.globals.getNode("/fdm/jsbsim/inertia/pointmass-weight-lbs[4]", 1),
	],
};
var batt_present = [ 1, 1 ];
var batt_mass = getprop("/variant-specific/battery-mass-kg") / KG2LB;

var engine = {
	thr: props.globals.getNode( "/controls/engines/engine[0]/throttle", 1 ),
	power_hp: props.globals.getNode( "/fdm/jsbsim/propulsion/engine[0]/electrical-power-hp", 1 ),
	rpm: props.globals.getNode( "/engines/engine[0]/rpm", 1 ),
};

var variant = ( getprop("/sim/aero") == "veliselectro-jsb" );
