/* ===============================================================
 * 	afo.c (Agressive File Obliterator) - File deleter that overwrites contents of directories/files 
 * 		with gibberish before deleting them.
 * 
 * 		- jafadmin
 *  ===============================================================
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "tinydir.h"

// function prototypes
int Clobber(char *file, int passes); 
int ClearDir(char *DirName, int passes);

void usage(char * progname)
{
	fprintf(stderr, "\n\tafo  - (Agressive File Obliterator)\n");
    fprintf(stderr, "Overwrite directories/files with random gibberish, then delete.\n");
    fprintf(stderr, "Usage: %s [-c N (# of overwrites, default=1)] file spec\n", progname);	
    fprintf(stderr, "Example: # %s -c 2 DirectoryName\n", progname);
    fprintf(stderr, "Example: # %s *.bak\n", progname);
    fprintf(stderr, "Example: # %s -c 5 *\n\n", progname);
}
//  Overwrite filespec w/ random data -c [n] number of times, 
//		then delete it.
int main(int argc, char **argv)
{	
  	int opt, cnt=1, x=1;
  	struct stat st;
  	
  	if(argc < 2) usage(argv[0]);

	while ((opt = getopt(argc, argv, "hc:")) != -1) {
		switch (opt) {              
               case 'c':
                   cnt = atoi(optarg);    // number of overwrite passes 
                   break;
              case 'h':
              		usage(argv[0]);
                   	exit(0);
               default: /* '?' */
                   usage(argv[0]);
                   exit(EXIT_FAILURE);
        }
	}
	/* The Bash Shell globs the filenames for us so we must loop through the
	 * args until all files matching the filespec are processed.
	*/		
	for(x = optind; x < argc; x++ )
	{
		lstat(*(argv + x), &st); 	// Use lstat() instead of stat() so we can find symlinks
   
		if(S_ISDIR(st.st_mode)) 	// It is a directory
		{
			 ClearDir(*(argv + x), cnt);
			 rmdir(*(argv + x));
		}
		else if(S_ISLNK(st.st_mode)) unlink(*(argv + x));  			// It is a symbolic Link
		else if(S_ISREG(st.st_mode)) Clobber(*(argv + x), cnt); 	// It is a regular file ..
  	}
  	return(0);
}

/* Traverse directories and sub-directories, zapping everything with clobber()
 *  .. this function uses recursion to navigate directories
*/
int ClearDir(char *DirName, int passes)
{
	char DirPath[512]; 
	tinydir_dir dir;
	size_t i;
	
	if (tinydir_open_sorted(&dir, DirName) == -1)
	{
		perror("Error opening file");
		goto bail;
	}

	for (i = 0; i < dir.n_files; i++)
	{
		tinydir_file file;
		if (tinydir_readfile_n(&dir, &file, i) == -1)
		{
			perror("Error getting file");
			goto bail;
		}
		if(!strcmp(file.name,  ".")) continue; // ignore these guys ..
		if(!strcmp(file.name, "..")) continue;		
		strcpy(DirPath, DirName);
		strcat(DirPath, "/");
		strcat(DirPath, file.name);
		
		if (file.is_dir) 		// We've found a sub-directory; We're going in ...
		{													
			ClearDir(DirPath, passes); // Sweet, elegant, recursion...
			rmdir(DirPath);
		}
		else if (file.is_reg) Clobber(DirPath, passes); 	// regular file
		else if (file.is_lnk) unlink(DirPath);					// symbolic link
		else fprintf(stderr, "\nClearDir(); I don't know about: %s.\n", DirPath);	// WTFO?
	}

bail:
	tinydir_close(&dir);
	return 0;
}
//  Overwrite file w/ random data,  "passes" number of times, 
//		then remove (delete) it.
int Clobber(char *file, int passes) 
{	
  	int i, j, fd;  char ch = 0;  struct stat st;
  	
	lstat(file, &st);
   
    for (i = passes; i > 0; i--) 
    {
		fd = open(file, O_WRONLY); 
    	for (j = 0; j < st.st_size; j++) 
    	{
      		ch = random();
        	write(fd, &ch, 1);
    	}
    	fsync(fd); // force the kernel to write the data to disk NOW
    	close(fd);
    }
  	if (remove(file)) {
    	fprintf(stdout, "Error deleting file %s\n", file);
    	return(1);
  	}
  	return(0);
} 

 
