/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef TABWIDGETITEM_H
#define TABWIDGETITEM_H

#include "action.h"
#include <QWidget>
#include <QPushButton>
#include <QLineEdit>
#include <QComboBox>
#include <QSpinBox>
#include <QGridLayout>
#include <QLabel>
#include <QCompleter>
#include <QScopedPointer>

class TabWidgetItem: public QWidget
{
    Q_OBJECT

public:
    explicit TabWidgetItem(QWidget *parent = 0);
    ~TabWidgetItem();

    void clear();
    int getLevel() const;
    Action::type_t getType() const;
    QString getText() const;
    void setLevel(const int level);
    void setType(Action::type_t type);
    void setText(const QString &text);

private slots:
    void onCmbChanged(int i);
    void onBrowseClicked();
    void onCommandChanged(const QString &text);

private:
    QScopedPointer <QPushButton> m_btn_browse;
    QScopedPointer <QLineEdit> m_txt_command;
    QScopedPointer <QComboBox> m_cmb_type;
    QScopedPointer <QSpinBox> m_spn_level;
    QScopedPointer <QLabel> m_lbl_action;
    QScopedPointer <QLabel> m_lbl_level;

    QScopedPointer <QCompleter> m_completer;
};

#endif // TABWIDGETITEM_H
