/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef _SETTINGS_DIALOG_H_
#define _SETTINGS_DIALOG_H_

#include "ui_settingsdialog.h"
#include "tabwidget.h"
#include "common.h"
#include <QPushButton>
#include <QCompleter>
#include <QScopedPointer>

class SettingsDialog: public QDialog, private Ui::SettingsDialog
{
    Q_OBJECT

public:
    SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

public slots:
    void show();

    void saveSettings();
    void loadSettings();

#if (defined(Q_OS_WIN32) && (WINVER >= 0x0600))
    void setMinPower(bool s = true);
    void setMaxPower(bool s = true);
    void setBalanced(bool s = true);
    void setUseSchemes(bool u = true);
#endif

private slots:
    void okClicked();
    void browseClicked();
    void logChanged(const QString &file);
#if (defined(Q_OS_WIN32) && (WINVER >= 0x0600))
    void schemeChanged();
#endif

signals:
    void newConfiguration();

private:
    QScopedPointer <TabWidget> m_tab_widget;
    QScopedPointer <QCompleter> m_completer;
    bool m_scheme_changed;
#if (defined(Q_OS_WIN32) && (WINVER >= 0x0600))
    bool m_use_schemes;
#endif
};

#endif
