/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef GRAPH_H
#define GRAPH_H

#include "dataminer.h"
#include <QWidget>

class Graph: public QWidget
{
	Q_OBJECT
public:
	explicit Graph(QWidget *parent = 0);
	~Graph();

	void showScale(bool show = true);
	void showGrid(bool show = true);

private:
	QPoint getGridPos(int x, int y) const;
	int getGridX(int x) const;

public slots:
	void load();
	void show();

protected:
	void paintEvent(QPaintEvent *ev);

private:
	QVector <Data> m_data;
	bool m_scale;
	bool m_grid;

	int m_margin_left;
	int m_margin_bottom;
	int m_margin_top;
	int m_margin_right;
};

#endif // GRAPH_H
