/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef BATTERY_METER_H
#define BATTERY_METER_H

#include <QScopedPointer>
#include <QSystemTrayIcon>
#include <QTimer>
#include <QMenu>
#include <QAction>
#include <QVector>

#include "infodialog.h"
#include "settingsdialog.h"
#include "systemtrayicon.h"
#include "common.h"
#include "batterymeter.h"

#ifdef Q_OS_WIN32
#  include "powerscheme.h"
#endif

#ifdef Q_OS_WIN32
class MessageListener: public QWidget
{
    Q_OBJECT

public:
    explicit MessageListener(QWidget *parent = 0);
    ~MessageListener();

    void listen(bool l = true);

protected:
    virtual bool winEvent(MSG *msg, long *res);

signals:
    void powerStatusChanged();
    void powerSchemeChanged();

private:
    bool m_listen;
#  if (WINVER >= 0x0600)
    HPOWERNOTIFY m_power_source_notify;
    HPOWERNOTIFY m_battery_perc_notify;
    HPOWERNOTIFY m_power_scheme_notify;
#  endif
};
#endif

//------------------------------------------------------------------------------

class BatteryMeterGui: public QTimer
{
    Q_OBJECT

public:
    explicit BatteryMeterGui(QObject *parent = 0);
    ~BatteryMeterGui();

public slots:
    void update();
    void show();
    void hide();
    void start();
    void start(int msec);
    void stop();

private slots:
    void infoDlgVisibility();
    void readConfiguration();
    //	void checkFirstRun();
#ifdef USE_LOGGING
    void onLog();
#endif

    void dischargeActions();
    void chargeActions();
#if (defined (Q_OS_WIN32) && (WINVER >= 0x0600))
    void changePowerStatus();
    void powerStatusChanged();
#endif

private:
    QScopedPointer <BatteryMeterTrayIcon> m_tray;
    QScopedPointer <QMenu> m_menu;
    QScopedPointer <QAction> m_act_quit;
    QScopedPointer <QAction> m_act_settings;
    QScopedPointer <QAction> m_act_info;
    QScopedPointer <QAction> m_act_log;
#if (defined (Q_OS_WIN32) && (WINVER >= 0x0600))
    QMenu *m_power_menu;
    QActionGroup *m_actgrp_power;
    QAction *m_act_min_power;
    QAction *m_act_max_power;
    QAction *m_act_balanced;
    PowerScheme m_power_scheme;
#endif

    QScopedPointer <InfoDialog> m_dlg_info;
    QScopedPointer <SettingsDialog> m_dlg_settings;

#ifdef Q_OS_WIN32
    MessageListener m_message_listener;
#endif
    BatteryMeter m_battery_meter;
#ifdef USE_LOGGING
    bool m_logging;
    QString m_log_file;
    QTimer m_logger;
#endif

    //battery level actions
    QVector <Action> m_unprocessed_actions;
    QVector <Action> m_processed_actions;
};

//------------------------------------------------------------------------------

#endif // BATTERY_METER_H
