/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef ACTION_H
#define ACTION_H

#include <QString>

class Action
{
public:
    typedef enum {MESSAGE, ACTION, SUSPEND, HIBERNATE, POWEROFF, NOTHING} type_t;

public:
    Action();
    Action(const Action &copy);

    void setType(type_t type);
    void setLevel(int level);
    void setAttr(const QString &attr);
    void setProcessed(bool processed = true);

    type_t type() const;
    int level() const;
    QString attr() const;
    bool processed() const;

    bool operator== (const Action &right) const;
    bool operator!= (const Action &right) const;
    bool operator< (const Action &right) const;
    bool operator<= (const Action &right) const;
    bool operator> (const Action &right) const;
    bool operator>= (const Action &right) const;

private:
    type_t m_type;
    int m_level;
    QString m_attr;
    bool m_processed;
};

#endif // ACTION_H
