/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class BooleanPropertyEditor
extends PropertyEditor {
    private static final Image m_trueImage = DesignerPlugin.getImage("properties/true.png");
    private static final Image m_falseImage = DesignerPlugin.getImage("properties/false.png");
    private static final Image m_unknownImage = DesignerPlugin.getImage("properties/BooleanUnknown.png");
    public static final PropertyEditor INSTANCE = new BooleanPropertyEditor();

    private BooleanPropertyEditor() {
    }

    @Override
    public void paint(Property property, GC gc, int x, int y, int width, int height) throws Exception {
        Object value = property.getValue();
        if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            Image image = booleanValue ? m_trueImage : m_falseImage;
            String text = Boolean.toString(booleanValue);
            this.paint(gc, x, y, width, height, image, text);
        } else {
            this.paint(gc, x, y, width, height, m_unknownImage, "unknown");
        }
    }

    private void paint(GC gc, int x, int y, int width, int height, Image image, String text) {
        DrawUtils.drawImageCV(gc, image, x, y, height);
        int imageWidth = image.getBounds().width + 2;
        DrawUtils.drawStringCV(gc, text, x += imageWidth, y, width -= imageWidth, height);
    }

    @Override
    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null || location.x < BooleanPropertyEditor.m_trueImage.getBounds().width + 2) {
            this.invertValue(property);
        }
        return false;
    }

    @Override
    public void doubleClick(Property property, Point location) throws Exception {
        this.invertValue(property);
    }

    private void invertValue(Property property) throws Exception {
        boolean booleanValue = false;
        Object value = property.getValue();
        if (value instanceof Boolean) {
            booleanValue = (Boolean)value;
        }
        property.setValue(!booleanValue);
    }
}

