/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.digester3.Rule;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.accessor.FieldExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;
import org.xml.sax.Attributes;

public final class CreatePropertiesFieldRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        Class<?> componentClass = componentDescription.getComponentClass();
        Field[] fieldArray = componentClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                CreatePropertiesFieldRule.addSingleProperty(componentDescription, field);
            }
            ++n2;
        }
    }

    private static void addSingleProperty(ComponentDescription componentDescription, Field field) throws Exception {
        String id = field.getName();
        String propertyName = field.getName();
        Class<?> propertyType = field.getType();
        FieldExpressionAccessor accessor = new FieldExpressionAccessor(field);
        ExpressionConverter converter = DescriptionPropertiesHelper.getConverterForType(propertyType);
        PropertyEditor editor = DescriptionPropertiesHelper.getEditorForType(propertyType);
        GenericPropertyDescription property = new GenericPropertyDescription(id, propertyName, propertyType, accessor);
        property.setConverter(converter);
        property.setEditor(editor);
        componentDescription.addProperty(property);
    }
}

