/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.jsts.ui.preferences.JSTSLanguagePreferences;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
class TestTypeScriptFormattingPreferences {
    private IProject project;

    TestTypeScriptFormattingPreferences() {
    }

    @BeforeEach
    void setUpProject() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
    }

    @AfterEach
    void tearDown() {
        Activator.getDefault().getPreferenceStore().setValue(JSTSLanguagePreferences.TS.format_indentSize, 4);
    }

    @Test
    void testFormatterPrefsApplyWithoutRestart() throws Exception {
        IFile file = this.project.getFile("format.ts");
        String original = "function greet() {\n  return 1\n}\n";
        file.create(original.getBytes("UTF-8"), true, false, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
        DisplayHelper.sleep((long)2000L);
        LanguageServersRegistry.LanguageServerDefinition jstsDef = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.jsts");
        ArrayList servers = new ArrayList();
        ((CompletableFuture)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getDocumentFormattingProvider)).collectAll((wrapper, ls) -> CompletableFuture.completedFuture(jstsDef.equals(wrapper.serverDefinition) ? ls : null)).thenAccept(servers::addAll)).get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)servers.isEmpty(), (String)"Expected running JSTS server for document");
        LanguageServer jsts = (LanguageServer)servers.get(0);
        Supplier<String> formatWithCurrentPrefs = () -> {
            try {
                FormattingOptions opts = new FormattingOptions(4, true);
                DocumentFormattingParams params = new DocumentFormattingParams(new TextDocumentIdentifier(LSPEclipseUtils.toUri((IDocument)document).toString()), opts);
                List edits = (List)jsts.getTextDocumentService().formatting(params).get(10L, TimeUnit.SECONDS);
                return TestTypeScriptFormattingPreferences.applyTextEdits(original, edits);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        String formattedIndent4 = formatWithCurrentPrefs.get();
        int indent4 = TestTypeScriptFormattingPreferences.leadingSpacesOfLineStartingWith(formattedIndent4, "return 1");
        Assertions.assertTrue((indent4 >= 0 ? 1 : 0) != 0, (String)"Could not locate return line in formatted output");
        Activator.getDefault().getPreferenceStore().setValue(JSTSLanguagePreferences.TS.format_indentSize, 2);
        DisplayHelper.sleep((long)1500L);
        String formattedIndent2 = formatWithCurrentPrefs.get();
        int indent2 = TestTypeScriptFormattingPreferences.leadingSpacesOfLineStartingWith(formattedIndent2, "return 1");
        Assertions.assertTrue((indent2 >= 0 ? 1 : 0) != 0, (String)"Could not locate return line after indentSize=2 change");
        Activator.getDefault().getPreferenceStore().setValue(JSTSLanguagePreferences.TS.format_indentSize, 6);
        DisplayHelper.sleep((long)1500L);
        String formattedIndent6 = formatWithCurrentPrefs.get();
        int indent6 = TestTypeScriptFormattingPreferences.leadingSpacesOfLineStartingWith(formattedIndent6, "return 1");
        Assertions.assertTrue((indent6 >= 0 ? 1 : 0) != 0, (String)"Could not locate return line after indentSize=6 change");
        Assertions.assertNotEquals((int)indent4, (int)indent2, (String)"Indent should change when indentSize changes to 2");
        Assertions.assertNotEquals((int)indent2, (int)indent6, (String)"Indent should change when indentSize changes to 6");
        Assertions.assertTrue((indent6 > indent2 ? 1 : 0) != 0, () -> "Expected indent6(" + indent6 + ") > indent2(" + indent2 + ")");
    }

    private static String applyTextEdits(String original, List<? extends TextEdit> edits) {
        if (edits == null || edits.isEmpty()) {
            return original;
        }
        Document doc = new Document(original);
        edits.stream().sorted(Comparator.comparing(e -> e.getRange().getStart().getLine()).thenComparing(e -> e.getRange().getStart().getCharacter()).reversed()).forEach(e -> TestTypeScriptFormattingPreferences.replace((IDocument)doc, e.getRange(), e.getNewText()));
        return doc.get();
    }

    private static void replace(IDocument doc, Range range, String newText) {
        try {
            int start = LSPEclipseUtils.toOffset((Position)range.getStart(), (IDocument)doc);
            int end = LSPEclipseUtils.toOffset((Position)range.getEnd(), (IDocument)doc);
            doc.replace(start, end - start, newText);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private static int leadingSpacesOfLineStartingWith(String text, String token) {
        String[] lines;
        String[] stringArray = lines = text.split("\r?\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int i = 0;
            while (i < line.length() && line.charAt(i) == ' ') {
                ++i;
            }
            if (line.substring(i).startsWith(token)) {
                return i;
            }
            ++n2;
        }
        return -1;
    }
}

