/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public final class UI {
    public static @Nullable IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = UI.getActiveWindow();
        return window == null ? null : window.getActivePage();
    }

    public static @Nullable IWorkbenchPart getActivePart() {
        IWorkbenchPage page = UI.getActivePage();
        return page == null ? null : page.getActivePart();
    }

    public static @Nullable Shell getActiveShell() {
        IWorkbenchWindow window = UI.getActiveWindow();
        return window == null ? null : window.getShell();
    }

    public static @Nullable ITextEditor getActiveTextEditor() {
        IWorkbenchPage activePage = UI.getActivePage();
        if (activePage == null) {
            return null;
        }
        return UI.asTextEditor(activePage.getActiveEditor());
    }

    public static @Nullable ITextEditor asTextEditor(@Nullable IEditorPart editorPart) {
        MultiPageEditorPart multiPageEditorPart;
        Object object;
        if (editorPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            return textEditor;
        }
        if (editorPart instanceof MultiPageEditorPart && (object = (multiPageEditorPart = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)object;
            return textEditor;
        }
        return null;
    }

    public static @Nullable ITextViewer asTextViewer(@Nullable IEditorPart editorPart) {
        if (editorPart != null) {
            return (ITextViewer)editorPart.getAdapter(ITextViewer.class);
        }
        return null;
    }

    public static @Nullable ITextViewer getActiveTextViewer() {
        return UI.asTextViewer((IEditorPart)UI.getActiveTextEditor());
    }

    public static @Nullable IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        Display display = Display.getCurrent();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }

    public static void runOnUIThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            UI.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private UI() {
    }
}

