/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class Settings
extends HashMap<String, Object> {
    private IPreferenceStore store;

    public Settings(IPreferenceStore store) {
        this.store = store;
    }

    public void fillAsBoolean(String preferenceId) {
        boolean preferenceValue = this.store.getBoolean(preferenceId);
        this.fillSetting(preferenceId, preferenceValue);
    }

    public void fillAsInt(String preferenceId) {
        int preferenceValue = this.store.getInt(preferenceId);
        this.fillSetting(preferenceId, preferenceValue);
    }

    public void fillAsString(String preferenceId) {
        String preferenceValue = this.store.getString(preferenceId);
        this.fillSetting(preferenceId, preferenceValue);
    }

    public void fillAsStringArray(String preferenceId, String separator) {
        String[] preferenceValue = this.store.getString(preferenceId).split(separator);
        this.fillSetting(preferenceId, preferenceValue);
    }

    public void fillSetting(String preferenceId, Object preferenceValue) {
        Settings.fillSetting(preferenceId, preferenceValue, this);
    }

    private static void fillSetting(String preferenceId, Object preferenceValue, Map<String, Object> settings) {
        HashMap<String, Object> result = settings;
        String[] paths = preferenceId.split("[.]");
        String path = null;
        int i = 0;
        while (i < paths.length - 1) {
            path = paths[i];
            if (result.containsKey(path)) {
                result = (HashMap<String, Object>)result.get(path);
            } else {
                HashMap<String, Object> item = new HashMap<String, Object>();
                result.put(path, item);
                result = item;
            }
            ++i;
        }
        path = paths[paths.length - 1];
        result.put(path, preferenceValue);
    }

    public Object findSettings(String[] sections) {
        Map<String, Object> current = this;
        String[] stringArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            Object result = current.get(section);
            if (result == null || !(result instanceof Map)) {
                return null;
            }
            current = (Map)result;
            ++n2;
        }
        return current;
    }

    public static boolean isMatchSection(String property, String section) {
        return property.equals(section) || property.startsWith(String.valueOf(section) + ".");
    }
}

