/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.JoinTable;
import org.eclipse.dali.core.impl.PersistenceProjectImpl;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.JoinColumnItemProvider;
import org.eclipse.dali.edit.JoinTableItemProvider;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.InverseJoinColumnDialog;
import org.eclipse.dali.ui.views.JoinColumnDialog;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JoinTableComposite
extends Composite
implements IPersistenceComposite {
    private JoinTable joinTable;
    private JoinTableItemProvider joinTableItemProvider;
    private INotifyChangedListener tableListener;
    protected EditingDomain editingDomain;
    protected Combo tableCombo;
    protected boolean populating;
    private ListViewer joinColumnsListViewer;
    private ListViewer inverseJoinColumnsListViewer;
    private JoinColumnItemProvider joinColumnItemProvider;
    private INotifyChangedListener joinColumnListener;
    private INotifyChangedListener inverseJoinColumnListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JoinTableComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.joinTableItemProvider = (JoinTableItemProvider)adapterFactory.createJoinTableAdapter();
        this.joinColumnItemProvider = (JoinColumnItemProvider)adapterFactory.createJoinColumnAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group joinTableGroup = new Group((Composite)this, 16);
        joinTableGroup.setText("Join Table");
        joinTableGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        joinTableGroup.setLayoutData((Object)gridData);
        Label tableLabel = new Label((Composite)joinTableGroup, 16384);
        tableLabel.setText("Name:");
        this.tableCombo = this.buildTableCombo((Composite)joinTableGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        Group joinColumnsGroup = new Group((Composite)joinTableGroup, 16);
        joinColumnsGroup.setText("Join Columns");
        joinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        joinColumnsGroup.setLayoutData((Object)gridData);
        this.joinColumnsListViewer = new ListViewer((Composite)joinColumnsGroup, 2048);
        this.joinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.joinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnsListViewer.getList().setLayoutData((Object)gridData);
        Button addJoinColumnButton = new Button((Composite)joinColumnsGroup, 0);
        addJoinColumnButton.setText("Add...");
        addJoinColumnButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        final Button editJoinColumnButton = new Button((Composite)joinColumnsGroup, 0);
        editJoinColumnButton.setText("Edit...");
        editJoinColumnButton.setEnabled(false);
        editJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        editJoinColumnButton.setLayoutData((Object)gridData);
        Button removeJoinColumnButton = new Button((Composite)joinColumnsGroup, 0);
        removeJoinColumnButton.setText("Remove");
        removeJoinColumnButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        removeJoinColumnButton.setLayoutData((Object)gridData);
        this.joinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editJoinColumnButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Group inverseJoinColumnsGroup = new Group((Composite)joinTableGroup, 16);
        inverseJoinColumnsGroup.setText("Inverse Join Columns");
        inverseJoinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        inverseJoinColumnsGroup.setLayoutData((Object)gridData);
        this.inverseJoinColumnsListViewer = new ListViewer((Composite)inverseJoinColumnsGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.inverseJoinColumnsListViewer.getList().setLayoutData((Object)gridData);
        this.inverseJoinColumnsListViewer.setContentProvider(this.buildInverseJoinColumnsListContentProvider());
        this.inverseJoinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildInverseJoinColumnsListLabelProvider());
        Button addInverseJoinColumnButton = new Button((Composite)inverseJoinColumnsGroup, 0);
        addInverseJoinColumnButton.setText("Add...");
        addInverseJoinColumnButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addInverseJoinColumnButton.setLayoutData((Object)gridData);
        final Button editInverseJoinColumnButton = new Button((Composite)inverseJoinColumnsGroup, 0);
        editInverseJoinColumnButton.setText("Edit...");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        editInverseJoinColumnButton.setLayoutData((Object)gridData);
        editInverseJoinColumnButton.setEnabled(false);
        editInverseJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editInverseJoinColumn();
            }
        });
        Button removeInverseJoinColumnButton = new Button((Composite)inverseJoinColumnsGroup, 0);
        removeInverseJoinColumnButton.setText("Remove");
        removeInverseJoinColumnButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        removeInverseJoinColumnButton.setLayoutData((Object)gridData);
        this.inverseJoinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editInverseJoinColumnButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((JoinTable)inputElement).getJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                if (JoinTableComposite.this.joinTable.isDefaultJoinColumns()) {
                    return JoinTableComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return JoinTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private String buildDefaultJoinColumnLabel(JoinColumn joinColumn) {
        return "Default (" + joinColumn.getName() + "->" + joinColumn.getReferencedColumnName() + ")";
    }

    private String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return "Default (" + joinColumn.getName() + ") -> Default (" + joinColumn.getReferencedColumnName() + ")";
            }
            return "Default (" + joinColumn.getName() + ") -> " + joinColumn.getReferencedColumnName();
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return String.valueOf(joinColumn.getName()) + " -> Default (" + joinColumn.getReferencedColumnName() + ")";
        }
        return String.valueOf(joinColumn.getName()) + " -> " + joinColumn.getReferencedColumnName();
    }

    private ILabelProvider buildInverseJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                if (JoinTableComposite.this.joinTable.isDefaultInverseJoinColumns()) {
                    return JoinTableComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return JoinTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private IContentProvider buildInverseJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((JoinTable)inputElement).getInverseJoinColumns().toArray();
            }
        };
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JoinTableComposite.this.populating) {
                    return;
                }
                String tableText = ((Combo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (JoinTableComposite.this.joinTable.getSpecifiedName() == null || JoinTableComposite.this.joinTable.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (JoinTableComposite.this.joinTable.getSpecifiedName() == null || !JoinTableComposite.this.joinTable.getSpecifiedName().equals(tableText)) {
                    JoinTableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinTableComposite.this.editingDomain, (Object)JoinTableComposite.this.joinTable, (Object)DaliPackage.eINSTANCE.getTable_SpecifiedName(), (Object)tableText));
                }
            }
        });
        return combo;
    }

    private void editJoinColumn() {
        JoinColumn joinColumn = this.getSelectedJoinColumn();
        JoinColumnDialog dialog = new JoinColumnDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private PersistenceProjectImpl getPersistenceProject() {
        return this.joinTable.getPersistenceProject();
    }

    private void editJoinColumnFromDialog(JoinColumnDialog dialog, JoinColumn joinColumn) {
        if (dialog.open() == 0) {
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            if (dialog.isDefaultNameSelected()) {
                if (joinColumn.getSpecifiedName() != null) {
                    this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedName(), null));
                }
            } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
            }
            if (dialog.isDefaultReferencedColumnNameSelected()) {
                if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                    this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), null));
                }
            } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
            }
        }
    }

    private void editInverseJoinColumn() {
        JoinColumn joinColumn = this.getSelectedInverseJoinColumn();
        InverseJoinColumnDialog dialog = new InverseJoinColumnDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private JoinColumn getSelectedJoinColumn() {
        return (JoinColumn)((StructuredSelection)this.joinColumnsListViewer.getSelection()).getFirstElement();
    }

    private JoinColumn getSelectedInverseJoinColumn() {
        return (JoinColumn)((StructuredSelection)this.inverseJoinColumnsListViewer.getSelection()).getFirstElement();
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.tableChanged(notification);
                }
            };
        }
        return this.tableListener;
    }

    protected void tableChanged(Notification notification) {
        if (notification.getFeatureID(JoinTable.class) == 1) {
            final String tableName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (JoinTableComposite.this.tableCombo.getText() == null || !JoinTableComposite.this.tableCombo.getText().equals(tableName)) {
                        if (tableName == null) {
                            JoinTableComposite.this.tableCombo.select(0);
                        } else {
                            JoinTableComposite.this.tableCombo.setText(tableName);
                        }
                    }
                }
            });
        } else if (notification.getFeatureID(JoinTable.class) == 0) {
            final String defaultTableName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int selectionIndex = JoinTableComposite.this.tableCombo.getSelectionIndex();
                    JoinTableComposite.this.tableCombo.setItem(0, "Default (" + defaultTableName + ")");
                    if (selectionIndex == 0) {
                        JoinTableComposite.this.tableCombo.select(0);
                    }
                }
            });
        } else if (notification.getFeatureID(JoinTable.class) == 7) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    JoinTableComposite.this.joinColumnsListViewer.refresh();
                }
            });
        } else if (notification.getFeatureID(JoinTable.class) == 8) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    JoinTableComposite.this.inverseJoinColumnsListViewer.refresh();
                }
            });
        } else if (notification.getFeatureID(JoinTable.class) == 5 || notification.getFeatureID(JoinTable.class) == 6) {
            if (notification.getEventType() == 3) {
                ((JoinColumn)notification.getNewValue()).eAdapters().add((Object)this.joinColumnItemProvider);
            } else if (notification.getEventType() == 4) {
                ((JoinColumn)notification.getNewValue()).eAdapters().add((Object)this.joinColumnItemProvider);
            }
        }
    }

    private INotifyChangedListener getJoinColumnListener() {
        if (this.joinColumnListener == null) {
            this.joinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.joinColumnChanged(notification, JoinTableComposite.this.joinColumnsListViewer);
                }
            };
        }
        return this.joinColumnListener;
    }

    private INotifyChangedListener getInverseJoinColumnListener() {
        if (this.inverseJoinColumnListener == null) {
            this.inverseJoinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.joinColumnChanged(notification, JoinTableComposite.this.inverseJoinColumnsListViewer);
                }
            };
        }
        return this.inverseJoinColumnListener;
    }

    protected void joinColumnChanged(Notification notification, final ListViewer listViewer) {
        if (notification.getFeatureID(JoinColumn.class) == 4 || notification.getFeatureID(JoinColumn.class) == 7 || notification.getFeatureID(JoinColumn.class) == 1 || notification.getFeatureID(JoinColumn.class) == 3 || notification.getFeatureID(JoinColumn.class) == 6 || notification.getFeatureID(JoinColumn.class) == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    listViewer.refresh();
                }
            });
        }
    }

    public void populate(EObject model) {
        Iterator i;
        this.populating = true;
        if (this.joinTable != null) {
            this.joinTableItemProvider.removeListener(this.getTableListener());
            this.joinColumnItemProvider.removeListener(this.getJoinColumnListener());
            this.joinColumnItemProvider.removeListener(this.getInverseJoinColumnListener());
            this.joinTable.eAdapters().remove((Object)this.joinTableItemProvider);
            i = this.joinTable.getJoinColumns().iterator();
            while (i.hasNext()) {
                ((JoinColumn)i.next()).eAdapters().remove((Object)this.joinColumnItemProvider);
            }
        }
        this.joinTable = (JoinTable)model;
        if (this.joinTable == null) {
            this.joinColumnsListViewer.setInput(null);
            this.inverseJoinColumnsListViewer.setInput(null);
            return;
        }
        this.joinTableItemProvider.addListener(this.getTableListener());
        this.joinColumnItemProvider.addListener(this.getJoinColumnListener());
        this.joinColumnItemProvider.addListener(this.getInverseJoinColumnListener());
        this.joinTable.eAdapters().add((Object)this.joinTableItemProvider);
        i = this.joinTable.getJoinColumns().iterator();
        while (i.hasNext()) {
            ((JoinColumn)i.next()).eAdapters().add((Object)this.joinColumnItemProvider);
        }
        this.populateTableCombo();
        this.joinColumnsListViewer.setInput((Object)this.joinTable);
        this.inverseJoinColumnsListViewer.setInput((Object)this.joinTable);
        this.populating = false;
    }

    private void populateTableCombo() {
        ConnectionInfoWrapper connectionInfo;
        String tableName = this.joinTable.getSpecifiedName();
        String defaultTableName = this.joinTable.getDefaultName();
        int selectionIndex = this.tableCombo.getSelectionIndex();
        this.tableCombo.setItem(0, "Default (" + defaultTableName + ")");
        if (selectionIndex == 0) {
            this.tableCombo.select(0);
        }
        if ((connectionInfo = this.getPersistenceProject().getConnectionInfo()).isConnected()) {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
            Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)connectionInfo.userTableNames(this.getPersistenceProject().getSchemaName()))).iterator();
            while (i.hasNext()) {
                this.tableCombo.add((String)i.next());
            }
        }
        if (tableName != null) {
            if (!this.tableCombo.getText().equals(tableName)) {
                this.tableCombo.setText(tableName);
            }
        } else if (!this.tableCombo.getText().equals("Default (" + defaultTableName + ")")) {
            this.tableCombo.select(0);
        }
    }
}

