/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.support;

import org.eclipse.vjet.dsf.dom.DErrUtil;
import org.eclipse.vjet.dsf.dom.support.XmlVerifier;

public class NSNameVerifier {
    public static void verifyNSPrefix(String prefix, String namespaceUri) {
        if (!XmlVerifier.isXMLName(prefix, false)) {
            DErrUtil.elementCharError(null, prefix, null);
        }
        if (prefix.indexOf(":") != -1) {
            DErrUtil.elementNSError(null, prefix, null);
        }
        if (namespaceUri == null) {
            DErrUtil.elementNSError(null, prefix, "null");
        }
        if (prefix.equals("xml") && !namespaceUri.equals("http://www.w3.org/XML/1998/namespace") || namespaceUri.equals("http://www.w3.org/XML/1998/namespace") && !prefix.equals("xml")) {
            DErrUtil.elementNSError(null, prefix, namespaceUri);
        } else if (prefix.equals("xmlns") && !namespaceUri.equals("http://www.w3.org/2000/xmlns/") || !prefix.equals("xmlns") && namespaceUri.equals("http://www.w3.org/2000/xmlns/")) {
            DErrUtil.elementNSError(null, prefix, namespaceUri);
        }
    }

    public static void verifyNSLocalName(String localName, String namespaceUri) {
        if (localName.indexOf(":") != -1) {
            DErrUtil.elementNSError(localName, null, null);
        }
        if (namespaceUri != null && (localName.equals("xmlns") && (namespaceUri == null || !namespaceUri.equals("http://www.w3.org/2000/xmlns/")) || namespaceUri != null && namespaceUri.equals("http://www.w3.org/2000/xmlns/") && !localName.equals("xmlns"))) {
            DErrUtil.elementNSError(localName, null, namespaceUri);
        }
    }

    public static void verifyNSUriName(String namespaceUri) {
        if (namespaceUri == null) {
            DErrUtil.elementNSError(null, null, "null");
        }
    }
}

