/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DNode;
import org.w3c.dom.NodeList;

public final class XPathResult {
    final DNode m_node;
    final XPathExpression m_xpathExpr;
    final String m_xpathExprString;

    XPathResult(DNode node, String xpathExpressionString) {
        this.m_node = node;
        this.m_xpathExpr = null;
        this.m_xpathExprString = xpathExpressionString;
    }

    XPathResult(DNode node, XPathExpression xpathExpression) {
        this.m_node = node;
        this.m_xpathExpr = xpathExpression;
        this.m_xpathExprString = null;
    }

    public Object getValue(QName retType) {
        return this.evalXPath(retType);
    }

    public DNode getNode() {
        Object o = this.evalXPath(XPathConstants.NODE);
        DNode node = (DNode)o;
        return node;
    }

    public NodeList getNodes() {
        Object o = this.evalXPath(XPathConstants.NODESET);
        NodeList list = (NodeList)o;
        return list;
    }

    public Boolean getBool() {
        return (Boolean)this.evalXPath(XPathConstants.BOOLEAN);
    }

    public String getStr() {
        return (String)this.evalXPath(XPathConstants.STRING);
    }

    public Number getNum() {
        return (Number)this.evalXPath(XPathConstants.NUMBER);
    }

    private Object evalXPath(QName retType) {
        return this.m_xpathExprString == null ? this.evalXPath(this.m_xpathExpr, retType) : this.evalXPath(this.m_xpathExprString, retType);
    }

    private Object evalXPath(XPathExpression xpathExpression, QName retType) {
        this.assertXPath(xpathExpression, retType);
        try {
            return xpathExpression.evaluate(this.m_node, retType);
        }
        catch (XPathExpressionException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private Object evalXPath(String xpathExpression, QName retType) {
        this.assertXPath(xpathExpression, retType);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xpathExpression);
            return expr.evaluate(this.m_node, retType);
        }
        catch (XPathExpressionException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private void assertXPath(Object xpathExpression, QName retType) {
        if (xpathExpression == null) {
            throw new DsfRuntimeException("XPath expression must not be null");
        }
        if (retType == null) {
            throw new DsfRuntimeException("XPath expressions return type must not be null");
        }
        if (retType != XPathConstants.BOOLEAN && retType != XPathConstants.NODE && retType != XPathConstants.NODESET && retType != XPathConstants.NUMBER && retType != XPathConstants.STRING) {
            throw new DsfRuntimeException("XPaths expression return type should be one of XPathConstants: BOOLEAN | NODE | NODESET | NUMBER | STRING");
        }
    }
}

