/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.common.statistics.IV4Statistics;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.util.XmlWriterHelper;

public class UnspecdCmpStatistics
implements IV4Statistics {
    public static final String NAME = "v4-unspec";
    private Map<String, Map<String, Set<String>>> m_unspecdInfo;

    @Override
    public String asString() {
        return XmlWriterHelper.asString(this.toXml());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void reset() {
        this.m_unspecdInfo.clear();
    }

    @Override
    public DElement toXml() {
        DElement tagUnSpec = new DElement(this.getName());
        if (this.m_unspecdInfo != null) {
            for (Map.Entry<String, Map<String, Set<String>>> entryPage : this.m_unspecdInfo.entrySet()) {
                DElement tagPage = new DElement("page");
                DElement tagPageName = new DElement("pageName");
                tagPageName.addRaw(entryPage.getKey());
                tagPage.add(tagPageName);
                tagUnSpec.add(tagPage);
                Map<String, Set<String>> pageInfo = entryPage.getValue();
                if (pageInfo == null) continue;
                for (Map.Entry<String, Set<String>> entryNode : pageInfo.entrySet()) {
                    DElement tagParentCmp = new DElement("parentCmp");
                    DElement tagParentName = new DElement("parentName");
                    tagParentName.addRaw(entryNode.getKey());
                    tagParentCmp.add(tagParentName);
                    tagPage.add(tagParentCmp);
                    Set<String> unspecCmps = entryNode.getValue();
                    if (unspecCmps == null) continue;
                    for (String cmp : unspecCmps) {
                        DElement tagCmp = new DElement("unspecdCmp");
                        tagCmp.addRaw(cmp);
                        tagParentCmp.add(tagCmp);
                    }
                }
            }
        }
        return tagUnSpec;
    }

    private Map<String, Map<String, Set<String>>> getUnspecdInfo() {
        if (this.m_unspecdInfo == null) {
            this.m_unspecdInfo = new ConcurrentHashMap<String, Map<String, Set<String>>>();
        }
        return this.m_unspecdInfo;
    }

    private Map<String, Set<String>> getPageInfo(String page) {
        Map<String, Map<String, Set<String>>> info = this.getUnspecdInfo();
        Map<String, Set<String>> pageInfo = info.get(page);
        if (pageInfo == null) {
            pageInfo = new ConcurrentHashMap<String, Set<String>>();
            info.put(page, pageInfo);
        }
        return pageInfo;
    }

    public void markUnspecdUsage(String page, String parentCmp, String unspecdCmp) {
        Map<String, Set<String>> pageInfo = this.getPageInfo(page);
        Set<String> info = pageInfo.get(parentCmp);
        if (info == null) {
            info = new HashSet<String>();
            pageInfo.put(parentCmp, info);
        }
        info.add(unspecdCmp);
    }
}

